/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.api;

import android.content.Context;
import android.util.Log;
import com.onegravity.rteditor.api.RTMediaFactory;
import com.onegravity.rteditor.api.media.RTAudio;
import com.onegravity.rteditor.api.media.RTAudioImpl;
import com.onegravity.rteditor.api.media.RTImage;
import com.onegravity.rteditor.api.media.RTImageImpl;
import com.onegravity.rteditor.api.media.RTMediaSource;
import com.onegravity.rteditor.api.media.RTMediaType;
import com.onegravity.rteditor.api.media.RTVideo;
import com.onegravity.rteditor.api.media.RTVideoImpl;
import com.onegravity.rteditor.media.MediaUtils;
import com.onegravity.rteditor.utils.Helper;
import com.onegravity.rteditor.utils.io.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RTMediaFactoryImpl
implements RTMediaFactory<RTImage, RTAudio, RTVideo> {
    private static final long serialVersionUID = 6970361368051595063L;
    private File mStoragePath;

    public RTMediaFactoryImpl(Context context) {
        this(context, true);
    }

    public RTMediaFactoryImpl(Context context, boolean externalStorage) {
        this.mStoragePath = externalStorage ? context.getExternalFilesDir(null) : context.getFilesDir();
    }

    protected String getAbsolutePath(RTMediaType mediaType) {
        File mediaPath = new File(this.mStoragePath.getAbsolutePath(), mediaType.mediaPath());
        if (!mediaPath.exists()) {
            mediaPath.mkdirs();
        }
        return mediaPath.getAbsolutePath();
    }

    @Override
    public RTImage createImage(RTMediaSource mediaSource) {
        File targetFile = this.loadMedia(mediaSource);
        return targetFile == null ? null : new RTImageImpl(targetFile.getAbsolutePath());
    }

    @Override
    public RTAudio createAudio(RTMediaSource mediaSource) {
        File targetFile = this.loadMedia(mediaSource);
        return targetFile == null ? null : new RTAudioImpl(targetFile.getAbsolutePath());
    }

    @Override
    public RTVideo createVideo(RTMediaSource mediaSource) {
        File targetFile = this.loadMedia(mediaSource);
        return targetFile == null ? null : new RTVideoImpl(targetFile.getAbsolutePath());
    }

    private File loadMedia(RTMediaSource mediaSource) {
        File targetPath = new File(this.getAbsolutePath(mediaSource.getMediaType()));
        File targetFile = MediaUtils.createUniqueFile(targetPath, mediaSource.getName(), mediaSource.getMimeType(), false);
        this.copyFile(mediaSource.getInputStream(), targetFile);
        return targetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(InputStream in, File targetFile) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(targetFile);
            IOUtils.copy(in, (OutputStream)out);
        }
        catch (IOException ioe) {
            try {
                Log.e((String)this.getClass().getSimpleName(), (String)ioe.getMessage(), (Throwable)ioe);
            }
            catch (Throwable throwable) {
                Helper.closeQuietly(out);
                Helper.closeQuietly(in);
                throw throwable;
            }
            Helper.closeQuietly(out);
            Helper.closeQuietly(in);
        }
        Helper.closeQuietly(out);
        Helper.closeQuietly(in);
    }

    @Override
    public RTImage createImage(String path) {
        return new RTImageImpl(path);
    }

    @Override
    public RTAudio createAudio(String path) {
        return new RTAudioImpl(path);
    }

    @Override
    public RTVideo createVideo(String path) {
        return new RTVideoImpl(path);
    }
}

