/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor;

import android.content.Context;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Editable;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextWatcher;
import android.text.style.ParagraphStyle;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatEditText;
import com.onegravity.rteditor.ClonedSpannableString;
import com.onegravity.rteditor.RTEditTextListener;
import com.onegravity.rteditor.RTEditorMovementMethod;
import com.onegravity.rteditor.api.RTMediaFactory;
import com.onegravity.rteditor.api.format.RTEditable;
import com.onegravity.rteditor.api.format.RTFormat;
import com.onegravity.rteditor.api.format.RTHtml;
import com.onegravity.rteditor.api.format.RTPlainText;
import com.onegravity.rteditor.api.format.RTText;
import com.onegravity.rteditor.api.media.RTAudio;
import com.onegravity.rteditor.api.media.RTImage;
import com.onegravity.rteditor.api.media.RTMedia;
import com.onegravity.rteditor.api.media.RTVideo;
import com.onegravity.rteditor.effects.Effect;
import com.onegravity.rteditor.effects.Effects;
import com.onegravity.rteditor.spans.BulletSpan;
import com.onegravity.rteditor.spans.LinkSpan;
import com.onegravity.rteditor.spans.MediaSpan;
import com.onegravity.rteditor.spans.NumberSpan;
import com.onegravity.rteditor.spans.RTSpan;
import com.onegravity.rteditor.utils.Paragraph;
import com.onegravity.rteditor.utils.RTLayout;
import com.onegravity.rteditor.utils.Selection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class RTEditText
extends AppCompatEditText
implements TextWatcher,
SpanWatcher,
LinkSpan.LinkSpanListener {
    private boolean mUseRTFormatting = true;
    private boolean mLayoutChanged;
    private RTLayout mRTLayout;
    private boolean mIsSaving;
    private boolean mIsSelectionChanging = false;
    private boolean mTextChanged;
    private boolean mTextSelected;
    private RTEditTextListener mListener;
    private RTMediaFactory<RTImage, RTAudio, RTVideo> mMediaFactory;
    private int mOldSelStart = -1;
    private int mOldSelEnd = -1;
    private boolean mParagraphsAreUp2Date;
    private boolean mIgnoreParagraphChanges;
    private boolean mIgnoreTextChanges;
    private boolean mIsBulletSpanSelected;
    private boolean mIsNumberSpanSelected;
    private int mPreviousTextLength;
    private int mSelStartBefore;
    private int mSelEndBefore;
    private String mOldText;
    private String mNewText;
    private Spannable mOldSpannable;
    private Set<RTMedia> mOriginalMedia = new HashSet<RTMedia>();
    private Set<RTMedia> mAddedMedia = new HashSet<RTMedia>();

    public RTEditText(Context context) {
        super(context);
        this.init();
    }

    public RTEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public RTEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.addTextChangedListener(this);
        this.setMovementMethod(RTEditorMovementMethod.getInstance());
    }

    void onDestroy(boolean isSaved) {
        HashSet<RTMedia> mCurrentMedia = new HashSet<RTMedia>();
        Editable text = this.getText();
        for (MediaSpan mediaSpan : (MediaSpan[])text.getSpans(0, text.length(), MediaSpan.class)) {
            mCurrentMedia.add(mediaSpan.getMedia());
        }
        Set<Object> mMedia2Delete = isSaved ? this.mOriginalMedia : mCurrentMedia;
        mMedia2Delete.addAll(this.mAddedMedia);
        Set<Object> mMedia2Keep = isSaved ? mCurrentMedia : this.mOriginalMedia;
        for (RTMedia rTMedia : mMedia2Delete) {
            if (mMedia2Keep.contains(rTMedia)) continue;
            rTMedia.remove();
        }
    }

    void onAddMedia(RTMedia media) {
        this.mAddedMedia.add(media);
    }

    void register(RTEditTextListener listener, RTMediaFactory<RTImage, RTAudio, RTVideo> mediaFactory) {
        this.mListener = listener;
        this.mMediaFactory = mediaFactory;
    }

    void unregister() {
        this.mListener = null;
    }

    public ArrayList<Paragraph> getParagraphs() {
        return this.getRTLayout().getParagraphs();
    }

    public Selection getParagraphsInSelection() {
        RTLayout layout2 = this.getRTLayout();
        Selection selection = new Selection((EditText)this);
        int firstLine = layout2.getLineForOffset(selection.start());
        int end = selection.isEmpty() ? selection.end() : selection.end() - 1;
        int lastLine = layout2.getLineForOffset(end);
        return new Selection(layout2.getLineStart(firstLine), layout2.getLineEnd(lastLine));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RTLayout getRTLayout() {
        RTEditText rTEditText = this;
        synchronized (rTEditText) {
            if (this.mRTLayout == null || this.mLayoutChanged) {
                this.mRTLayout = new RTLayout((Spanned)this.getText());
                this.mLayoutChanged = false;
            }
        }
        return this.mRTLayout;
    }

    Selection getSelection() {
        int selStart = this.getSelectionStart();
        int selEnd = this.getSelectionEnd();
        return new Selection(selStart, selEnd);
    }

    String getSelectedText() {
        Editable text = this.getText();
        Selection sel = this.getSelection();
        if (sel.start() >= 0 && sel.end() >= 0 && sel.end() <= text.length()) {
            return text.subSequence(sel.start(), sel.end()).toString();
        }
        return null;
    }

    public Spannable cloneSpannable() {
        Editable text = super.getText();
        return new ClonedSpannableString((CharSequence)(text != null ? text : ""));
    }

    public void setRichTextEditing(boolean useRTFormatting, boolean autoConvert) {
        this.assertRegistration();
        if (useRTFormatting != this.mUseRTFormatting) {
            this.mUseRTFormatting = useRTFormatting;
            if (autoConvert) {
                RTFormat targetFormat = useRTFormatting ? RTFormat.PLAIN_TEXT : RTFormat.HTML;
                this.setText(this.getRichText(targetFormat));
            }
            if (this.mListener != null) {
                this.mListener.onRichTextEditingChanged(this, this.mUseRTFormatting);
            }
        }
    }

    public void setRichTextEditing(boolean useRTFormatting, String content) {
        this.assertRegistration();
        if (useRTFormatting != this.mUseRTFormatting) {
            this.mUseRTFormatting = useRTFormatting;
            if (this.mListener != null) {
                this.mListener.onRichTextEditingChanged(this, this.mUseRTFormatting);
            }
        }
        RTText rtText = useRTFormatting ? new RTHtml(RTFormat.HTML, (CharSequence)content) : new RTPlainText(content);
        this.setText(rtText);
    }

    public void setText(RTText rtText) {
        this.assertRegistration();
        if (rtText.getFormat() instanceof RTFormat.Html) {
            if (this.mUseRTFormatting) {
                RTText rtSpanned = rtText.convertTo(RTFormat.SPANNED, this.mMediaFactory);
                super.setText(rtSpanned.getText(), TextView.BufferType.EDITABLE);
                this.addSpanWatcher();
                Editable text = this.getText();
                for (MediaSpan span : (MediaSpan[])text.getSpans(0, text.length(), MediaSpan.class)) {
                    this.mOriginalMedia.add(span.getMedia());
                }
                Effects.cleanupParagraphs(this, new Effect[0]);
            } else {
                RTText rtPlainText = rtText.convertTo(RTFormat.PLAIN_TEXT, this.mMediaFactory);
                super.setText(rtPlainText.getText());
            }
        } else if (rtText.getFormat() instanceof RTFormat.PlainText) {
            CharSequence text = rtText.getText();
            super.setText((CharSequence)(text == null ? "" : text.toString()));
        }
        this.onSelectionChanged(0, 0);
    }

    public boolean usesRTFormatting() {
        return this.mUseRTFormatting;
    }

    public String getText(RTFormat format) {
        return this.getRichText(format).getText().toString();
    }

    public RTText getRichText(RTFormat format) {
        this.assertRegistration();
        RTEditable rtEditable = new RTEditable(this);
        return rtEditable.convertTo(format, this.mMediaFactory);
    }

    private void assertRegistration() {
        if (this.mMediaFactory == null) {
            throw new IllegalStateException("The RTMediaFactory is null. Please make sure to register the editor at the RTManager before using it.");
        }
    }

    public boolean hasChanged() {
        return this.mTextChanged;
    }

    public void resetHasChanged() {
        this.mTextChanged = false;
        this.setParagraphsAreUp2Date(false);
    }

    synchronized void ignoreTextChanges() {
        this.mIgnoreTextChanges = true;
    }

    synchronized void registerTextChanges() {
        this.mIgnoreTextChanges = false;
    }

    public synchronized void beforeTextChanged(CharSequence s, int start, int count, int after) {
        String oldText;
        String string2 = oldText = this.mOldText == null ? "" : this.mOldText;
        if (!this.mIgnoreTextChanges && !s.toString().equals(oldText)) {
            this.mSelStartBefore = this.getSelectionStart();
            this.mSelEndBefore = this.getSelectionEnd();
            this.mNewText = this.mOldText = s.toString();
            this.mOldSpannable = this.cloneSpannable();
        }
        this.mLayoutChanged = true;
        this.mPreviousTextLength = s.length();
    }

    public synchronized void onTextChanged(CharSequence s, int start, int before, int count) {
        this.mLayoutChanged = true;
    }

    public synchronized void afterTextChanged(Editable s) {
        String newText;
        if (this.mIsBulletSpanSelected || this.mIsNumberSpanSelected) {
            boolean mBackSpace;
            boolean bl = mBackSpace = this.mPreviousTextLength >= s.length();
            if (!mBackSpace && s.toString().endsWith("\n")) {
                this.append("\u200b");
            }
        }
        String theText = s.toString();
        String string2 = newText = this.mNewText == null ? "" : this.mNewText;
        if (this.mListener != null && !this.mIgnoreTextChanges && !newText.equals(theText)) {
            Spannable newSpannable = this.cloneSpannable();
            this.mListener.onTextChanged(this, this.mOldSpannable, newSpannable, this.mSelStartBefore, this.mSelEndBefore, this.getSelectionStart(), this.getSelectionEnd());
            this.mNewText = theText;
        }
        this.mLayoutChanged = true;
        this.mTextChanged = true;
        this.setParagraphsAreUp2Date(false);
        this.addSpanWatcher();
    }

    public void onSpanAdded(Spannable text, Object what, int start, int end) {
        this.mTextChanged = true;
        if (what instanceof BulletSpan) {
            this.mIsBulletSpanSelected = true;
            if (text.toString().isEmpty()) {
                this.append("\u200b");
            }
        } else if (what instanceof NumberSpan) {
            this.mIsNumberSpanSelected = true;
            if (text.toString().isEmpty()) {
                this.append("\u200b");
            }
        }
        if (what instanceof RTSpan && what instanceof ParagraphStyle) {
            this.setParagraphsAreUp2Date(false);
        }
    }

    public void onSpanChanged(Spannable text, Object what, int ostart, int oend, int nstart, int nend) {
        this.mTextChanged = true;
        if (what instanceof RTSpan && what instanceof ParagraphStyle) {
            this.setParagraphsAreUp2Date(false);
        }
    }

    public void onSpanRemoved(Spannable text, Object what, int start, int end) {
        this.mTextChanged = true;
        if (what instanceof BulletSpan) {
            this.mIsBulletSpanSelected = false;
        } else if (what instanceof NumberSpan) {
            this.mIsNumberSpanSelected = false;
        }
        if (what instanceof RTSpan && what instanceof ParagraphStyle) {
            this.setParagraphsAreUp2Date(false);
        }
    }

    private void addSpanWatcher() {
        Editable spannable = this.getText();
        if (spannable.getSpans(0, spannable.length(), this.getClass()) != null) {
            spannable.setSpan((Object)this, 0, spannable.length(), 18);
        }
    }

    private synchronized void setParagraphsAreUp2Date(boolean value) {
        if (!this.mIgnoreParagraphChanges) {
            this.mParagraphsAreUp2Date = value;
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        if (!this.mUseRTFormatting || hasWindowFocus || !this.mTextSelected) {
            super.onWindowFocusChanged(hasWindowFocus);
        }
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (this.mUseRTFormatting && this.mListener != null) {
            this.mListener.onFocusChanged(this, focused);
        }
    }

    public Parcelable onSaveInstanceState() {
        this.mIsSaving = true;
        Parcelable superState = super.onSaveInstanceState();
        String content = this.getText(this.mUseRTFormatting ? RTFormat.HTML : RTFormat.PLAIN_TEXT);
        SavedState savedState = new SavedState(superState, this.mUseRTFormatting, content);
        this.mIsSaving = false;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof SavedState) {
            SavedState savedState = (SavedState)state;
            super.onRestoreInstanceState(savedState.getSuperState());
            this.setRichTextEditing(savedState.useRTFormatting(), savedState.getContent());
        } else {
            super.onRestoreInstanceState(state);
        }
        if (this.mListener != null) {
            this.mListener.onRestoredInstanceState(this);
        }
    }

    protected void onSelectionChanged(int start, int end) {
        if (this.mOldSelStart != start || this.mOldSelEnd != end) {
            this.mOldSelStart = start;
            this.mOldSelEnd = end;
            this.mTextSelected = end > start;
            super.onSelectionChanged(start, end);
            if (this.mUseRTFormatting) {
                if (!this.mIsSaving && !this.mParagraphsAreUp2Date) {
                    this.mIgnoreParagraphChanges = true;
                    Effects.cleanupParagraphs(this, new Effect[0]);
                    this.mIgnoreParagraphChanges = false;
                    this.setParagraphsAreUp2Date(true);
                }
                if (this.mListener != null) {
                    this.mIsSelectionChanging = true;
                    this.mListener.onSelectionChanged(this, start, end);
                    this.mIsSelectionChanging = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, C extends RTSpan<V>> void applyEffect(Effect<V, C> effect, V value) {
        if (this.mUseRTFormatting && !this.mIsSelectionChanging && !this.mIsSaving) {
            Spannable oldSpannable = this.mIgnoreTextChanges ? null : this.cloneSpannable();
            effect.applyToSelection(this, value);
            RTEditText rTEditText = this;
            synchronized (rTEditText) {
                if (this.mListener != null && !this.mIgnoreTextChanges) {
                    Spannable newSpannable = this.cloneSpannable();
                    this.mListener.onTextChanged(this, oldSpannable, newSpannable, this.getSelectionStart(), this.getSelectionEnd(), this.getSelectionStart(), this.getSelectionEnd());
                }
                this.mLayoutChanged = true;
            }
        }
    }

    @Override
    public void onClick(LinkSpan linkSpan) {
        if (this.mUseRTFormatting && this.mListener != null) {
            this.mListener.onClick(this, linkSpan);
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        private String mContent;
        private boolean mUseRTFormatting;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState, boolean useRTFormatting, String content) {
            super(superState);
            this.mUseRTFormatting = useRTFormatting;
            this.mContent = content;
        }

        private String getContent() {
            return this.mContent;
        }

        private boolean useRTFormatting() {
            return this.mUseRTFormatting;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mUseRTFormatting = in.readInt() == 1;
            this.mContent = in.readString();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.mUseRTFormatting ? 1 : 0);
            out.writeString(this.mContent);
        }
    }
}

