/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.utils;

import android.text.TextUtils;
import droidninja.filepicker.FilePickerConst;
import droidninja.filepicker.utils.FilePickerUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Ldroidninja/filepicker/utils/FileUtils;", "", "()V", "getFileType", "Ldroidninja/filepicker/FilePickerConst$FILE_TYPE;", "path", "", "isDocFile", "", "isExcelFile", "isPDFFile", "isPPTFile", "isTxtFile", "filepicker_release"})
public final class FileUtils {
    public static final FileUtils INSTANCE;

    @NotNull
    public final FilePickerConst.FILE_TYPE getFileType(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String fileExtension = FilePickerUtils.INSTANCE.getFileExtension(new File(path));
        if (TextUtils.isEmpty((CharSequence)fileExtension)) {
            return FilePickerConst.FILE_TYPE.UNKNOWN;
        }
        if (this.isExcelFile(path)) {
            return FilePickerConst.FILE_TYPE.EXCEL;
        }
        if (this.isDocFile(path)) {
            return FilePickerConst.FILE_TYPE.WORD;
        }
        if (this.isPPTFile(path)) {
            return FilePickerConst.FILE_TYPE.PPT;
        }
        if (this.isPDFFile(path)) {
            return FilePickerConst.FILE_TYPE.PDF;
        }
        return this.isTxtFile(path) ? FilePickerConst.FILE_TYPE.TXT : FilePickerConst.FILE_TYPE.UNKNOWN;
    }

    public final boolean isExcelFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String[] types = new String[]{"xls", "xlsx"};
        return FilePickerUtils.INSTANCE.contains(types, path);
    }

    public final boolean isDocFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String[] types = new String[]{"doc", "docx", "dot", "dotx"};
        return FilePickerUtils.INSTANCE.contains(types, path);
    }

    public final boolean isPPTFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String[] types = new String[]{"ppt", "pptx"};
        return FilePickerUtils.INSTANCE.contains(types, path);
    }

    public final boolean isPDFFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String[] types = new String[]{"pdf"};
        return FilePickerUtils.INSTANCE.contains(types, path);
    }

    public final boolean isTxtFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String[] types = new String[]{"txt"};
        return FilePickerUtils.INSTANCE.contains(types, path);
    }

    private FileUtils() {
    }

    static {
        FileUtils fileUtils;
        INSTANCE = fileUtils = new FileUtils();
    }
}

