/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.utils;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import androidx.annotation.WorkerThread;
import java.net.URISyntaxException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b\u00a8\u0006\u000f"}, d2={"Ldroidninja/filepicker/utils/ContentUriUtils;", "", "()V", "getFilePath", "", "context", "Landroid/content/Context;", "fileUri", "Landroid/net/Uri;", "isDownloadsDocument", "", "uri", "isExternalStorageDocument", "isGooglePhotosUri", "isMediaDocument", "filepicker_release"})
public final class ContentUriUtils {
    public static final ContentUriUtils INSTANCE;

    @WorkerThread
    @Nullable
    public final String getFilePath(@NotNull Context context, @NotNull Uri fileUri) throws URISyntaxException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        Uri uri = fileUri;
        String selection = null;
        String[] selectionArgs = null;
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context.getApplicationContext(), (Uri)uri)) {
            if (this.isExternalStorageDocument(uri)) {
                String docId;
                String string2 = docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"docId");
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string2, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                return Environment.getExternalStorageDirectory().toString() + "/" + split[1];
            }
            if (this.isDownloadsDocument(uri)) {
                String id2 = DocumentsContract.getDocumentId((Uri)uri);
                Uri uri2 = Uri.parse((String)"content://downloads/public_downloads");
                Long l = Long.valueOf(id2);
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"java.lang.Long.valueOf(id)");
                Uri uri3 = ContentUris.withAppendedId((Uri)uri2, (long)l);
                Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"ContentUris.withAppended\u2026va.lang.Long.valueOf(id))");
                uri = uri3;
            } else if (this.isMediaDocument(uri)) {
                String docId;
                String string3 = docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"docId");
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string3, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                String type = split[0];
                if (Intrinsics.areEqual((Object)"image", (Object)type)) {
                    Uri uri4 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    Intrinsics.checkNotNullExpressionValue((Object)uri4, (String)"MediaStore.Images.Media.EXTERNAL_CONTENT_URI");
                    uri = uri4;
                } else if (Intrinsics.areEqual((Object)"video", (Object)type)) {
                    Uri uri5 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    Intrinsics.checkNotNullExpressionValue((Object)uri5, (String)"MediaStore.Video.Media.EXTERNAL_CONTENT_URI");
                    uri = uri5;
                } else if (Intrinsics.areEqual((Object)"audio", (Object)type)) {
                    Uri uri6 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    Intrinsics.checkNotNullExpressionValue((Object)uri6, (String)"MediaStore.Audio.Media.EXTERNAL_CONTENT_URI");
                    uri = uri6;
                }
                selection = "_id=?";
                selectionArgs = new String[]{split[1]};
            }
        }
        if (StringsKt.equals((String)"content", (String)uri.getScheme(), (boolean)true)) {
            if (this.isGooglePhotosUri(uri)) {
                return uri.getLastPathSegment();
            }
            String[] projection = new String[]{"_data"};
            try {
                ContentResolver contentResolver = context.getContentResolver();
                Cursor cursor = contentResolver != null ? contentResolver.query(uri, projection, selection, selectionArgs, null) : null;
                String path = null;
                if (cursor != null) {
                    int column_index = cursor.getColumnIndexOrThrow("_data");
                    if (cursor.moveToFirst()) {
                        path = cursor.getString(column_index);
                        cursor.close();
                    }
                }
                return path;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (StringsKt.equals((String)"file", (String)uri.getScheme(), (boolean)true)) {
            return uri.getPath();
        }
        return null;
    }

    public final boolean isExternalStorageDocument(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)"com.android.externalstorage.documents", (Object)uri.getAuthority());
    }

    public final boolean isDownloadsDocument(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)uri.getAuthority());
    }

    public final boolean isMediaDocument(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)uri.getAuthority());
    }

    public final boolean isGooglePhotosUri(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)"com.google.android.apps.photos.content", (Object)uri.getAuthority());
    }

    private ContentUriUtils() {
    }

    static {
        ContentUriUtils contentUriUtils;
        INSTANCE = contentUriUtils = new ContentUriUtils();
    }
}

