/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.adapters;

import android.content.Context;
import android.net.Uri;
import android.text.format.Formatter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.FileAdapterListener;
import droidninja.filepicker.adapters.SelectableAdapter;
import droidninja.filepicker.models.BaseFile;
import droidninja.filepicker.models.Document;
import droidninja.filepicker.models.FileType;
import droidninja.filepicker.views.SmoothCheckBox;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001\u001dB3\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0002H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ldroidninja/filepicker/adapters/FileListAdapter;", "Ldroidninja/filepicker/adapters/SelectableAdapter;", "Ldroidninja/filepicker/adapters/FileListAdapter$FileViewHolder;", "Ldroidninja/filepicker/models/Document;", "Landroid/widget/Filterable;", "context", "Landroid/content/Context;", "mFilteredList", "", "selectedPaths", "", "Landroid/net/Uri;", "mListener", "Ldroidninja/filepicker/adapters/FileAdapterListener;", "(Landroid/content/Context;Ljava/util/List;Ljava/util/List;Ldroidninja/filepicker/adapters/FileAdapterListener;)V", "getFilter", "Landroid/widget/Filter;", "getItemCount", "", "onBindViewHolder", "", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onItemClicked", "document", "FileViewHolder", "filepicker_release"})
public final class FileListAdapter
extends SelectableAdapter<FileViewHolder, Document>
implements Filterable {
    @NotNull
    private final Context context;
    @NotNull
    private List<Document> mFilteredList;
    @Nullable
    private final FileAdapterListener mListener;

    public FileListAdapter(@NotNull Context context, @NotNull List<Document> mFilteredList, @NotNull List<Uri> selectedPaths, @Nullable FileAdapterListener mListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(mFilteredList, (String)"mFilteredList");
        Intrinsics.checkNotNullParameter(selectedPaths, (String)"selectedPaths");
        super(mFilteredList, selectedPaths);
        this.context = context;
        this.mFilteredList = mFilteredList;
        this.mListener = mListener;
    }

    @NotNull
    public FileViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.item_doc_layout, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)itemView, (String)"itemView");
        return new FileViewHolder(itemView);
    }

    public void onBindViewHolder(@NotNull FileViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Document document = this.mFilteredList.get(position);
        FileType fileType = document.getFileType();
        Object object = fileType == null ? null : Integer.valueOf(fileType.getDrawable());
        int drawable2 = object == null ? R.drawable.icon_file_unknown : (Integer)object;
        holder.getImageView$filepicker_release().setImageResource(drawable2);
        if (drawable2 == R.drawable.icon_file_unknown || drawable2 == R.drawable.icon_file_pdf) {
            holder.getFileTypeTv$filepicker_release().setVisibility(0);
            object = document.getFileType();
            holder.getFileTypeTv$filepicker_release().setText((CharSequence)(object == null ? null : ((FileType)object).getTitle()));
        } else {
            holder.getFileTypeTv$filepicker_release().setVisibility(8);
        }
        holder.getFileNameTextView$filepicker_release().setText((CharSequence)document.getName());
        object = document.getSize();
        holder.getFileSizeTextView$filepicker_release().setText((CharSequence)Formatter.formatShortFileSize((Context)this.context, (long)Long.parseLong((String)(object == null ? "0" : object))));
        holder.itemView.setOnClickListener(arg_0 -> FileListAdapter.onBindViewHolder$lambda-0(this, document, holder, arg_0));
        holder.getCheckBox$filepicker_release().setOnCheckedChangeListener(null);
        holder.getCheckBox$filepicker_release().setOnClickListener(arg_0 -> FileListAdapter.onBindViewHolder$lambda-1(this, document, holder, arg_0));
        holder.getCheckBox$filepicker_release().setChecked(this.isSelected((BaseFile)document));
        holder.itemView.setBackgroundResource(this.isSelected((BaseFile)document) ? R.color.bg_gray : 17170443);
        holder.getCheckBox$filepicker_release().setVisibility(this.isSelected((BaseFile)document) ? 0 : 8);
        holder.getCheckBox$filepicker_release().setOnCheckedChangeListener(new SmoothCheckBox.OnCheckedChangeListener(this, document, holder){
            final /* synthetic */ FileListAdapter this$0;
            final /* synthetic */ Document $document;
            final /* synthetic */ FileViewHolder $holder;
            {
                this.this$0 = $receiver;
                this.$document = $document;
                this.$holder = $holder;
            }

            public void onCheckedChanged(@NotNull SmoothCheckBox checkBox, boolean isChecked) {
                Intrinsics.checkNotNullParameter((Object)((Object)checkBox), (String)"checkBox");
                this.this$0.toggleSelection((BaseFile)this.$document);
                if (isChecked) {
                    PickerManager.INSTANCE.add(this.$document.getPath(), 2);
                } else {
                    PickerManager.INSTANCE.remove(this.$document.getPath(), 2);
                }
                this.$holder.itemView.setBackgroundResource(isChecked ? R.color.bg_gray : 17170443);
            }
        });
    }

    private final void onItemClicked(Document document, FileViewHolder holder) {
        if (PickerManager.INSTANCE.getMaxCount() == 1) {
            PickerManager.INSTANCE.add(document.getPath(), 2);
        } else if (holder.getCheckBox$filepicker_release().isChecked()) {
            holder.getCheckBox$filepicker_release().setChecked(!holder.getCheckBox$filepicker_release().isChecked(), true);
            holder.getCheckBox$filepicker_release().setVisibility(8);
        } else if (PickerManager.INSTANCE.shouldAdd()) {
            holder.getCheckBox$filepicker_release().setChecked(!holder.getCheckBox$filepicker_release().isChecked(), true);
            holder.getCheckBox$filepicker_release().setVisibility(0);
        }
        FileAdapterListener fileAdapterListener = this.mListener;
        if (fileAdapterListener != null) {
            fileAdapterListener.onItemSelected();
        }
    }

    public int getItemCount() {
        return this.mFilteredList.size();
    }

    @NotNull
    public Filter getFilter() {
        return new Filter(this){
            final /* synthetic */ FileListAdapter this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            protected Filter.FilterResults performFiltering(@NotNull CharSequence charSequence) {
                Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
                String charString = ((Object)charSequence).toString();
                CharSequence charSequence2 = charString;
                boolean bl = false;
                if (charSequence2.length() == 0) {
                    FileListAdapter.access$setMFilteredList$p(this.this$0, this.this$0.getItems());
                } else {
                    ArrayList<Document> filteredList = new ArrayList<Document>();
                    for (Document document : this.this$0.getItems()) {
                        String string2 = document.getName();
                        boolean bl2 = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                        if (!StringsKt.contains$default((CharSequence)string4, (CharSequence)charString, (boolean)false, (int)2, null)) continue;
                        filteredList.add(document);
                    }
                    FileListAdapter.access$setMFilteredList$p(this.this$0, filteredList);
                }
                Filter.FilterResults filterResults = new Filter.FilterResults();
                filterResults.values = FileListAdapter.access$getMFilteredList$p(this.this$0);
                return filterResults;
            }

            protected void publishResults(@NotNull CharSequence charSequence, @NotNull Filter.FilterResults filterResults) {
                Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
                Intrinsics.checkNotNullParameter((Object)filterResults, (String)"filterResults");
                Object object = filterResults.values;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<droidninja.filepicker.models.Document>");
                }
                FileListAdapter.access$setMFilteredList$p(this.this$0, (List)object);
                this.this$0.notifyDataSetChanged();
            }
        };
    }

    private static final void onBindViewHolder$lambda-0(FileListAdapter this$0, Document $document, FileViewHolder $holder, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)((Object)$holder), (String)"$holder");
        this$0.onItemClicked($document, $holder);
    }

    private static final void onBindViewHolder$lambda-1(FileListAdapter this$0, Document $document, FileViewHolder $holder, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)((Object)$holder), (String)"$holder");
        this$0.onItemClicked($document, $holder);
    }

    public static final /* synthetic */ void access$setMFilteredList$p(FileListAdapter $this, List list) {
        $this.mFilteredList = list;
    }

    public static final /* synthetic */ List access$getMFilteredList$p(FileListAdapter $this) {
        return $this.mFilteredList;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Ldroidninja/filepicker/adapters/FileListAdapter$FileViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "checkBox", "Ldroidninja/filepicker/views/SmoothCheckBox;", "getCheckBox$filepicker_release", "()Ldroidninja/filepicker/views/SmoothCheckBox;", "setCheckBox$filepicker_release", "(Ldroidninja/filepicker/views/SmoothCheckBox;)V", "fileNameTextView", "Landroid/widget/TextView;", "getFileNameTextView$filepicker_release", "()Landroid/widget/TextView;", "setFileNameTextView$filepicker_release", "(Landroid/widget/TextView;)V", "fileSizeTextView", "getFileSizeTextView$filepicker_release", "setFileSizeTextView$filepicker_release", "fileTypeTv", "getFileTypeTv$filepicker_release", "setFileTypeTv$filepicker_release", "imageView", "Landroid/widget/ImageView;", "getImageView$filepicker_release", "()Landroid/widget/ImageView;", "setImageView$filepicker_release", "(Landroid/widget/ImageView;)V", "filepicker_release"})
    public static final class FileViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private TextView fileTypeTv;
        @NotNull
        private SmoothCheckBox checkBox;
        @NotNull
        private ImageView imageView;
        @NotNull
        private TextView fileNameTextView;
        @NotNull
        private TextView fileSizeTextView;

        public FileViewHolder(@NotNull View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.checkbox);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.checkbox)");
            this.checkBox = (SmoothCheckBox)view;
            view = itemView.findViewById(R.id.file_iv);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.file_iv)");
            this.imageView = (ImageView)view;
            view = itemView.findViewById(R.id.file_name_tv);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.file_name_tv)");
            this.fileNameTextView = (TextView)view;
            view = itemView.findViewById(R.id.file_type_tv);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.file_type_tv)");
            this.fileTypeTv = (TextView)view;
            view = itemView.findViewById(R.id.file_size_tv);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.file_size_tv)");
            this.fileSizeTextView = (TextView)view;
        }

        @NotNull
        public final TextView getFileTypeTv$filepicker_release() {
            return this.fileTypeTv;
        }

        public final void setFileTypeTv$filepicker_release(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.fileTypeTv = textView;
        }

        @NotNull
        public final SmoothCheckBox getCheckBox$filepicker_release() {
            return this.checkBox;
        }

        public final void setCheckBox$filepicker_release(@NotNull SmoothCheckBox smoothCheckBox) {
            Intrinsics.checkNotNullParameter((Object)((Object)smoothCheckBox), (String)"<set-?>");
            this.checkBox = smoothCheckBox;
        }

        @NotNull
        public final ImageView getImageView$filepicker_release() {
            return this.imageView;
        }

        public final void setImageView$filepicker_release(@NotNull ImageView imageView) {
            Intrinsics.checkNotNullParameter((Object)imageView, (String)"<set-?>");
            this.imageView = imageView;
        }

        @NotNull
        public final TextView getFileNameTextView$filepicker_release() {
            return this.fileNameTextView;
        }

        public final void setFileNameTextView$filepicker_release(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.fileNameTextView = textView;
        }

        @NotNull
        public final TextView getFileSizeTextView$filepicker_release() {
            return this.fileSizeTextView;
        }

        public final void setFileSizeTextView$filepicker_release(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.fileSizeTextView = textView;
        }
    }
}

