/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.utils;

import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import droidninja.filepicker.R;
import droidninja.filepicker.fragments.BaseFragment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0018"}, d2={"Ldroidninja/filepicker/utils/FragmentUtil;", "", "()V", "addFragment", "", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "contentId", "", "fragment", "Ldroidninja/filepicker/fragments/BaseFragment;", "attachFragment", "detachFragment", "getFragmentByTag", "Landroidx/fragment/app/Fragment;", "appCompatActivity", "tag", "", "hadFragment", "", "hideFragment", "removeFragment", "replaceFragment", "showFragment", "filepicker_release"})
public final class FragmentUtil {
    public static final FragmentUtil INSTANCE;

    public final boolean hadFragment(@NotNull AppCompatActivity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        FragmentManager fragmentManager = activity.getSupportFragmentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentManager, (String)"activity.supportFragmentManager");
        return fragmentManager.getBackStackEntryCount() != 0;
    }

    public final void replaceFragment(@NotNull AppCompatActivity activity, int contentId, @NotNull BaseFragment fragment) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fragment), (String)"fragment");
        FragmentTransaction fragmentTransaction = activity.getSupportFragmentManager().beginTransaction();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentTransaction, (String)"activity.supportFragmentManager.beginTransaction()");
        FragmentTransaction transaction = fragmentTransaction;
        transaction.setCustomAnimations(R.anim.slide_left_in, R.anim.slide_left_out);
        transaction.replace(contentId, (Fragment)fragment, ((Object)((Object)fragment)).getClass().getSimpleName());
        transaction.addToBackStack(null);
        transaction.commit();
    }

    public final void addFragment(@NotNull AppCompatActivity activity, int contentId, @NotNull BaseFragment fragment) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fragment), (String)"fragment");
        FragmentTransaction fragmentTransaction = activity.getSupportFragmentManager().beginTransaction();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentTransaction, (String)"activity.supportFragmentManager.beginTransaction()");
        FragmentTransaction transaction = fragmentTransaction;
        transaction.setCustomAnimations(R.anim.slide_left_in, R.anim.slide_left_out);
        transaction.add(contentId, (Fragment)fragment, ((Object)((Object)fragment)).getClass().getSimpleName());
        transaction.commit();
    }

    public final void removeFragment(@NotNull AppCompatActivity activity, @NotNull BaseFragment fragment) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fragment), (String)"fragment");
        activity.getSupportFragmentManager().beginTransaction().remove((Fragment)fragment).commit();
    }

    public final void showFragment(@NotNull AppCompatActivity activity, @NotNull BaseFragment fragment) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fragment), (String)"fragment");
        activity.getSupportFragmentManager().beginTransaction().show((Fragment)fragment).commit();
    }

    public final void hideFragment(@NotNull AppCompatActivity activity, @NotNull BaseFragment fragment) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fragment), (String)"fragment");
        activity.getSupportFragmentManager().beginTransaction().hide((Fragment)fragment).commit();
    }

    public final void attachFragment(@NotNull AppCompatActivity activity, @NotNull BaseFragment fragment) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fragment), (String)"fragment");
        activity.getSupportFragmentManager().beginTransaction().attach((Fragment)fragment).commit();
    }

    public final void detachFragment(@NotNull AppCompatActivity activity, @NotNull BaseFragment fragment) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fragment), (String)"fragment");
        activity.getSupportFragmentManager().beginTransaction().detach((Fragment)fragment).commit();
    }

    @Nullable
    public final Fragment getFragmentByTag(@NotNull AppCompatActivity appCompatActivity, @NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)appCompatActivity, (String)"appCompatActivity");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        return appCompatActivity.getSupportFragmentManager().findFragmentByTag(tag);
    }

    private FragmentUtil() {
    }

    static {
        FragmentUtil fragmentUtil;
        INSTANCE = fragmentUtil = new FragmentUtil();
    }
}

