/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.utils;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import androidx.annotation.WorkerThread;
import java.net.URISyntaxException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Ldroidninja/filepicker/utils/ContentUriUtils;", "", "()V", "getFilePath", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "isDownloadsDocument", "", "isExternalStorageDocument", "isGooglePhotosUri", "isMediaDocument", "filepicker_release"})
public final class ContentUriUtils {
    public static final ContentUriUtils INSTANCE;

    @WorkerThread
    @Nullable
    public final String getFilePath(@NotNull Context context, @NotNull Uri uri) throws URISyntaxException {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Uri uri2 = uri;
        String selection = null;
        String[] selectionArgs = null;
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context.getApplicationContext(), (Uri)uri2)) {
            if (this.isExternalStorageDocument(uri2)) {
                String docId;
                String string2 = docId = DocumentsContract.getDocumentId((Uri)uri2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"docId");
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string2, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                return Environment.getExternalStorageDirectory().toString() + "/" + split[1];
            }
            if (this.isDownloadsDocument(uri2)) {
                String id2 = DocumentsContract.getDocumentId((Uri)uri2);
                Uri uri3 = Uri.parse((String)"content://downloads/public_downloads");
                Long l = Long.valueOf(id2);
                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"java.lang.Long.valueOf(id)");
                Uri uri4 = ContentUris.withAppendedId((Uri)uri3, (long)l);
                Intrinsics.checkExpressionValueIsNotNull((Object)uri4, (String)"ContentUris.withAppended\u2026va.lang.Long.valueOf(id))");
                uri2 = uri4;
            } else if (this.isMediaDocument(uri2)) {
                String docId;
                String string3 = docId = DocumentsContract.getDocumentId((Uri)uri2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"docId");
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string3, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                String type = split[0];
                if (Intrinsics.areEqual((Object)"image", (Object)type)) {
                    Uri uri5 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    Intrinsics.checkExpressionValueIsNotNull((Object)uri5, (String)"MediaStore.Images.Media.EXTERNAL_CONTENT_URI");
                    uri2 = uri5;
                } else if (Intrinsics.areEqual((Object)"video", (Object)type)) {
                    Uri uri6 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    Intrinsics.checkExpressionValueIsNotNull((Object)uri6, (String)"MediaStore.Video.Media.EXTERNAL_CONTENT_URI");
                    uri2 = uri6;
                } else if (Intrinsics.areEqual((Object)"audio", (Object)type)) {
                    Uri uri7 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    Intrinsics.checkExpressionValueIsNotNull((Object)uri7, (String)"MediaStore.Audio.Media.EXTERNAL_CONTENT_URI");
                    uri2 = uri7;
                }
                selection = "_id=?";
                selectionArgs = new String[]{split[1]};
            }
        }
        if (StringsKt.equals((String)"content", (String)uri2.getScheme(), (boolean)true)) {
            if (this.isGooglePhotosUri(uri2)) {
                return uri2.getLastPathSegment();
            }
            String[] projection = new String[]{"_data"};
            try {
                ContentResolver contentResolver = context.getContentResolver();
                Cursor cursor = contentResolver != null ? contentResolver.query(uri2, projection, selection, selectionArgs, null) : null;
                String path = null;
                if (cursor != null) {
                    int column_index = cursor.getColumnIndexOrThrow("_data");
                    if (cursor.moveToFirst()) {
                        path = cursor.getString(column_index);
                        cursor.close();
                    }
                }
                return path;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (StringsKt.equals((String)"file", (String)uri2.getScheme(), (boolean)true)) {
            return uri2.getPath();
        }
        return null;
    }

    public final boolean isExternalStorageDocument(@NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)"com.android.externalstorage.documents", (Object)uri.getAuthority());
    }

    public final boolean isDownloadsDocument(@NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)uri.getAuthority());
    }

    public final boolean isMediaDocument(@NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)uri.getAuthority());
    }

    public final boolean isGooglePhotosUri(@NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        return Intrinsics.areEqual((Object)"com.google.android.apps.photos.content", (Object)uri.getAuthority());
    }

    private ContentUriUtils() {
    }

    static {
        ContentUriUtils contentUriUtils;
        INSTANCE = contentUriUtils = new ContentUriUtils();
    }
}

