/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.service;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.google.common.collect.Range;
import com.tugos.dst.admin.enums.StartTypeEnum;
import com.tugos.dst.admin.service.BackupService;
import com.tugos.dst.admin.service.HomeService;
import com.tugos.dst.admin.service.ShellService;
import com.tugos.dst.admin.utils.DBUtils;
import com.tugos.dst.admin.utils.DstConfigData;
import com.tugos.dst.admin.utils.DstVersionUtils;
import com.tugos.dst.admin.utils.FileUtils;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class CoreScheduleService {
    private static final Logger log = LoggerFactory.getLogger(CoreScheduleService.class);
    @Value(value="${dst.username:admin}")
    private String dstUser;
    @Value(value="${dst.password:123456}")
    private String dstPassword;
    @Value(value="${dst.nickname:\u7ba1\u7406\u5458}")
    private String nickname;
    private HomeService homeService;
    private ShellService shellService;
    private BackupService backupService;
    @Value(value="${dst.master.port:10888}")
    private String masterPort;
    @Value(value="${dst.ground.port:10998}")
    private String groundPort;
    @Value(value="${dst.caves.port:10999}")
    private String cavesPort;
    public int upper = 180000;

    @Scheduled(cron="1 0 0 * * ?")
    public void resetScheduleMap() {
        Set backupKeySet = DstConfigData.SCHEDULE_BACKUP_MAP.keySet();
        for (String key : backupKeySet) {
            DstConfigData.SCHEDULE_BACKUP_MAP.put(key, 0);
        }
        Set updateKeySet = DstConfigData.SCHEDULE_UPDATE_MAP.keySet();
        for (String key : updateKeySet) {
            DstConfigData.SCHEDULE_UPDATE_MAP.put(key, 0);
        }
    }

    @Scheduled(fixedDelay=1800000L, initialDelay=1800000L)
    public void smartUpdateGame() {
        Boolean smartUpdate = DstConfigData.smartUpdate;
        if (smartUpdate != null && smartUpdate.booleanValue()) {
            String localVersion;
            String steamVersion = DstVersionUtils.getSteamVersionV3();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{steamVersion, localVersion = DstVersionUtils.getLocalVersion()})) {
                long lv;
                long sv = Long.parseLong(steamVersion);
                if (sv > (lv = Long.parseLong(localVersion))) {
                    log.info("\u667a\u80fd\u66f4\u65b0\u8fdb\u884c...");
                    this.onlyUpdateGame();
                }
            } else {
                log.info("\u62ff\u4e0d\u5230\u6700\u65b0\u7684\u7248\u672c\u53f7\uff1asteamVersion={},localVersion={}", (Object)steamVersion, (Object)localVersion);
            }
        }
    }

    @Scheduled(fixedDelay=5000L, initialDelay=10000L)
    public void scheduleExe() {
        this.backupGame();
        this.updateGame();
        DBUtils.saveDataToFile();
    }

    public void updateGame() {
        Date currentDate = new Date();
        String currentDateStr = DateUtil.format((Date)currentDate, (String)"yyyy-MM-dd");
        Set updateListTime = DstConfigData.SCHEDULE_UPDATE_MAP.keySet();
        if (CollectionUtils.isNotEmpty(updateListTime)) {
            updateListTime.forEach(time -> {
                Integer count = (Integer)DstConfigData.SCHEDULE_UPDATE_MAP.get(time);
                if (count < 1) {
                    DateTime parse = DateUtil.parse((CharSequence)(currentDateStr + " " + time), (String)"yyyy-MM-dd HH:mm:ss");
                    long execTime = parse.getTime();
                    long currentDateTime = currentDate.getTime();
                    long subTime = currentDateTime - execTime;
                    if (Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.upper)).contains((Comparable)Integer.valueOf((int)subTime))) {
                        log.info("\u5b9a\u65f6\u66f4\u65b0\u5e76\u91cd\u542f\u6e38\u620f");
                        this.onlyUpdateGame();
                        DstConfigData.SCHEDULE_UPDATE_MAP.put(time, 1);
                    }
                }
            });
        }
    }

    private void onlyUpdateGame() {
        boolean notStartCaves;
        this.shellService.sendBroadcast("\u670d\u52a1\u5668\u5c06\u9a6c\u4e0a\u8fdb\u884c\u66f4\u65b0\uff0c\u4f60\u5c06\u4e0e\u670d\u52a1\u5668\u65ad\u5f00\u8fde\u63a5(The server will be updated immediately)");
        this.shellService.sendBroadcast("\u8bf7\u7a0d\u540e\u518d\u8fdb\u5165\u623f\u95f4(Please enter the room later)");
        try {
            TimeUnit.SECONDS.sleep(20L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.homeService.updateGame();
        boolean notStartMaster = DstConfigData.notStartMaster != null ? DstConfigData.notStartMaster : false;
        boolean bl = notStartCaves = DstConfigData.notStartCaves != null ? DstConfigData.notStartCaves : false;
        if (!notStartMaster && !notStartCaves) {
            this.homeService.start(StartTypeEnum.START_ALL.type);
        }
        if (notStartMaster && !notStartCaves) {
            this.homeService.start(StartTypeEnum.START_CAVES.type);
        }
        if (!notStartMaster && notStartCaves) {
            this.homeService.start(StartTypeEnum.START_MASTER.type);
        }
        if (!notStartMaster || notStartCaves) {
            // empty if block
        }
    }

    public void backupGame() {
        Date currentDate = new Date();
        String currentDateStr = DateUtil.format((Date)currentDate, (String)"yyyy-MM-dd");
        Set backupListTime = DstConfigData.SCHEDULE_BACKUP_MAP.keySet();
        if (CollectionUtils.isNotEmpty(backupListTime)) {
            backupListTime.forEach(time -> {
                Integer count = (Integer)DstConfigData.SCHEDULE_BACKUP_MAP.get(time);
                if (count < 1) {
                    DateTime parse = DateUtil.parse((CharSequence)(currentDateStr + " " + time), (String)"yyyy-MM-dd HH:mm:ss");
                    long execTime = parse.getTime();
                    long currentDateTime = currentDate.getTime();
                    long subTime = currentDateTime - execTime;
                    if (Range.open((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.upper)).contains((Comparable)Integer.valueOf((int)subTime))) {
                        log.info("\u5b9a\u65f6\u5907\u4efd\u6e38\u620f");
                        this.backupService.backup(null);
                        DstConfigData.SCHEDULE_BACKUP_MAP.put(time, 1);
                    }
                }
            });
        }
    }

    @PostConstruct
    public void initSystem() throws Exception {
        String data = DBUtils.readProjectData((String)".dst_admin_db.json");
        if (StringUtils.isNotBlank((CharSequence)data)) {
            DBUtils.readDataToCache((String)data);
        } else {
            DstConfigData.SCHEDULE_UPDATE_MAP.put("06:00:00", 0);
            DstConfigData.SCHEDULE_BACKUP_MAP.put("06:00:00", 0);
            DstConfigData.SCHEDULE_BACKUP_MAP.put("18:00:00", 0);
            DstConfigData.USER_INFO.setUsername(this.dstUser);
            DstConfigData.USER_INFO.setPassword(this.dstPassword);
            DstConfigData.USER_INFO.setNickname(this.nickname);
            DstConfigData.masterPort = this.masterPort;
            DstConfigData.groundPort = this.groundPort;
            DstConfigData.cavesPort = this.cavesPort;
        }
        this.copyAndChmod("install.sh");
        this.copyAndChmod("dstStart.sh");
    }

    private void copyAndChmod(String fileName) throws Exception {
        boolean copy = FileUtils.fileShellCopy((String)fileName);
        if (copy) {
            FileUtils.chmod((String)fileName);
        }
    }

    @Autowired
    public void setHomeService(HomeService homeService) {
        this.homeService = homeService;
    }

    @Autowired
    public void setShellService(ShellService shellService) {
        this.shellService = shellService;
    }

    @Autowired
    public void setBackupService(BackupService backupService) {
        this.backupService = backupService;
    }
}

