/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.controller;

import com.tugos.dst.admin.common.ResultVO;
import com.tugos.dst.admin.service.SystemService;
import com.tugos.dst.admin.vo.GamePortVO;
import com.tugos.dst.admin.vo.ScheduleVO;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system"})
public class SystemController {
    private static final Logger log = LoggerFactory.getLogger(SystemController.class);
    private SystemService systemService;

    @GetMapping(value={"/index"})
    @RequiresAuthentication
    public String index() {
        return "system/index";
    }

    @GetMapping(value={"/guide"})
    public String toGuide() {
        Locale locale = LocaleContextHolder.getLocale();
        if (Locale.CHINA.getLanguage().equals(locale.getLanguage())) {
            return "system/guide";
        }
        return "system/guide_en";
    }

    @GetMapping(value={"/about"})
    public String toAbout() {
        return "/system/about";
    }

    @GetMapping(value={"/getDstLog"})
    @ResponseBody
    @RequiresAuthentication
    public ResultVO<List<String>> getDstLog(@RequestParam(required=false, defaultValue="0") Integer type, @RequestParam(required=false, defaultValue="100") Integer rowNum) {
        log.info("\u62c9\u53d6\u9965\u8352\u7684\u65e5\u5fd7\uff1atype={},rowNum={}", (Object)type, (Object)rowNum);
        return ResultVO.data((Object)this.systemService.getDstLog(type, rowNum));
    }

    @GetMapping(value={"/getScheduleList"})
    @ResponseBody
    @RequiresAuthentication
    public ResultVO<ScheduleVO> getScheduleList() {
        return ResultVO.data((Object)this.systemService.getScheduleList());
    }

    @PostMapping(value={"/saveSchedule"})
    @ResponseBody
    @RequiresAuthentication
    public ResultVO<String> saveSchedule(@RequestBody ScheduleVO vo) {
        this.systemService.saveSchedule(vo);
        return ResultVO.success();
    }

    @GetMapping(value={"/getVersion"})
    @ResponseBody
    @RequiresAuthentication
    public ResultVO<Map<String, String>> getVersion() {
        return ResultVO.data((Object)this.systemService.getVersion());
    }

    @GetMapping(value={"/getGamePort"})
    @ResponseBody
    @RequiresAuthentication
    public ResultVO<GamePortVO> getGamePort() {
        return ResultVO.data((Object)this.systemService.getGamePort());
    }

    @PostMapping(value={"/saveGamePort"})
    @ResponseBody
    @RequiresAuthentication
    public ResultVO<Map<String, String>> saveGamePort(@RequestBody GamePortVO gamePortVO) {
        this.systemService.saveGamePort(gamePortVO);
        return ResultVO.success();
    }

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }
}

