/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.controller;

import com.tugos.dst.admin.common.ResultVO;
import com.tugos.dst.admin.service.PlayerService;
import com.tugos.dst.admin.vo.PlayerSettingVO;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/player"})
public class PlayerController {
    private static final Logger log = LoggerFactory.getLogger(PlayerController.class);
    private PlayerService playerService;

    @GetMapping(value={"/index"})
    @RequiresAuthentication
    public String index() {
        log.info("\u8fdb\u5165\u73a9\u5bb6\u8bbe\u7f6e\u9875\u9762");
        return "/player/index";
    }

    @GetMapping(value={"/getDstAdminList"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<List<String>> getDstAdminList() {
        log.info("\u62c9\u53d6\u7ba1\u7406\u5458\u5217\u8868");
        return ResultVO.data((Object)this.playerService.getDstAdminList());
    }

    @GetMapping(value={"/getDstBlacklist"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<List<String>> getDstBlacklist() {
        log.info("\u62c9\u53d6\u73a9\u5bb6\u9ed1\u540d\u5355\u5217\u8868");
        return ResultVO.data((Object)this.playerService.getDstBlacklist());
    }

    @PostMapping(value={"/saveAdminList"})
    @RequiresAuthentication
    @ResponseBody
    @Deprecated
    public ResultVO<String> saveAdminList(@RequestBody List<String> adminList) throws Exception {
        log.info("\u4fdd\u5b58\u7ba1\u7406\u5458\uff1a" + adminList);
        return this.playerService.saveAdminList(adminList);
    }

    @PostMapping(value={"/saveBlackList"})
    @RequiresAuthentication
    @ResponseBody
    @Deprecated
    public ResultVO<String> saveBlackList(@RequestBody List<String> blackList) throws Exception {
        log.info("\u4fdd\u5b58\u9ed1\u540d\u5355\uff1a" + blackList);
        return this.playerService.saveBlackList(blackList);
    }

    @PostMapping(value={"/saveAdminAndBlackList"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<String> saveAdminAndBlackList(@RequestBody PlayerSettingVO playerSettingVO) throws Exception {
        log.info("\u4fdd\u5b58\u7ba1\u7406\u5458\u548c\u9ed1\u540d\u5355\uff1a" + playerSettingVO);
        this.playerService.saveAdminList(playerSettingVO.getAdminList());
        this.playerService.saveBlackList(playerSettingVO.getBlackList());
        return ResultVO.success();
    }

    @Autowired
    public void setPlayerService(PlayerService playerService) {
        this.playerService = playerService;
    }
}

