/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.controller;

import com.tugos.dst.admin.common.ResultVO;
import com.tugos.dst.admin.service.BackupService;
import com.tugos.dst.admin.service.HomeService;
import com.tugos.dst.admin.service.ShellService;
import com.tugos.dst.admin.vo.DstServerInfoVO;
import com.tugos.dst.admin.vo.GameArchiveVO;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/home"})
public class HomeController {
    private static final Logger log = LoggerFactory.getLogger(HomeController.class);
    private HomeService homeService;
    private ShellService shellService;
    private BackupService backupService;

    @GetMapping(value={"/index"})
    @RequiresAuthentication
    public String index(HttpServletRequest request) {
        Locale locale = LocaleContextHolder.getLocale();
        if (Locale.CHINA.getLanguage().equals(locale.getLanguage())) {
            request.setAttribute("lang", (Object)"zh");
        } else {
            request.setAttribute("lang", (Object)"en");
        }
        log.info("\u8bbf\u95ee\u9996\u9875");
        return "/home/index";
    }

    @GetMapping(value={"/getSystemInfo"})
    @ResponseBody
    @RequiresAuthentication
    public ResultVO<DstServerInfoVO> getSystemInfo() throws Exception {
        log.debug("\u83b7\u53d6\u670d\u52a1\u5668\u7684\u4fe1\u606f");
        return ResultVO.data((Object)this.homeService.getSystemInfo());
    }

    @GetMapping(value={"/start"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<String> start(@RequestParam Integer type) throws Exception {
        log.info("\u542f\u52a8\u670d\u52a1\u5668\uff0ctype={}", (Object)type);
        return this.homeService.start(type);
    }

    @GetMapping(value={"/stop"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<String> stop(@RequestParam Integer type) throws Exception {
        log.info("\u505c\u6b62\u670d\u52a1\u5668\uff0ctype={}", (Object)type);
        return this.homeService.stop(type);
    }

    @GetMapping(value={"/updateGame"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<String> updateGame() {
        log.info("\u66f4\u65b0\u6e38\u620f");
        return this.homeService.updateGame();
    }

    @GetMapping(value={"/backup"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<String> backup(@RequestParam(required=false) String name) throws Exception {
        log.info("\u5907\u4efd\u6e38\u620f,{}", (Object)name);
        return this.backupService.backup(name);
    }

    @GetMapping(value={"/restore"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<String> restore(@RequestParam String name) throws Exception {
        log.info("\u6062\u590d\u5b58\u6863,{}", (Object)name);
        this.homeService.stopServer();
        return this.backupService.restore(name);
    }

    @GetMapping(value={"/delRecord"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<String> delRecord() throws Exception {
        log.info("\u6e05\u7406\u6e38\u620f\u8bb0\u5f55");
        this.homeService.delRecord();
        Thread.sleep(1000L);
        return ResultVO.success();
    }

    @GetMapping(value={"/sendBroadcast"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<String> sendBroadcast(@RequestParam String message) throws Exception {
        log.info("\u53d1\u9001\u516c\u544a\uff1a" + message);
        this.shellService.sendBroadcast(message);
        Thread.sleep(1000L);
        return ResultVO.success();
    }

    @GetMapping(value={"/getPlayerList"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<List<String>> getPlayerList() throws Exception {
        List playerList = this.shellService.getPlayerList();
        return ResultVO.data((Object)playerList);
    }

    @GetMapping(value={"/kickPlayer"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<String> kickPlayer(@RequestParam String userId) {
        log.info("\u8e22\u51fa\u73a9\u5bb6\uff1a" + userId);
        this.shellService.kickPlayer(userId);
        return ResultVO.success();
    }

    @GetMapping(value={"/rollback"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<String> rollback(@RequestParam Integer dayNum) {
        log.info("\u56de\u6eda\u6307\u5b9a\u7684\u5929\u6570\uff1a" + dayNum);
        this.shellService.rollback(dayNum.intValue());
        return ResultVO.success();
    }

    @GetMapping(value={"/regenerate"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<String> regenerate() {
        log.info("\u91cd\u7f6e\u4e16\u754c...");
        this.shellService.regenerate();
        return ResultVO.success();
    }

    @PostMapping(value={"/masterConsole"})
    @ResponseBody
    @RequiresAuthentication
    public ResultVO<String> masterConsole(@RequestBody Map<String, String> param) {
        this.shellService.masterConsole(param.get("command"));
        return ResultVO.success();
    }

    @PostMapping(value={"/cavesConsole"})
    @ResponseBody
    @RequiresAuthentication
    public ResultVO<String> cavesConsole(@RequestBody Map<String, String> param) {
        this.shellService.cavesConsole(param.get("command"));
        return ResultVO.success();
    }

    @GetMapping(value={"/playerOperate"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<String> playerOperate(@RequestParam String userId, @RequestParam String type) throws Exception {
        log.info("\u6267\u884c\u9ad8\u7ea7\u9488\u5bf9\u73a9\u5bb6\u7684\u64cd\u4f5c\uff1atype={},userId={}", (Object)type, (Object)userId);
        return this.shellService.playerOperate(type, userId);
    }

    @GetMapping(value={"/delMyDediServer"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<String> delMyDediServer() {
        log.info("\u5220\u9664MyDediServer\u76ee\u5f55");
        this.homeService.delMyDediServer();
        return ResultVO.success();
    }

    @GetMapping(value={"/delCavesRecord"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO<String> onlyDelSave() {
        log.info("\u5220\u9664\u5730\u9762\u5b58\u6863\u8bb0\u5f55");
        this.homeService.onlyDelSave();
        return ResultVO.success();
    }

    @GetMapping(value={"/getGameArchive"})
    @ResponseBody
    @RequiresAuthentication
    public ResultVO<GameArchiveVO> getGameArchive() throws Exception {
        return ResultVO.data((Object)this.homeService.getGameArchive());
    }

    @Autowired
    public void setHomeService(HomeService homeService) {
        this.homeService = homeService;
    }

    @Autowired
    public void setShellService(ShellService shellService) {
        this.shellService = shellService;
    }

    @Autowired
    public void setBackupService(BackupService backupService) {
        this.backupService = backupService;
    }
}

