/*
 * Decompiled with CFR 0.152.
 */
package com.github.pyknic.immutablearray.internal.bytes;

import com.github.pyknic.immutablearray.ByteImmutableArray;
import com.github.pyknic.immutablearray.internal.EmptyImmutableArray;
import com.github.pyknic.immutablearray.internal.bytes.ByteImmutableArrayImpl;
import com.github.pyknic.immutablearray.internal.bytes.ByteMultiBufferImmutableArrayImpl;
import com.github.pyknic.immutablearray.internal.bytes.ByteSingleBufferImmutableArrayImpl;
import com.github.pyknic.immutablearray.internal.util.MemoryUtil;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public final class ByteImmutableArrayBuilder
implements ByteImmutableArray.Builder {
    private final LinkedList<ByteBuffer> buffers = new LinkedList();
    private int outer = 0;
    private int inner = 0;

    @Override
    public ByteImmutableArray.Builder append(byte value) {
        ByteBuffer current;
        if (this.outer == this.buffers.size()) {
            current = ByteBuffer.allocateDirect(0x4000000);
            this.buffers.add(current);
        } else {
            current = this.buffers.getLast();
        }
        current.put(this.inner, value);
        if (0x4000000 == ++this.inner) {
            this.inner = 0;
            ++this.outer;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteImmutableArray build() {
        if (this.buffers.isEmpty()) {
            return new EmptyImmutableArray();
        }
        if (this.outer == 0) {
            if (this.inner < Short.MAX_VALUE) {
                ByteBuffer current = this.buffers.getFirst();
                try {
                    byte[] array = new byte[this.inner];
                    for (int i = 0; i < this.inner; ++i) {
                        array[i] = current.get(i);
                    }
                    ByteImmutableArrayImpl byteImmutableArrayImpl = new ByteImmutableArrayImpl(array);
                    return byteImmutableArrayImpl;
                }
                finally {
                    MemoryUtil.clear(current);
                }
            }
            this.rescaleLastBuffer();
            return new ByteSingleBufferImmutableArrayImpl(this.buffers.getFirst(), this.inner);
        }
        this.rescaleLastBuffer();
        return new ByteMultiBufferImmutableArrayImpl(this.bufferArray(), this.length());
    }

    private long length() {
        return this.outer * 0x4000000 + this.inner;
    }

    private ByteBuffer[] bufferArray() {
        return this.buffers.toArray(new ByteBuffer[this.outer + 1]);
    }

    private void rescaleLastBuffer() {
        ByteBuffer last = this.buffers.removeLast();
        if (this.inner > 0) {
            if (this.inner < Short.MAX_VALUE) {
                byte[] temp = new byte[this.inner];
                last.get(temp);
                MemoryUtil.clear(last);
                this.buffers.add(ByteBuffer.wrap(temp));
            } else {
                ByteBuffer temp = ByteBuffer.allocate(this.inner);
                for (int i = 0; i < this.inner; ++i) {
                    temp.put(i, last.get(i));
                }
                MemoryUtil.clear(last);
                this.buffers.add(temp);
            }
        }
    }
}

