/*
 * Decompiled with CFR 0.152.
 */
package com.github.pyknic.bigarray.internal.booleans;

import com.github.pyknic.bigarray.BooleanImmutableArray;
import com.github.pyknic.bigarray.internal.util.BitUtil;
import com.github.pyknic.bigarray.internal.util.IndexUtil;
import java.nio.ShortBuffer;

public final class BooleanVeryLargeImmutableArray
implements BooleanImmutableArray {
    private final ShortBuffer[] buffers;
    private final long length;

    public BooleanVeryLargeImmutableArray(ShortBuffer[] buffers, long length) {
        this.buffers = buffers;
        this.length = length;
    }

    @Override
    public boolean getAsBoolean(long index) {
        long idx = index / 16L;
        short bitmask = this.buffers[IndexUtil.outerIndex(idx)].get(IndexUtil.innerIndex(idx));
        return BitUtil.isSet(bitmask, index % 16L);
    }

    @Override
    public long length() {
        return this.length;
    }
}

