/*
 * Decompiled with CFR 0.152.
 */
package com.github.pyknic.bigarray.internal;

import com.github.pyknic.bigarray.ByteImmutableArray;
import com.github.pyknic.bigarray.IntImmutableArray;
import com.github.pyknic.bigarray.LongImmutableArray;
import com.github.pyknic.bigarray.ShortImmutableArray;
import com.github.pyknic.bigarray.internal.EmptyImmutableArray;
import com.github.pyknic.bigarray.internal.LongImmutableArrayImpl;
import com.github.pyknic.bigarray.internal.LongMultiBufferImmutableArrayImpl;
import com.github.pyknic.bigarray.internal.LongSingleBufferImmutableArrayImpl;
import com.github.pyknic.bigarray.internal.util.BitUtil;
import com.github.pyknic.bigarray.internal.util.IndexUtil;
import com.github.pyknic.bigarray.internal.util.MemoryUtil;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.LinkedList;
import java.util.function.LongConsumer;

public final class LongImmutableArrayBuilder
implements LongImmutableArray.Builder {
    private final LinkedList<LongBuffer> buffers = new LinkedList();
    private long bitmask;
    private int outer = 0;
    private int inner = 0;

    @Override
    public LongImmutableArray.Builder append(long value) {
        LongBuffer current;
        if (this.outer == this.buffers.size()) {
            current = ByteBuffer.allocateDirect(0x20000000).asLongBuffer();
            this.buffers.add(current);
        } else {
            current = this.buffers.getLast();
        }
        current.put(this.inner, value);
        this.bitmask |= value;
        if (0x4000000 == ++this.inner) {
            this.inner = 0;
            ++this.outer;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongImmutableArray build() {
        if (this.buffers.isEmpty()) {
            return new EmptyImmutableArray();
        }
        if (BitUtil.isLongToBytePossible(this.bitmask)) {
            ByteImmutableArray.Builder builder = ByteImmutableArray.builder();
            this.forEachThenClear(value -> builder.append(BitUtil.longToByte(value)));
            this.buffers.forEach(MemoryUtil::clear);
            return (LongImmutableArray)((Object)builder.build());
        }
        if (BitUtil.isLongToShortPossible(this.bitmask)) {
            ShortImmutableArray.Builder builder = ShortImmutableArray.builder();
            this.forEachThenClear(value -> builder.append(BitUtil.longToShort(value)));
            this.buffers.forEach(MemoryUtil::clear);
            return (LongImmutableArray)((Object)builder.build());
        }
        if (BitUtil.isLongToIntPossible(this.bitmask)) {
            IntImmutableArray.Builder builder = IntImmutableArray.builder();
            this.forEachThenClear(value -> builder.append(BitUtil.longToInt(value)));
            this.buffers.forEach(MemoryUtil::clear);
            return (LongImmutableArray)((Object)builder.build());
        }
        if (this.outer == 0) {
            LongBuffer current = this.buffers.getFirst();
            if (this.inner < Short.MAX_VALUE) {
                try {
                    long[] array = new long[this.inner];
                    for (int i = 0; i < this.inner; ++i) {
                        array[i] = current.get(i);
                    }
                    LongImmutableArrayImpl longImmutableArrayImpl = new LongImmutableArrayImpl(array);
                    return longImmutableArrayImpl;
                }
                finally {
                    MemoryUtil.clear(current);
                }
            }
            return new LongSingleBufferImmutableArrayImpl(current, this.inner);
        }
        return new LongMultiBufferImmutableArrayImpl(this.bufferArray(), this.length());
    }

    private long length() {
        return this.outer * 0x4000000 + this.inner;
    }

    private LongBuffer[] bufferArray() {
        return this.buffers.toArray(new LongBuffer[this.outer + 1]);
    }

    private void forEachThenClear(LongConsumer action) {
        long length = this.length();
        LongBuffer[] bufferArray = this.bufferArray();
        for (long l = 0L; l < length; ++l) {
            int o = IndexUtil.outerIndex(l);
            int i = IndexUtil.innerIndex(l);
            action.accept(bufferArray[o].get(i));
            if (i + 1 != 0x4000000) continue;
            MemoryUtil.clear(bufferArray[o]);
        }
    }
}

