/*
 * Decompiled with CFR 0.152.
 */
package com.github.pyknic.bigarray.internal;

import com.github.pyknic.bigarray.ByteImmutableArray;
import com.github.pyknic.bigarray.internal.ByteImmutableArrayImpl;
import com.github.pyknic.bigarray.internal.ByteMultiBufferImmutableArrayImpl;
import com.github.pyknic.bigarray.internal.ByteSingleBufferImmutableArrayImpl;
import com.github.pyknic.bigarray.internal.EmptyImmutableArray;
import com.github.pyknic.bigarray.internal.util.IndexUtil;
import com.github.pyknic.bigarray.internal.util.MemoryUtil;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public final class ByteImmutableArrayBuilder
implements ByteImmutableArray.Builder {
    private final LinkedList<ByteBuffer> buffers = new LinkedList();
    private int outer = 0;
    private int inner = 0;

    @Override
    public ByteImmutableArray.Builder append(byte value) {
        ByteBuffer current;
        if (this.outer == this.buffers.size()) {
            current = ByteBuffer.allocateDirect(0x4000000);
            this.buffers.add(current);
        } else {
            current = this.buffers.getLast();
        }
        current.put(this.inner, value);
        if (0x4000000 == ++this.inner) {
            this.inner = 0;
            ++this.outer;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteImmutableArray build() {
        if (this.buffers.isEmpty()) {
            return new EmptyImmutableArray();
        }
        if (this.outer == 0) {
            ByteBuffer current = this.buffers.getFirst();
            if (this.inner < Short.MAX_VALUE) {
                try {
                    byte[] array = new byte[this.inner];
                    for (int i = 0; i < this.inner; ++i) {
                        array[i] = current.get(i);
                    }
                    ByteImmutableArrayImpl byteImmutableArrayImpl = new ByteImmutableArrayImpl(array);
                    return byteImmutableArrayImpl;
                }
                finally {
                    MemoryUtil.clear(current);
                }
            }
            return new ByteSingleBufferImmutableArrayImpl(current, this.inner);
        }
        return new ByteMultiBufferImmutableArrayImpl(this.bufferArray(), this.length());
    }

    private long length() {
        return this.outer * 0x4000000 + this.inner;
    }

    private ByteBuffer[] bufferArray() {
        return this.buffers.toArray(new ByteBuffer[this.outer + 1]);
    }

    private void forEachThenClear(ByteConsumer action) {
        long length = this.length();
        ByteBuffer[] bufferArray = this.bufferArray();
        for (long l = 0L; l < length; ++l) {
            int o = IndexUtil.outerIndex(l);
            int i = IndexUtil.innerIndex(l);
            action.accept(bufferArray[o].get(i));
            if (i + 1 != 0x4000000) continue;
            MemoryUtil.clear(bufferArray[o]);
        }
    }

    @FunctionalInterface
    private static interface ByteConsumer {
        public void accept(byte var1);
    }
}

