/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library.rx2.network.observing.strategy;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Looper;
import android.util.Log;
import com.github.pwittchen.reactivenetwork.library.rx2.Connectivity;
import com.github.pwittchen.reactivenetwork.library.rx2.network.observing.NetworkObservingStrategy;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.functions.Action;

public class PreLollipopNetworkObservingStrategy
implements NetworkObservingStrategy {
    @Override
    public Observable<Connectivity> observeNetworkConnectivity(final Context context) {
        final IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Connectivity>(){

            public void subscribe(final ObservableEmitter<Connectivity> emitter) throws Exception {
                final BroadcastReceiver receiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        emitter.onNext((Object)Connectivity.create(context));
                    }
                };
                context.registerReceiver(receiver, filter);
                Disposable disposable = PreLollipopNetworkObservingStrategy.this.disposeInUiThread(new Action(){

                    public void run() {
                        PreLollipopNetworkObservingStrategy.this.tryToUnregisterReceiver(context, receiver);
                    }
                });
                emitter.setDisposable(disposable);
            }
        }).defaultIfEmpty((Object)Connectivity.create());
    }

    protected void tryToUnregisterReceiver(Context context, BroadcastReceiver receiver) {
        try {
            context.unregisterReceiver(receiver);
        }
        catch (Exception exception) {
            this.onError("receiver was already unregistered", exception);
        }
    }

    @Override
    public void onError(String message, Exception exception) {
        Log.e((String)"ReactiveNetwork", (String)message, (Throwable)exception);
    }

    private Disposable disposeInUiThread(final Action action) {
        return Disposables.fromAction((Action)new Action(){

            public void run() throws Exception {
                if (Looper.getMainLooper() == Looper.myLooper()) {
                    action.run();
                } else {
                    final Scheduler.Worker inner = AndroidSchedulers.mainThread().createWorker();
                    inner.schedule(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                action.run();
                            }
                            catch (Exception e) {
                                PreLollipopNetworkObservingStrategy.this.onError("Could not unregister receiver in UI Thread", e);
                            }
                            inner.dispose();
                        }
                    });
                }
            }
        });
    }
}

