/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library.rx2;

import android.content.Context;
import android.support.annotation.RequiresPermission;
import com.github.pwittchen.reactivenetwork.library.rx2.Connectivity;
import com.github.pwittchen.reactivenetwork.library.rx2.Preconditions;
import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.InternetObservingSettings;
import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.InternetObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.error.ErrorHandler;
import com.github.pwittchen.reactivenetwork.library.rx2.network.observing.NetworkObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.rx2.network.observing.strategy.LollipopNetworkObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.rx2.network.observing.strategy.MarshmallowNetworkObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.rx2.network.observing.strategy.PreLollipopNetworkObservingStrategy;
import io.reactivex.Observable;
import io.reactivex.Single;

public class ReactiveNetwork {
    public static final String LOG_TAG = "ReactiveNetwork";

    protected ReactiveNetwork() {
    }

    public static ReactiveNetwork create() {
        return new ReactiveNetwork();
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static Observable<Connectivity> observeNetworkConnectivity(Context context) {
        NetworkObservingStrategy strategy = Preconditions.isAtLeastAndroidMarshmallow() ? new MarshmallowNetworkObservingStrategy() : (Preconditions.isAtLeastAndroidLollipop() ? new LollipopNetworkObservingStrategy() : new PreLollipopNetworkObservingStrategy());
        return ReactiveNetwork.observeNetworkConnectivity(context, strategy);
    }

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public static Observable<Connectivity> observeNetworkConnectivity(Context context, NetworkObservingStrategy strategy) {
        Preconditions.checkNotNull(context, "context == null");
        Preconditions.checkNotNull(strategy, "strategy == null");
        return strategy.observeNetworkConnectivity(context);
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Observable<Boolean> observeInternetConnectivity() {
        InternetObservingSettings settings = InternetObservingSettings.create();
        return ReactiveNetwork.observeInternetConnectivity(settings.strategy(), settings.initialInterval(), settings.interval(), settings.host(), settings.port(), settings.timeout(), settings.httpResponse(), settings.errorHandler());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Observable<Boolean> observeInternetConnectivity(InternetObservingSettings settings) {
        return ReactiveNetwork.observeInternetConnectivity(settings.strategy(), settings.initialInterval(), settings.interval(), settings.host(), settings.port(), settings.timeout(), settings.httpResponse(), settings.errorHandler());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    protected static Observable<Boolean> observeInternetConnectivity(InternetObservingStrategy strategy, int initialIntervalInMs, int intervalInMs, String host, int port, int timeoutInMs, int httpResponse, ErrorHandler errorHandler) {
        ReactiveNetwork.checkStrategyIsNotNull(strategy);
        return strategy.observeInternetConnectivity(initialIntervalInMs, intervalInMs, host, port, timeoutInMs, httpResponse, errorHandler);
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Single<Boolean> checkInternetConnectivity() {
        InternetObservingSettings settings = InternetObservingSettings.create();
        return ReactiveNetwork.checkInternetConnectivity(settings.strategy(), settings.host(), settings.port(), settings.timeout(), settings.httpResponse(), settings.errorHandler());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public static Single<Boolean> checkInternetConnectivity(InternetObservingSettings settings) {
        return ReactiveNetwork.checkInternetConnectivity(settings.strategy(), settings.host(), settings.port(), settings.timeout(), settings.httpResponse(), settings.errorHandler());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    protected static Single<Boolean> checkInternetConnectivity(InternetObservingStrategy strategy, String host, int port, int timeoutInMs, int httpResponse, ErrorHandler errorHandler) {
        ReactiveNetwork.checkStrategyIsNotNull(strategy);
        return strategy.checkInternetConnectivity(host, port, timeoutInMs, httpResponse, errorHandler);
    }

    private static void checkStrategyIsNotNull(InternetObservingStrategy strategy) {
        Preconditions.checkNotNull(strategy, "strategy == null");
    }
}

