/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library.rx2.network.observing.strategy;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.util.Log;
import com.github.pwittchen.reactivenetwork.library.rx2.Connectivity;
import com.github.pwittchen.reactivenetwork.library.rx2.network.observing.NetworkObservingStrategy;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Observable;
import io.reactivex.functions.Action;
import io.reactivex.subjects.PublishSubject;

@TargetApi(value=23)
public class MarshmallowNetworkObservingStrategy
implements NetworkObservingStrategy {
    protected static final String ERROR_MSG_NETWORK_CALLBACK = "could not unregister network callback";
    protected static final String ERROR_MSG_RECEIVER = "could not unregister receiver";
    private ConnectivityManager.NetworkCallback networkCallback;
    private PublishSubject<Connectivity> connectivitySubject = PublishSubject.create();
    private BroadcastReceiver idleReceiver = this.createIdleBroadcastReceiver();

    @Override
    public Observable<Connectivity> observeNetworkConnectivity(final Context context) {
        String service = "connectivity";
        final ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        this.networkCallback = this.createNetworkCallback(context);
        this.registerIdleReceiver(context);
        NetworkRequest request = new NetworkRequest.Builder().addCapability(12).addCapability(13).build();
        manager.registerNetworkCallback(request, this.networkCallback);
        return this.connectivitySubject.toFlowable(BackpressureStrategy.LATEST).doOnCancel(new Action(){

            public void run() {
                MarshmallowNetworkObservingStrategy.this.tryToUnregisterCallback(manager);
                MarshmallowNetworkObservingStrategy.this.tryToUnregisterReceiver(context);
            }
        }).startWith((Object)Connectivity.create(context)).distinctUntilChanged().toObservable();
    }

    protected void registerIdleReceiver(Context context) {
        IntentFilter filter = new IntentFilter("android.os.action.DEVICE_IDLE_MODE_CHANGED");
        context.registerReceiver(this.idleReceiver, filter);
    }

    @NonNull
    protected BroadcastReceiver createIdleBroadcastReceiver() {
        return new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (MarshmallowNetworkObservingStrategy.this.isIdleMode(context)) {
                    MarshmallowNetworkObservingStrategy.this.onNext(Connectivity.create());
                } else {
                    MarshmallowNetworkObservingStrategy.this.onNext(Connectivity.create(context));
                }
            }
        };
    }

    protected boolean isIdleMode(Context context) {
        String packageName = context.getPackageName();
        PowerManager manager = (PowerManager)context.getSystemService("power");
        boolean isIgnoringOptimizations = manager.isIgnoringBatteryOptimizations(packageName);
        return manager.isDeviceIdleMode() && !isIgnoringOptimizations;
    }

    protected void tryToUnregisterCallback(ConnectivityManager manager) {
        try {
            manager.unregisterNetworkCallback(this.networkCallback);
        }
        catch (Exception exception) {
            this.onError(ERROR_MSG_NETWORK_CALLBACK, exception);
        }
    }

    protected void tryToUnregisterReceiver(Context context) {
        try {
            context.unregisterReceiver(this.idleReceiver);
        }
        catch (Exception exception) {
            this.onError(ERROR_MSG_RECEIVER, exception);
        }
    }

    @Override
    public void onError(String message, Exception exception) {
        Log.e((String)"ReactiveNetwork", (String)message, (Throwable)exception);
    }

    protected ConnectivityManager.NetworkCallback createNetworkCallback(final Context context) {
        return new ConnectivityManager.NetworkCallback(){

            public void onAvailable(Network network) {
                MarshmallowNetworkObservingStrategy.this.onNext(Connectivity.create(context));
            }

            public void onLost(Network network) {
                MarshmallowNetworkObservingStrategy.this.onNext(Connectivity.create(context));
            }
        };
    }

    protected void onNext(Connectivity connectivity) {
        this.connectivitySubject.onNext((Object)connectivity);
    }
}

