/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library.rx2.internet.observing;

import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.InternetObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.error.DefaultErrorHandler;
import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.error.ErrorHandler;
import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.strategy.WalledGardenInternetObservingStrategy;

public final class InternetObservingSettings {
    private final int initialInterval;
    private final int interval;
    private final String host;
    private final int port;
    private final int timeout;
    private final ErrorHandler errorHandler;
    private final InternetObservingStrategy strategy;

    private InternetObservingSettings(int initialInterval, int interval, String host, int port, int timeout, ErrorHandler errorHandler, InternetObservingStrategy strategy) {
        this.initialInterval = initialInterval;
        this.interval = interval;
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.errorHandler = errorHandler;
        this.strategy = strategy;
    }

    public static InternetObservingSettings create() {
        return new Builder().build();
    }

    private InternetObservingSettings(Builder builder) {
        this(builder.initialInterval, builder.interval, builder.host, builder.port, builder.timeout, builder.errorHandler, builder.strategy);
    }

    private InternetObservingSettings() {
        this(InternetObservingSettings.builder());
    }

    private static Builder builder() {
        return new Builder();
    }

    public int initialInterval() {
        return this.initialInterval;
    }

    public static Builder initialInterval(int initialInterval) {
        return InternetObservingSettings.builder().initialInterval(initialInterval);
    }

    public int interval() {
        return this.interval;
    }

    public static Builder interval(int interval) {
        return InternetObservingSettings.builder().interval(interval);
    }

    public String host() {
        return this.host;
    }

    public static Builder host(String host) {
        return InternetObservingSettings.builder().host(host);
    }

    public int port() {
        return this.port;
    }

    public static Builder port(int port) {
        return InternetObservingSettings.builder().port(port);
    }

    public int timeout() {
        return this.timeout;
    }

    public static Builder timeout(int timeout) {
        return InternetObservingSettings.builder().timeout(timeout);
    }

    public ErrorHandler errorHandler() {
        return this.errorHandler;
    }

    public static Builder errorHandler(ErrorHandler errorHandler) {
        return InternetObservingSettings.builder().errorHandler(errorHandler);
    }

    public InternetObservingStrategy strategy() {
        return this.strategy;
    }

    public static Builder strategy(InternetObservingStrategy strategy) {
        return InternetObservingSettings.builder().strategy(strategy);
    }

    public static final class Builder {
        private int initialInterval = 0;
        private int interval = 2000;
        private String host = "http://clients3.google.com/generate_204";
        private int port = 80;
        private int timeout = 2000;
        private ErrorHandler errorHandler = new DefaultErrorHandler();
        private InternetObservingStrategy strategy = new WalledGardenInternetObservingStrategy();

        private Builder() {
        }

        public Builder initialInterval(int initialInterval) {
            this.initialInterval = initialInterval;
            return this;
        }

        public Builder interval(int interval) {
            this.interval = interval;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Builder strategy(InternetObservingStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public InternetObservingSettings build() {
            return new InternetObservingSettings(this);
        }
    }
}

