/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.strategy;

import com.github.pwittchen.reactivenetwork.library.rx2.Preconditions;
import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.InternetObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.error.ErrorHandler;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;

public class SocketInternetObservingStrategy
implements InternetObservingStrategy {
    @Override
    public Observable<Boolean> observeInternetConnectivity(int initialIntervalInMs, int intervalInMs, final String host, final int port, final int timeoutInMs, final ErrorHandler errorHandler) {
        Preconditions.checkGreaterOrEqualToZero(initialIntervalInMs, "initialIntervalInMs is not a positive number");
        Preconditions.checkGreaterThanZero(intervalInMs, "intervalInMs is not a positive number");
        Preconditions.checkNotNullOrEmpty(host, "host is null or empty");
        Preconditions.checkGreaterThanZero(port, "port is not a positive number");
        Preconditions.checkGreaterThanZero(timeoutInMs, "timeoutInMs is not a positive number");
        Preconditions.checkNotNull(errorHandler, "errorHandler is null");
        return Observable.interval((long)initialIntervalInMs, (long)intervalInMs, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.io()).map((Function)new Function<Long, Boolean>(){

            public Boolean apply(@NonNull Long tick) throws Exception {
                return SocketInternetObservingStrategy.this.isConnected(host, port, timeoutInMs, errorHandler);
            }
        }).distinctUntilChanged();
    }

    public boolean isConnected(String host, int port, int timeoutInMs, ErrorHandler errorHandler) {
        Socket socket = new Socket();
        return this.isConnected(socket, host, port, timeoutInMs, errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected(Socket socket, String host, int port, int timeoutInMs, ErrorHandler errorHandler) {
        boolean isConnected;
        try {
            socket.connect(new InetSocketAddress(host, port), timeoutInMs);
            isConnected = socket.isConnected();
        }
        catch (IOException e) {
            isConnected = Boolean.FALSE;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException exception) {
                errorHandler.handleError(exception, "Could not close the socket");
            }
        }
        return isConnected;
    }
}

