/*
 * Decompiled with CFR 0.152.
 */
package com.github.pukkaone.jsp;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class ValueResolver {
    public static final Object NOT_FOUND = new Object();
    protected static final ValueFetcher MAP_FETCHER = new ValueFetcher(){

        @Override
        public Object get(Object model, String name) {
            Map map = (Map)model;
            Object value = map.get(name);
            if (value == null && !map.containsKey(name)) {
                value = NOT_FOUND;
            }
            return value;
        }
    };
    protected static Map<Key, ValueFetcher> fetcherCache = new ConcurrentHashMap<Key, ValueFetcher>();
    private Object model;

    public ValueResolver(Object model) {
        this.model = model;
    }

    protected static Method getMethod(Class<?> clazz, String name) {
        Method method;
        try {
            method = clazz.getDeclaredMethod(name, new Class[0]);
            if (!method.getReturnType().equals(Void.TYPE)) {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return method;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            String getter = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            method = clazz.getDeclaredMethod(getter, new Class[0]);
            if (!method.getReturnType().equals(Void.TYPE)) {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return method;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class && superClass != null) {
            return ValueResolver.getMethod(superClass, name);
        }
        return null;
    }

    protected static Field getField(Class<?> clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field;
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != Object.class && superClass != null) {
                return ValueResolver.getField(superClass, name);
            }
            return null;
        }
    }

    protected static ValueFetcher createFetcher(Key key) {
        if (Map.class.isAssignableFrom(key.modelClass)) {
            return MAP_FETCHER;
        }
        final Method method = ValueResolver.getMethod(key.modelClass, key.name);
        if (method != null) {
            return new ValueFetcher(){

                @Override
                public Object get(Object data, String name) {
                    try {
                        return method.invoke(data, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("method.invoke", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalStateException("method.invoke", e);
                    }
                }
            };
        }
        final Field field = ValueResolver.getField(key.modelClass, key.name);
        if (field != null) {
            return new ValueFetcher(){

                @Override
                public Object get(Object data, String name) {
                    try {
                        return field.get(data);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("field.get", e);
                    }
                }
            };
        }
        return null;
    }

    protected ValueFetcher getFetcher(Key key) {
        ValueFetcher fetcher = fetcherCache.get(key);
        if (fetcher == null && (fetcher = ValueResolver.createFetcher(key)) != null) {
            fetcherCache.put(key, fetcher);
        }
        return fetcher;
    }

    private Object getValueInternal(String name) {
        Key key = new Key(this.model.getClass(), name);
        ValueFetcher fetcher = this.getFetcher(key);
        if (fetcher == null) {
            return NOT_FOUND;
        }
        try {
            return fetcher.get(this.model, name);
        }
        catch (IllegalStateException e) {
            fetcher = ValueResolver.createFetcher(key);
            if (fetcher != null) {
                fetcherCache.put(key, fetcher);
            }
            if (fetcher == null) {
                return NOT_FOUND;
            }
            return fetcher.get(this.model, name);
        }
    }

    public Object getValue(String name) {
        Object value = this.getValueInternal(name);
        if (value instanceof Callable) {
            try {
                value = ((Callable)value).call();
            }
            catch (Exception e) {
                throw new RuntimeException("call", e);
            }
        }
        return value;
    }

    protected static interface ValueFetcher {
        public Object get(Object var1, String var2);
    }

    protected static class Key {
        public final Class<?> modelClass;
        public final String name;

        public Key(Class<?> modelClass, String name) {
            this.modelClass = modelClass;
            this.name = name;
        }

        public int hashCode() {
            return this.modelClass.hashCode() + this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            return this.modelClass == key.modelClass && this.name.equals(key.name);
        }
    }
}

