/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.stetho_realm.delegate;

import com.facebook.stetho.inspector.jsonrpc.JsonRpcException;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcPeer;
import com.facebook.stetho.inspector.jsonrpc.JsonRpcResult;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsDomain;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsMethod;
import com.facebook.stetho.json.ObjectMapper;
import com.facebook.stetho.json.annotation.JsonProperty;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class Database
implements ChromeDevtoolsDomain {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final com.facebook.stetho.inspector.protocol.module.Database database;
    private final com.uphyca.stetho_realm.Database realmDatabase;
    private final Pattern databaseNamePattern;

    public Database(com.facebook.stetho.inspector.protocol.module.Database database, com.uphyca.stetho_realm.Database realmDatabase, Pattern databaseNamePattern) {
        this.database = database;
        this.realmDatabase = realmDatabase;
        this.databaseNamePattern = databaseNamePattern;
    }

    @ChromeDevtoolsMethod
    public void enable(JsonRpcPeer peer, JSONObject params) {
        this.database.enable(peer, params);
        this.realmDatabase.enable(peer, params);
    }

    @ChromeDevtoolsMethod
    public void disable(JsonRpcPeer peer, JSONObject params) {
        this.database.disable(peer, params);
        this.realmDatabase.disable(peer, params);
    }

    @ChromeDevtoolsMethod
    public JsonRpcResult getDatabaseTableNames(JsonRpcPeer peer, JSONObject params) throws JsonRpcException {
        GetDatabaseTableNamesRequest request = (GetDatabaseTableNamesRequest)this.objectMapper.convertValue((Object)params, GetDatabaseTableNamesRequest.class);
        if (this.databaseNamePattern.matcher(request.databaseId).find()) {
            return this.realmDatabase.getDatabaseTableNames(peer, params);
        }
        return this.database.getDatabaseTableNames(peer, params);
    }

    @ChromeDevtoolsMethod
    public JsonRpcResult executeSQL(JsonRpcPeer peer, JSONObject params) {
        ExecuteSQLRequest request = (ExecuteSQLRequest)this.objectMapper.convertValue((Object)params, ExecuteSQLRequest.class);
        if (this.databaseNamePattern.matcher(request.databaseId).find()) {
            return this.realmDatabase.executeSQL(peer, params);
        }
        return this.database.executeSQL(peer, params);
    }

    private static class ExecuteSQLRequest {
        @JsonProperty(required=true)
        public String databaseId;
        @JsonProperty(required=true)
        public String query;

        private ExecuteSQLRequest() {
        }
    }

    private static class GetDatabaseTableNamesRequest {
        @JsonProperty(required=true)
        public String databaseId;

        private GetDatabaseTableNamesRequest() {
        }
    }
}

