/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.stetho_realm;

import android.content.Context;
import com.facebook.stetho.InspectorModulesProvider;
import com.facebook.stetho.Stetho;
import com.facebook.stetho.inspector.protocol.ChromeDevtoolsDomain;
import com.uphyca.stetho_realm.Database;
import com.uphyca.stetho_realm.RealmFilesProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class RealmInspectorModulesProvider
implements InspectorModulesProvider {
    private static final Pattern DEFAULT_DATABASE_NAME_PATTERN = Pattern.compile(".+\\.realm");
    private static final long DEFAULT_LIMIT = 250L;
    private static final boolean DEFAULT_ASCENDING_ORDER = true;
    private static final int ENCRYPTION_KEY_LENGTH = 64;
    private final String packageName;
    private final InspectorModulesProvider baseProvider;
    private File folder;
    private final boolean withMetaTables;
    private final Pattern databaseNamePattern;
    private final long limit;
    private final boolean ascendingOrder;
    private byte[] defaultEncryptionKey;
    private Map<String, byte[]> encryptionKeys;

    @Deprecated
    public static RealmInspectorModulesProvider wrap(Context context, InspectorModulesProvider provider) {
        return RealmInspectorModulesProvider.wrap(context, provider, false);
    }

    @Deprecated
    public static RealmInspectorModulesProvider wrap(Context context, InspectorModulesProvider provider, boolean withMetaTables) {
        return RealmInspectorModulesProvider.wrap(context, provider, withMetaTables, null);
    }

    @Deprecated
    public static RealmInspectorModulesProvider wrap(Context context, InspectorModulesProvider provider, boolean withMetaTables, Pattern databaseNamePattern) {
        return new RealmInspectorModulesProvider(context.getPackageName(), provider, context.getFilesDir(), withMetaTables, databaseNamePattern, 250L, true, null, null);
    }

    private RealmInspectorModulesProvider(String packageName, InspectorModulesProvider baseProvider, File folder, boolean withMetaTables, Pattern databaseNamePattern, long limit, boolean ascendingOrder, byte[] defaultEncryptionKey, Map<String, byte[]> encryptionKeys) {
        this.packageName = packageName;
        this.baseProvider = baseProvider;
        this.folder = folder;
        this.withMetaTables = withMetaTables;
        this.databaseNamePattern = databaseNamePattern == null ? DEFAULT_DATABASE_NAME_PATTERN : databaseNamePattern;
        this.limit = limit;
        this.ascendingOrder = ascendingOrder;
        this.defaultEncryptionKey = defaultEncryptionKey;
        this.encryptionKeys = encryptionKeys == null ? Collections.emptyMap() : encryptionKeys;
    }

    public Iterable<ChromeDevtoolsDomain> get() {
        ArrayList<ChromeDevtoolsDomain> modules = new ArrayList<ChromeDevtoolsDomain>();
        com.facebook.stetho.inspector.protocol.module.Database database = null;
        for (ChromeDevtoolsDomain domain : this.baseProvider.get()) {
            if (domain instanceof com.facebook.stetho.inspector.protocol.module.Database) {
                database = (com.facebook.stetho.inspector.protocol.module.Database)domain;
                continue;
            }
            modules.add(domain);
        }
        Database realmDatabase = new Database(this.packageName, new RealmFilesProvider(this.folder, this.databaseNamePattern), this.withMetaTables, this.limit, this.ascendingOrder, this.defaultEncryptionKey, this.encryptionKeys);
        modules.add((ChromeDevtoolsDomain)(database == null ? realmDatabase : new com.uphyca.stetho_realm.delegate.Database(database, realmDatabase, this.databaseNamePattern)));
        return modules;
    }

    public static ProviderBuilder builder(Context context) {
        return new ProviderBuilder(context);
    }

    public static class ProviderBuilder {
        private final Context applicationContext;
        private InspectorModulesProvider baseProvider;
        private boolean withMetaTables;
        private Pattern databaseNamePattern;
        private File folder;
        private long limit = 250L;
        private boolean ascendingOrder = true;
        private byte[] defaultEncryptionKey;
        private Map<String, byte[]> encryptionKeys;

        public ProviderBuilder(Context context) {
            this.applicationContext = context.getApplicationContext();
            this.folder = this.applicationContext.getFilesDir();
        }

        public ProviderBuilder baseProvider(InspectorModulesProvider provider) {
            this.baseProvider = provider;
            return this;
        }

        public ProviderBuilder withMetaTables() {
            this.withMetaTables = true;
            return this;
        }

        public ProviderBuilder withLimit(long limit) {
            this.limit = limit;
            return this;
        }

        public ProviderBuilder withFolder(File folder) {
            this.folder = folder;
            return this;
        }

        public ProviderBuilder withDescendingOrder() {
            this.ascendingOrder = false;
            return this;
        }

        public ProviderBuilder databaseNamePattern(Pattern databaseNamePattern) {
            this.databaseNamePattern = databaseNamePattern;
            return this;
        }

        public ProviderBuilder withDefaultEncryptionKey(byte[] key) {
            if (key != null) {
                if (key.length != 64) {
                    throw new IllegalArgumentException(String.format("The provided key must be %s bytes. Yours was: %s", 64, key.length));
                }
                this.defaultEncryptionKey = (byte[])key.clone();
            } else {
                this.defaultEncryptionKey = null;
            }
            return this;
        }

        public ProviderBuilder withEncryptionKey(String filename, byte[] key) {
            if (this.encryptionKeys == null) {
                this.encryptionKeys = new HashMap<String, byte[]>();
            }
            if (key != null) {
                if (key.length != 64) {
                    throw new IllegalArgumentException(String.format("The provided key must be %s bytes. Yours was: %s", 64, key.length));
                }
                this.encryptionKeys.put(filename, (byte[])key.clone());
            } else {
                this.encryptionKeys.put(filename, null);
            }
            return this;
        }

        public RealmInspectorModulesProvider build() {
            InspectorModulesProvider baseProvider = this.baseProvider != null ? this.baseProvider : Stetho.defaultInspectorModulesProvider((Context)this.applicationContext);
            return new RealmInspectorModulesProvider(this.applicationContext.getPackageName(), baseProvider, this.folder, this.withMetaTables, this.databaseNamePattern, this.limit, this.ascendingOrder, this.defaultEncryptionKey, this.encryptionKeys);
        }
    }
}

