/*
 * Decompiled with CFR 0.152.
 */
package com.uphyca.stetho_realm;

import com.facebook.stetho.inspector.database.DatabaseFilesProvider;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class RealmFilesProvider
implements DatabaseFilesProvider {
    private final File folder;
    private final Pattern databaseNamePattern;

    public RealmFilesProvider(File folder, Pattern databaseNamePattern) {
        this.folder = folder;
        this.databaseNamePattern = databaseNamePattern;
    }

    public List<File> getDatabaseFiles() {
        File baseDir = this.folder;
        String[] realmFiles = baseDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return RealmFilesProvider.this.databaseNamePattern.matcher(filename).matches();
            }
        });
        ArrayList<File> files = new ArrayList<File>();
        if (realmFiles == null) {
            return files;
        }
        for (String realmFileName : realmFiles) {
            File file = new File(baseDir, realmFileName);
            if (!file.isFile() || !file.canRead()) continue;
            files.add(file);
        }
        return files;
    }
}

