/*
 * Decompiled with CFR 0.152.
 */
package com.github.promeg.xlog_android.lib;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.promegu.xlog.base.MethodToLog;
import com.taobao.android.dexposed.ClassUtils;
import com.taobao.android.dexposed.XposedHelpers;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MultiDexHelper {
    private static final String TAG = "MultiDexHelper";
    private static final String EXTRACTED_NAME_EXT = ".classes";
    private static final String EXTRACTED_SUFFIX = ".zip";
    private static final String SECONDARY_FOLDER_NAME = "code_cache" + File.separator + "secondary-dexes";
    private static final String PREFS_FILE = "multidex.version";
    private static final String KEY_DEX_NUMBER = "dex.number";

    private static SharedPreferences getMultiDexPreferences(Context context) {
        return context.getSharedPreferences(PREFS_FILE, Build.VERSION.SDK_INT < 11 ? 0 : 4);
    }

    public static List<String> getSourcePaths(Context context) throws PackageManager.NameNotFoundException, IOException {
        ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
        File sourceApk = new File(applicationInfo.sourceDir);
        File dexDir = new File(applicationInfo.dataDir, SECONDARY_FOLDER_NAME);
        ArrayList<String> sourcePaths = new ArrayList<String>();
        sourcePaths.add(applicationInfo.sourceDir);
        String extractedFilePrefix = sourceApk.getName() + EXTRACTED_NAME_EXT;
        int totalDexNumber = MultiDexHelper.getMultiDexPreferences(context).getInt(KEY_DEX_NUMBER, 1);
        for (int secondaryNumber = 2; secondaryNumber <= totalDexNumber; ++secondaryNumber) {
            String fileName = extractedFilePrefix + secondaryNumber + EXTRACTED_SUFFIX;
            File extractedFile = new File(dexDir, fileName);
            if (!extractedFile.isFile()) {
                throw new IOException("Missing extracted secondary dex file '" + extractedFile.getPath() + "'");
            }
            sourcePaths.add(extractedFile.getAbsolutePath());
        }
        return sourcePaths;
    }

    public static List<Class<?>> getAllClasses(Context context) throws PackageManager.NameNotFoundException, IOException {
        ArrayList classNames = new ArrayList();
        List<String> sourcePaths = MultiDexHelper.getSourcePaths(context);
        for (String path : sourcePaths) {
            try {
                DexFile dexfile = null;
                dexfile = path.endsWith(EXTRACTED_SUFFIX) ? DexFile.loadDex((String)path, (String)(path + ".tmp"), (int)0) : new DexFile(path);
                Enumeration dexEntries = dexfile.entries();
                while (dexEntries.hasMoreElements()) {
                    try {
                        classNames.add(ClassUtils.getClass((String)((String)dexEntries.nextElement())));
                    }
                    catch (Throwable e) {
                        Log.d((String)TAG, (String)("class not found: " + (String)dexEntries.nextElement()));
                    }
                }
            }
            catch (IOException e) {
                throw new IOException("Error at loading dex file '" + path + "'");
            }
        }
        return classNames;
    }

    public static List<String> getAllClassNames(Context context) throws PackageManager.NameNotFoundException, IOException {
        ArrayList<String> classNames = new ArrayList<String>();
        List<String> sourcePaths = MultiDexHelper.getSourcePaths(context);
        for (String path : sourcePaths) {
            try {
                DexFile dexfile = null;
                dexfile = path.endsWith(EXTRACTED_SUFFIX) ? DexFile.loadDex((String)path, (String)(path + ".tmp"), (int)0) : new DexFile(path);
                Enumeration dexEntries = dexfile.entries();
                while (dexEntries.hasMoreElements()) {
                    classNames.add((String)dexEntries.nextElement());
                }
            }
            catch (IOException e) {
                throw new IOException("Error at loading dex file '" + path + "'");
            }
        }
        Log.d((String)TAG, (String)("getAllClassNames count: " + classNames.size()));
        return classNames;
    }

    public static Set<MethodToLog> getAllMethodToLog(Context context, String xLogPkgName) {
        List<String> allClassNames = null;
        try {
            allClassNames = MultiDexHelper.getAllClassNames(context);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (allClassNames == null) {
            return null;
        }
        HashSet<MethodToLog> methodToLogs = new HashSet<MethodToLog>();
        for (String className : allClassNames) {
            if (className == null || !className.startsWith(xLogPkgName + "." + "XLoggerMethods")) continue;
            String methodsStr = null;
            try {
                Class xlogClass = ClassUtils.getClass((String)className);
                methodsStr = (String)XposedHelpers.findField((Class)xlogClass, (String)"METHODS_TO_LOG").get(null);
            }
            catch (Throwable e) {
                e.printStackTrace();
                Log.d((String)TAG, (String)("still not found: " + className));
            }
            methodToLogs.addAll((Collection)new Gson().fromJson(methodsStr, new TypeToken<List<MethodToLog>>(){}.getType()));
        }
        return methodToLogs;
    }

    public static Set<Member> getAllMethodsWithAnnoation(Context context, Class<? extends Annotation> annoationClass) {
        try {
            List<Class<?>> allClasses = MultiDexHelper.getAllClasses(context);
            HashSet<Member> allMethodsWithAnnoation = new HashSet<Member>();
            for (Class<?> entryClass : allClasses) {
                if (entryClass == null) continue;
                try {
                    Method[] methods = entryClass.getDeclaredMethods();
                    for (Executable executable : methods) {
                        if (!executable.isAnnotationPresent(annoationClass)) continue;
                        allMethodsWithAnnoation.add(executable);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    Constructor<?>[] constructors = entryClass.getDeclaredConstructors();
                    for (Executable executable : constructors) {
                        if (!executable.isAnnotationPresent(annoationClass)) continue;
                        allMethodsWithAnnoation.add(executable);
                    }
                }
                catch (Throwable t) {
                }
            }
            return allMethodsWithAnnoation;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

