/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ViewPropertyAnimator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.TextView;
import com.prolificinteractive.materialcalendarview.AnimatorListener;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.format.TitleFormatter;

class TitleChanger {
    public static final int DEFAULT_ANIMATION_DELAY = 400;
    public static final int DEFAULT_Y_TRANSLATION_DP = 20;
    private final TextView title;
    private TitleFormatter titleFormatter;
    private final int animDelay;
    private final int animDuration;
    private final int translate;
    private final Interpolator interpolator = new DecelerateInterpolator(2.0f);
    private int orientation = 0;
    private long lastAnimTime = 0L;
    private CalendarDay previousMonth = null;

    public TitleChanger(TextView title) {
        this.title = title;
        Resources res = title.getResources();
        this.animDelay = 400;
        this.animDuration = res.getInteger(0x10E0000) / 2;
        this.translate = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)res.getDisplayMetrics());
    }

    public void change(CalendarDay currentMonth) {
        long currentTime = System.currentTimeMillis();
        if (currentMonth == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.title.getText()) || currentTime - this.lastAnimTime < (long)this.animDelay) {
            this.doChange(currentTime, currentMonth, false);
        }
        if (currentMonth.equals(this.previousMonth) || currentMonth.getMonth() == this.previousMonth.getMonth()) {
            return;
        }
        this.doChange(currentTime, currentMonth, true);
    }

    private void doChange(long now, CalendarDay currentMonth, boolean animate) {
        this.title.animate().cancel();
        this.doTranslation(this.title, 0);
        this.title.setAlpha(1.0f);
        this.lastAnimTime = now;
        final CharSequence newTitle = this.titleFormatter.format(currentMonth);
        if (!animate) {
            this.title.setText(newTitle);
        } else {
            final int translation = this.translate * (this.previousMonth.isBefore(currentMonth) ? 1 : -1);
            ViewPropertyAnimator viewPropertyAnimator = this.title.animate();
            if (this.orientation == 1) {
                viewPropertyAnimator.translationX((float)(translation * -1));
            } else {
                viewPropertyAnimator.translationY((float)(translation * -1));
            }
            viewPropertyAnimator.alpha(0.0f).setDuration((long)this.animDuration).setInterpolator((TimeInterpolator)this.interpolator).setListener((Animator.AnimatorListener)new AnimatorListener(){

                @Override
                public void onAnimationCancel(Animator animator) {
                    TitleChanger.this.doTranslation(TitleChanger.this.title, 0);
                    TitleChanger.this.title.setAlpha(1.0f);
                }

                @Override
                public void onAnimationEnd(Animator animator) {
                    TitleChanger.this.title.setText(newTitle);
                    TitleChanger.this.doTranslation(TitleChanger.this.title, translation);
                    ViewPropertyAnimator viewPropertyAnimator = TitleChanger.this.title.animate();
                    if (TitleChanger.this.orientation == 1) {
                        viewPropertyAnimator.translationX(0.0f);
                    } else {
                        viewPropertyAnimator.translationY(0.0f);
                    }
                    viewPropertyAnimator.alpha(1.0f).setDuration((long)TitleChanger.this.animDuration).setInterpolator((TimeInterpolator)TitleChanger.this.interpolator).setListener((Animator.AnimatorListener)new AnimatorListener()).start();
                }
            }).start();
        }
        this.previousMonth = currentMonth;
    }

    private void doTranslation(TextView title, int translate) {
        if (this.orientation == 1) {
            title.setTranslationX((float)translate);
        } else {
            title.setTranslationY((float)translate);
        }
    }

    public TitleFormatter getTitleFormatter() {
        return this.titleFormatter;
    }

    public void setTitleFormatter(TitleFormatter titleFormatter) {
        this.titleFormatter = titleFormatter;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setPreviousMonth(CalendarDay previousMonth) {
        this.previousMonth = previousMonth;
    }
}

