/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DayViewFacade {
    private boolean isDecorated = false;
    private Drawable backgroundDrawable = null;
    private Drawable selectionDrawable = null;
    private final LinkedList<Span> spans = new LinkedList();
    private boolean daysDisabled = false;

    DayViewFacade() {
    }

    public void setBackgroundDrawable(@NonNull Drawable drawable) {
        if (drawable == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        this.backgroundDrawable = drawable;
        this.isDecorated = true;
    }

    public void setSelectionDrawable(@NonNull Drawable drawable) {
        if (drawable == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        this.selectionDrawable = drawable;
        this.isDecorated = true;
    }

    public void addSpan(@NonNull Object span) {
        if (this.spans != null) {
            this.spans.add(new Span(span));
            this.isDecorated = true;
        }
    }

    public void setDaysDisabled(boolean daysDisabled) {
        this.daysDisabled = daysDisabled;
        this.isDecorated = true;
    }

    void reset() {
        this.backgroundDrawable = null;
        this.selectionDrawable = null;
        this.spans.clear();
        this.isDecorated = false;
        this.daysDisabled = false;
    }

    void applyTo(DayViewFacade other) {
        if (this.selectionDrawable != null) {
            other.setSelectionDrawable(this.selectionDrawable);
        }
        if (this.backgroundDrawable != null) {
            other.setBackgroundDrawable(this.backgroundDrawable);
        }
        other.spans.addAll(this.spans);
        other.isDecorated |= this.isDecorated;
        other.daysDisabled = this.daysDisabled;
    }

    boolean isDecorated() {
        return this.isDecorated;
    }

    Drawable getSelectionDrawable() {
        return this.selectionDrawable;
    }

    Drawable getBackgroundDrawable() {
        return this.backgroundDrawable;
    }

    List<Span> getSpans() {
        return Collections.unmodifiableList(this.spans);
    }

    public boolean areDaysDisabled() {
        return this.daysDisabled;
    }

    static class Span {
        final Object span;

        public Span(Object span) {
            this.span = span;
        }
    }
}

