/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatTextView;
import com.prolificinteractive.materialcalendarview.format.WeekDayFormatter;
import org.threeten.bp.DayOfWeek;

@SuppressLint(value={"ViewConstructor"})
class WeekDayView
extends AppCompatTextView {
    private WeekDayFormatter formatter = WeekDayFormatter.DEFAULT;
    private DayOfWeek dayOfWeek;

    public WeekDayView(Context context, DayOfWeek dayOfWeek) {
        super(context);
        this.setGravity(17);
        if (Build.VERSION.SDK_INT >= 17) {
            this.setTextAlignment(4);
        }
        this.setDayOfWeek(dayOfWeek);
    }

    public void setWeekDayFormatter(@Nullable WeekDayFormatter formatter) {
        this.formatter = formatter == null ? WeekDayFormatter.DEFAULT : formatter;
        this.setDayOfWeek(this.dayOfWeek);
    }

    public void setDayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        this.setText(this.formatter.format(dayOfWeek));
    }
}

