/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.threeten.bp.LocalDate;
import org.threeten.bp.chrono.ChronoLocalDate;

public final class CalendarDay
implements Parcelable {
    @NonNull
    private final LocalDate date;
    public static final Parcelable.Creator<CalendarDay> CREATOR = new Parcelable.Creator<CalendarDay>(){

        public CalendarDay createFromParcel(Parcel in) {
            return new CalendarDay(in);
        }

        public CalendarDay[] newArray(int size) {
            return new CalendarDay[size];
        }
    };

    private CalendarDay(int year, int month, int day) {
        this.date = LocalDate.of((int)year, (int)month, (int)day);
    }

    private CalendarDay(@NonNull LocalDate date) {
        this.date = date;
    }

    @NonNull
    public static CalendarDay today() {
        return CalendarDay.from(LocalDate.now());
    }

    @NonNull
    public static CalendarDay from(int year, int month, int day) {
        return new CalendarDay(year, month, day);
    }

    public static CalendarDay from(@Nullable LocalDate date) {
        if (date == null) {
            return null;
        }
        return new CalendarDay(date);
    }

    public int getYear() {
        return this.date.getYear();
    }

    public int getMonth() {
        return this.date.getMonthValue();
    }

    public int getDay() {
        return this.date.getDayOfMonth();
    }

    @NonNull
    public LocalDate getDate() {
        return this.date;
    }

    public boolean isInRange(@Nullable CalendarDay minDate, @Nullable CalendarDay maxDate) {
        return !(minDate != null && minDate.isAfter(this) || maxDate != null && maxDate.isBefore(this));
    }

    public boolean isBefore(@NonNull CalendarDay other) {
        return this.date.isBefore((ChronoLocalDate)other.getDate());
    }

    public boolean isAfter(@NonNull CalendarDay other) {
        return this.date.isAfter((ChronoLocalDate)other.getDate());
    }

    public boolean equals(Object o) {
        return o instanceof CalendarDay && this.date.equals((Object)((CalendarDay)o).getDate());
    }

    public int hashCode() {
        return CalendarDay.hashCode(this.date.getYear(), this.date.getMonthValue(), this.date.getDayOfMonth());
    }

    private static int hashCode(int year, int month, int day) {
        return year * 10000 + month * 100 + day;
    }

    public String toString() {
        return "CalendarDay{" + this.date.getYear() + "-" + this.date.getMonthValue() + "-" + this.date.getDayOfMonth() + "}";
    }

    public CalendarDay(Parcel in) {
        this(in.readInt(), in.readInt(), in.readInt());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.date.getYear());
        dest.writeInt(this.date.getMonthValue());
        dest.writeInt(this.date.getDayOfMonth());
    }
}

