/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatCheckedTextView;
import android.text.SpannableString;
import android.text.Spanned;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.DayViewFacade;
import com.prolificinteractive.materialcalendarview.MaterialCalendarView;
import com.prolificinteractive.materialcalendarview.format.DayFormatter;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
class DayView
extends AppCompatCheckedTextView {
    private CalendarDay date;
    private int selectionColor = -7829368;
    private final int fadeTime;
    private Drawable customBackground = null;
    private Drawable selectionDrawable;
    private Drawable mCircleDrawable;
    private DayFormatter formatter;
    private DayFormatter contentDescriptionFormatter = this.formatter = DayFormatter.DEFAULT;
    private boolean isInRange = true;
    private boolean isInMonth = true;
    private boolean isDecoratedDisabled = false;
    private int showOtherDates = 4;
    private final Rect tempRect = new Rect();
    private final Rect circleDrawableRect = new Rect();

    public DayView(Context context, CalendarDay day) {
        super(context);
        this.fadeTime = this.getResources().getInteger(0x10E0000);
        this.setSelectionColor(this.selectionColor);
        this.setGravity(17);
        if (Build.VERSION.SDK_INT >= 17) {
            this.setTextAlignment(4);
        }
        this.setDay(day);
    }

    public void setDay(CalendarDay date) {
        this.date = date;
        this.setText(this.getLabel());
    }

    public void setDayFormatter(DayFormatter formatter) {
        this.contentDescriptionFormatter = this.contentDescriptionFormatter == this.formatter ? formatter : this.contentDescriptionFormatter;
        this.formatter = formatter == null ? DayFormatter.DEFAULT : formatter;
        CharSequence currentLabel = this.getText();
        Object[] spans = null;
        if (currentLabel instanceof Spanned) {
            spans = ((Spanned)currentLabel).getSpans(0, currentLabel.length(), Object.class);
        }
        SpannableString newLabel = new SpannableString((CharSequence)this.getLabel());
        if (spans != null) {
            for (Object span : spans) {
                newLabel.setSpan(span, 0, newLabel.length(), 33);
            }
        }
        this.setText((CharSequence)newLabel);
    }

    public void setDayFormatterContentDescription(DayFormatter formatter) {
        this.contentDescriptionFormatter = formatter == null ? this.formatter : formatter;
        this.setContentDescription(this.getContentDescriptionLabel());
    }

    @NonNull
    public String getLabel() {
        return this.formatter.format(this.date);
    }

    @NonNull
    public String getContentDescriptionLabel() {
        return this.contentDescriptionFormatter == null ? this.formatter.format(this.date) : this.contentDescriptionFormatter.format(this.date);
    }

    public void setSelectionColor(int color) {
        this.selectionColor = color;
        this.regenerateBackground();
    }

    public void setSelectionDrawable(Drawable drawable2) {
        this.selectionDrawable = drawable2 == null ? null : drawable2.getConstantState().newDrawable(this.getResources());
        this.regenerateBackground();
    }

    public void setCustomBackground(Drawable drawable2) {
        this.customBackground = drawable2 == null ? null : drawable2.getConstantState().newDrawable(this.getResources());
        this.invalidate();
    }

    public CalendarDay getDate() {
        return this.date;
    }

    private void setEnabled() {
        boolean enabled = this.isInMonth && this.isInRange && !this.isDecoratedDisabled;
        super.setEnabled(this.isInRange && !this.isDecoratedDisabled);
        boolean showOtherMonths = MaterialCalendarView.showOtherMonths(this.showOtherDates);
        boolean showOutOfRange = MaterialCalendarView.showOutOfRange(this.showOtherDates) || showOtherMonths;
        boolean showDecoratedDisabled = MaterialCalendarView.showDecoratedDisabled(this.showOtherDates);
        boolean shouldBeVisible = enabled;
        if (!this.isInMonth && showOtherMonths) {
            shouldBeVisible = true;
        }
        if (!this.isInRange && showOutOfRange) {
            shouldBeVisible |= this.isInMonth;
        }
        if (this.isDecoratedDisabled && showDecoratedDisabled) {
            shouldBeVisible |= this.isInMonth && this.isInRange;
        }
        if (!this.isInMonth && shouldBeVisible) {
            this.setTextColor(this.getTextColors().getColorForState(new int[]{-16842910}, -7829368));
        }
        this.setVisibility(shouldBeVisible ? 0 : 4);
    }

    protected void setupSelection(int showOtherDates, boolean inRange, boolean inMonth) {
        this.showOtherDates = showOtherDates;
        this.isInMonth = inMonth;
        this.isInRange = inRange;
        this.setEnabled();
    }

    protected void onDraw(@NonNull Canvas canvas) {
        if (this.customBackground != null) {
            this.customBackground.setBounds(this.tempRect);
            this.customBackground.setState(this.getDrawableState());
            this.customBackground.draw(canvas);
        }
        this.mCircleDrawable.setBounds(this.circleDrawableRect);
        super.onDraw(canvas);
    }

    private void regenerateBackground() {
        if (this.selectionDrawable != null) {
            this.setBackgroundDrawable(this.selectionDrawable);
        } else {
            this.mCircleDrawable = DayView.generateBackground(this.selectionColor, this.fadeTime, this.circleDrawableRect);
            this.setBackgroundDrawable(this.mCircleDrawable);
        }
    }

    private static Drawable generateBackground(int color, int fadeTime, Rect bounds) {
        StateListDrawable drawable2 = new StateListDrawable();
        drawable2.setExitFadeDuration(fadeTime);
        drawable2.addState(new int[]{0x10100A0}, DayView.generateCircleDrawable(color));
        if (Build.VERSION.SDK_INT >= 21) {
            drawable2.addState(new int[]{16842919}, DayView.generateRippleDrawable(color, bounds));
        } else {
            drawable2.addState(new int[]{16842919}, DayView.generateCircleDrawable(color));
        }
        drawable2.addState(new int[0], DayView.generateCircleDrawable(0));
        return drawable2;
    }

    private static Drawable generateCircleDrawable(int color) {
        ShapeDrawable drawable2 = new ShapeDrawable((Shape)new OvalShape());
        drawable2.getPaint().setColor(color);
        return drawable2;
    }

    @TargetApi(value=21)
    private static Drawable generateRippleDrawable(int color, Rect bounds) {
        ColorStateList list = ColorStateList.valueOf((int)color);
        Drawable mask = DayView.generateCircleDrawable(-1);
        RippleDrawable rippleDrawable = new RippleDrawable(list, null, mask);
        if (Build.VERSION.SDK_INT == 21) {
            rippleDrawable.setBounds(bounds);
        }
        if (Build.VERSION.SDK_INT == 22) {
            int center = (bounds.left + bounds.right) / 2;
            rippleDrawable.setHotspotBounds(center, bounds.top, center, bounds.bottom);
        }
        return rippleDrawable;
    }

    void applyFacade(DayViewFacade facade) {
        this.isDecoratedDisabled = facade.areDaysDisabled();
        this.setEnabled();
        this.setCustomBackground(facade.getBackgroundDrawable());
        this.setSelectionDrawable(facade.getSelectionDrawable());
        List<DayViewFacade.Span> spans = facade.getSpans();
        if (!spans.isEmpty()) {
            String label = this.getLabel();
            SpannableString formattedLabel = new SpannableString((CharSequence)this.getLabel());
            for (DayViewFacade.Span span : spans) {
                formattedLabel.setSpan(span.span, 0, label.length(), 33);
            }
            this.setText((CharSequence)formattedLabel);
        } else {
            this.setText(this.getLabel());
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.calculateBounds(right - left, bottom - top);
        this.regenerateBackground();
    }

    private void calculateBounds(int width, int height) {
        int circleOffset;
        int radius = Math.min(height, width);
        int offset = Math.abs(height - width) / 2;
        int n = circleOffset = Build.VERSION.SDK_INT == 21 ? offset / 2 : offset;
        if (width >= height) {
            this.tempRect.set(offset, 0, radius + offset, height);
            this.circleDrawableRect.set(circleOffset, 0, radius + circleOffset, height);
        } else {
            this.tempRect.set(0, offset, width, radius + offset);
            this.circleDrawableRect.set(0, circleOffset, width, radius + circleOffset);
        }
    }
}

