/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.support.annotation.NonNull;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.CalendarPagerAdapter;
import com.prolificinteractive.materialcalendarview.DateRangeIndex;
import com.prolificinteractive.materialcalendarview.Experimental;
import com.prolificinteractive.materialcalendarview.MaterialCalendarView;
import com.prolificinteractive.materialcalendarview.WeekView;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;

@Experimental
public class WeekPagerAdapter
extends CalendarPagerAdapter<WeekView> {
    public WeekPagerAdapter(MaterialCalendarView mcv) {
        super(mcv);
    }

    @Override
    protected WeekView createView(int position) {
        return new WeekView(this.mcv, this.getItem(position), this.mcv.getFirstDayOfWeek(), this.showWeekDays);
    }

    @Override
    protected int indexOf(WeekView view) {
        CalendarDay week = view.getFirstViewDay();
        return this.getRangeIndex().indexOf(week);
    }

    @Override
    protected boolean isInstanceOfView(Object object) {
        return object instanceof WeekView;
    }

    @Override
    protected DateRangeIndex createRangeIndex(CalendarDay min, CalendarDay max) {
        return new Weekly(min, max, this.mcv.getFirstDayOfWeek());
    }

    public static class Weekly
    implements DateRangeIndex {
        private static final int DAYS_IN_WEEK = 7;
        private final CalendarDay min;
        private final int count;

        public Weekly(@NonNull CalendarDay min, @NonNull CalendarDay max, int firstDayOfWeek) {
            this.min = this.getFirstDayOfWeek(min, firstDayOfWeek);
            this.count = this.weekNumberDifference(this.min, max) + 1;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int indexOf(CalendarDay day) {
            return this.weekNumberDifference(this.min, day);
        }

        @Override
        public CalendarDay getItem(int position) {
            long minMillis = this.min.getDate().getTime();
            long millisOffset = TimeUnit.MILLISECONDS.convert(position * 7, TimeUnit.DAYS);
            long positionMillis = minMillis + millisOffset;
            return CalendarDay.from(positionMillis);
        }

        private int weekNumberDifference(@NonNull CalendarDay min, @NonNull CalendarDay max) {
            long millisDiff = max.getDate().getTime() - min.getDate().getTime();
            int dstOffsetMax = max.getCalendar().get(16);
            int dstOffsetMin = min.getCalendar().get(16);
            long dayDiff = TimeUnit.DAYS.convert(millisDiff + (long)dstOffsetMax - (long)dstOffsetMin, TimeUnit.MILLISECONDS);
            return (int)(dayDiff / 7L);
        }

        private CalendarDay getFirstDayOfWeek(@NonNull CalendarDay min, int wantedFirstDayOfWeek) {
            Calendar calendar = Calendar.getInstance();
            min.copyTo(calendar);
            while (calendar.get(7) != wantedFirstDayOfWeek) {
                calendar.add(7, -1);
            }
            return CalendarDay.from(calendar);
        }
    }
}

