/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview.format;

import android.text.SpannableStringBuilder;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.format.TitleFormatter;

public class MonthArrayTitleFormatter
implements TitleFormatter {
    private final CharSequence[] monthLabels;

    public MonthArrayTitleFormatter(CharSequence[] monthLabels) {
        if (monthLabels == null) {
            throw new IllegalArgumentException("Label array cannot be null");
        }
        if (monthLabels.length < 12) {
            throw new IllegalArgumentException("Label array is too short");
        }
        this.monthLabels = monthLabels;
    }

    @Override
    public CharSequence format(CalendarDay day) {
        return new SpannableStringBuilder().append(this.monthLabels[day.getMonth()]).append((CharSequence)" ").append((CharSequence)String.valueOf(day.getYear()));
    }
}

