/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.DateRangeIndex;
import com.prolificinteractive.materialcalendarview.DayViewDecorator;
import com.prolificinteractive.materialcalendarview.DayViewFacade;
import com.prolificinteractive.materialcalendarview.DecoratorResult;
import com.prolificinteractive.materialcalendarview.MaterialCalendarView;
import com.prolificinteractive.materialcalendarview.MonthView;
import com.prolificinteractive.materialcalendarview.format.DayFormatter;
import com.prolificinteractive.materialcalendarview.format.TitleFormatter;
import com.prolificinteractive.materialcalendarview.format.WeekDayFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class MonthPagerAdapter
extends PagerAdapter {
    private final ArrayDeque<MonthView> currentViews;
    private final MaterialCalendarView mcv;
    private final CalendarDay today;
    private TitleFormatter titleFormatter = null;
    private Integer color = null;
    private Integer dateTextAppearance = null;
    private Integer weekDayTextAppearance = null;
    @MaterialCalendarView.ShowOtherDates
    private int showOtherDates = 4;
    private CalendarDay minDate = null;
    private CalendarDay maxDate = null;
    private DateRangeIndex rangeIndex;
    private List<CalendarDay> selectedDates = new ArrayList<CalendarDay>();
    private WeekDayFormatter weekDayFormatter = WeekDayFormatter.DEFAULT;
    private DayFormatter dayFormatter = DayFormatter.DEFAULT;
    private List<DayViewDecorator> decorators = new ArrayList<DayViewDecorator>();
    private List<DecoratorResult> decoratorResults = null;
    private int firstDayOfTheWeek = 1;
    private boolean selectionEnabled = true;

    MonthPagerAdapter(MaterialCalendarView mcv) {
        this.mcv = mcv;
        this.today = CalendarDay.today();
        this.currentViews = new ArrayDeque();
        this.currentViews.iterator();
        this.setRangeDates(null, null);
    }

    public void setDecorators(List<DayViewDecorator> decorators) {
        this.decorators = decorators;
        this.invalidateDecorators();
    }

    public void invalidateDecorators() {
        this.decoratorResults = new ArrayList<DecoratorResult>();
        for (DayViewDecorator decorator : this.decorators) {
            DayViewFacade facade = new DayViewFacade();
            decorator.decorate(facade);
            if (!facade.isDecorated()) continue;
            this.decoratorResults.add(new DecoratorResult(decorator, facade));
        }
        for (MonthView monthView : this.currentViews) {
            monthView.setDayViewDecorators(this.decoratorResults);
        }
    }

    public int getCount() {
        return this.rangeIndex.getCount();
    }

    public CharSequence getPageTitle(int position) {
        return this.titleFormatter == null ? "" : this.titleFormatter.format(this.getItem(position));
    }

    public int getIndexForDay(CalendarDay day) {
        if (day == null) {
            return this.getCount() / 2;
        }
        if (this.minDate != null && day.isBefore(this.minDate)) {
            return 0;
        }
        if (this.maxDate != null && day.isAfter(this.maxDate)) {
            return this.getCount() - 1;
        }
        return this.rangeIndex.indexOf(day);
    }

    public int getItemPosition(Object object) {
        if (!(object instanceof MonthView)) {
            return -2;
        }
        MonthView monthView = (MonthView)((Object)object);
        CalendarDay month = monthView.getMonth();
        if (month == null) {
            return -2;
        }
        int index = this.rangeIndex.indexOf(month);
        if (index < 0) {
            return -2;
        }
        return index;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        CalendarDay month = this.getItem(position);
        MonthView monthView = new MonthView(this.mcv, month, this.firstDayOfTheWeek);
        monthView.setAlpha(0.0f);
        monthView.setSelectionEnabled(this.selectionEnabled);
        monthView.setWeekDayFormatter(this.weekDayFormatter);
        monthView.setDayFormatter(this.dayFormatter);
        if (this.color != null) {
            monthView.setSelectionColor(this.color);
        }
        if (this.dateTextAppearance != null) {
            monthView.setDateTextAppearance(this.dateTextAppearance);
        }
        if (this.weekDayTextAppearance != null) {
            monthView.setWeekDayTextAppearance(this.weekDayTextAppearance);
        }
        monthView.setShowOtherDates(this.showOtherDates);
        monthView.setMinimumDate(this.minDate);
        monthView.setMaximumDate(this.maxDate);
        monthView.setSelectedDates(this.selectedDates);
        container.addView((View)monthView);
        this.currentViews.add(monthView);
        monthView.setDayViewDecorators(this.decoratorResults);
        return monthView;
    }

    public void setFirstDayOfWeek(int day) {
        this.firstDayOfTheWeek = day;
        for (MonthView monthView : this.currentViews) {
            monthView.setFirstDayOfWeek(this.firstDayOfTheWeek);
        }
    }

    public void setSelectionEnabled(boolean enabled) {
        this.selectionEnabled = enabled;
        for (MonthView monthView : this.currentViews) {
            monthView.setSelectionEnabled(this.selectionEnabled);
        }
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        MonthView monthView = (MonthView)((Object)object);
        this.currentViews.remove((Object)monthView);
        container.removeView((View)monthView);
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void setTitleFormatter(@NonNull TitleFormatter titleFormatter) {
        this.titleFormatter = titleFormatter;
    }

    public void setSelectionColor(int color) {
        this.color = color;
        for (MonthView monthView : this.currentViews) {
            monthView.setSelectionColor(color);
        }
    }

    public void setDateTextAppearance(int taId) {
        if (taId == 0) {
            return;
        }
        this.dateTextAppearance = taId;
        for (MonthView monthView : this.currentViews) {
            monthView.setDateTextAppearance(taId);
        }
    }

    public void setShowOtherDates(@MaterialCalendarView.ShowOtherDates int showFlags) {
        this.showOtherDates = showFlags;
        for (MonthView monthView : this.currentViews) {
            monthView.setShowOtherDates(showFlags);
        }
    }

    public void setWeekDayFormatter(WeekDayFormatter formatter) {
        this.weekDayFormatter = formatter;
        for (MonthView monthView : this.currentViews) {
            monthView.setWeekDayFormatter(formatter);
        }
    }

    public void setDayFormatter(DayFormatter formatter) {
        this.dayFormatter = formatter;
        for (MonthView monthView : this.currentViews) {
            monthView.setDayFormatter(formatter);
        }
    }

    @MaterialCalendarView.ShowOtherDates
    public int getShowOtherDates() {
        return this.showOtherDates;
    }

    public void setWeekDayTextAppearance(int taId) {
        if (taId == 0) {
            return;
        }
        this.weekDayTextAppearance = taId;
        for (MonthView monthView : this.currentViews) {
            monthView.setWeekDayTextAppearance(taId);
        }
    }

    public void setRangeDates(CalendarDay min, CalendarDay max) {
        this.minDate = min;
        this.maxDate = max;
        for (MonthView monthView : this.currentViews) {
            monthView.setMinimumDate(min);
            monthView.setMaximumDate(max);
        }
        if (min == null) {
            min = CalendarDay.from(this.today.getYear() - 200, this.today.getMonth(), this.today.getDay());
        }
        if (max == null) {
            max = CalendarDay.from(this.today.getYear() + 200, this.today.getMonth(), this.today.getDay());
        }
        this.rangeIndex = new DateRangeIndex(min, max);
        this.notifyDataSetChanged();
        this.invalidateSelectedDates();
    }

    public void clearSelections() {
        this.selectedDates.clear();
        this.invalidateSelectedDates();
    }

    public void setDateSelected(CalendarDay day, boolean selected) {
        if (selected) {
            if (!this.selectedDates.contains(day)) {
                this.selectedDates.add(day);
                this.invalidateSelectedDates();
            }
        } else if (this.selectedDates.contains(day)) {
            this.selectedDates.remove(day);
            this.invalidateSelectedDates();
        }
    }

    private void invalidateSelectedDates() {
        this.validateSelectedDates();
        for (MonthView monthView : this.currentViews) {
            monthView.setSelectedDates(this.selectedDates);
        }
    }

    private void validateSelectedDates() {
        for (int i = 0; i < this.selectedDates.size(); ++i) {
            CalendarDay date = this.selectedDates.get(i);
            if ((this.minDate == null || !this.minDate.isAfter(date)) && (this.maxDate == null || !this.maxDate.isBefore(date))) continue;
            this.selectedDates.remove(i);
            this.mcv.onDateUnselected(date);
            --i;
        }
    }

    public CalendarDay getItem(int position) {
        return this.rangeIndex.getItem(position);
    }

    @NonNull
    public List<CalendarDay> getSelectedDates() {
        return Collections.unmodifiableList(this.selectedDates);
    }

    protected int getDateTextAppearance() {
        return this.dateTextAppearance == null ? 0 : this.dateTextAppearance;
    }

    protected int getWeekDayTextAppearance() {
        return this.weekDayTextAppearance == null ? 0 : this.weekDayTextAppearance;
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfTheWeek;
    }
}

