/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.support.annotation.NonNull;
import android.support.v4.util.SparseArrayCompat;
import com.prolificinteractive.materialcalendarview.CalendarDay;

class DateRangeIndex {
    private final CalendarDay min;
    private final int count;
    private SparseArrayCompat<CalendarDay> dayCache = new SparseArrayCompat();

    public DateRangeIndex(@NonNull CalendarDay min, @NonNull CalendarDay max) {
        this.min = CalendarDay.from(min.getYear(), min.getMonth(), 1);
        max = CalendarDay.from(max.getYear(), max.getMonth(), 1);
        this.count = this.indexOf(max) + 1;
    }

    public int getCount() {
        return this.count;
    }

    public int indexOf(CalendarDay day) {
        int yDiff = day.getYear() - this.min.getYear();
        int mDiff = day.getMonth() - this.min.getMonth();
        return yDiff * 12 + mDiff;
    }

    public CalendarDay getItem(int position) {
        CalendarDay re = (CalendarDay)this.dayCache.get(position);
        if (re != null) {
            return re;
        }
        int numY = position / 12;
        int numM = position % 12;
        int year = this.min.getYear() + numY;
        int month = this.min.getMonth() + numM;
        if (month >= 12) {
            ++year;
            month -= 12;
        }
        re = CalendarDay.from(year, month, 1);
        this.dayCache.put(position, (Object)re);
        return re;
    }
}

