/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.CalendarUtils;
import com.prolificinteractive.materialcalendarview.DayView;
import com.prolificinteractive.materialcalendarview.DayViewFacade;
import com.prolificinteractive.materialcalendarview.DecoratorResult;
import com.prolificinteractive.materialcalendarview.MaterialCalendarView;
import com.prolificinteractive.materialcalendarview.WeekDayView;
import com.prolificinteractive.materialcalendarview.format.DayFormatter;
import com.prolificinteractive.materialcalendarview.format.WeekDayFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
class MonthView
extends ViewGroup
implements View.OnClickListener {
    protected static final int DEFAULT_DAYS_IN_WEEK = 7;
    protected static final int DEFAULT_MAX_WEEKS = 6;
    protected static final int DEFAULT_MONTH_TILE_HEIGHT = 7;
    private MaterialCalendarView mcv;
    private final ArrayList<WeekDayView> weekDayViews = new ArrayList();
    private final ArrayList<DayView> monthDayViews = new ArrayList();
    private final CalendarDay month;
    private int firstDayOfWeek;
    private final Calendar tempWorkingCalendar = CalendarUtils.getInstance();
    private CalendarDay minDate = null;
    private CalendarDay maxDate = null;
    @MaterialCalendarView.ShowOtherDates
    private int showOtherDates = 4;
    private final ArrayList<DecoratorResult> decoratorResults = new ArrayList();

    public MonthView(@NonNull MaterialCalendarView view, CalendarDay month, int firstDayOfWeek) {
        super(view.getContext());
        this.mcv = view;
        this.month = month;
        this.firstDayOfWeek = firstDayOfWeek;
        this.setClipChildren(false);
        this.setClipToPadding(false);
        Calendar calendar = this.resetAndGetWorkingCalendar();
        for (int i = 0; i < 7; ++i) {
            WeekDayView weekDayView = new WeekDayView(this.getContext(), CalendarUtils.getDayOfWeek(calendar));
            this.weekDayViews.add(weekDayView);
            this.addView((View)weekDayView);
            calendar.add(5, 1);
        }
        calendar = this.resetAndGetWorkingCalendar();
        for (int r = 0; r < 6; ++r) {
            for (int i = 0; i < 7; ++i) {
                CalendarDay day = CalendarDay.from(calendar);
                DayView dayView = new DayView(this.getContext(), day);
                dayView.setOnClickListener(this);
                this.monthDayViews.add(dayView);
                this.addView((View)dayView, (ViewGroup.LayoutParams)new LayoutParams());
                calendar.add(5, 1);
            }
        }
    }

    void setDayViewDecorators(List<DecoratorResult> results) {
        this.decoratorResults.clear();
        if (results != null) {
            this.decoratorResults.addAll(results);
        }
        this.invalidateDecorators();
    }

    public void setWeekDayTextAppearance(int taId) {
        for (WeekDayView weekDayView : this.weekDayViews) {
            weekDayView.setTextAppearance(this.getContext(), taId);
        }
    }

    public void setDateTextAppearance(int taId) {
        for (DayView dayView : this.monthDayViews) {
            dayView.setTextAppearance(this.getContext(), taId);
        }
    }

    public void setShowOtherDates(@MaterialCalendarView.ShowOtherDates int showFlags) {
        this.showOtherDates = showFlags;
        this.updateUi();
    }

    public void setSelectionEnabled(boolean selectionEnabled) {
        for (DayView dayView : this.monthDayViews) {
            dayView.setOnClickListener(selectionEnabled ? this : null);
            dayView.setClickable(selectionEnabled);
        }
    }

    public CalendarDay getMonth() {
        return this.month;
    }

    public void setSelectionColor(int color) {
        for (DayView dayView : this.monthDayViews) {
            dayView.setSelectionColor(color);
        }
    }

    private Calendar resetAndGetWorkingCalendar() {
        boolean removeRow;
        this.month.copyTo(this.tempWorkingCalendar);
        this.tempWorkingCalendar.setFirstDayOfWeek(this.firstDayOfWeek);
        int dow = CalendarUtils.getDayOfWeek(this.tempWorkingCalendar);
        int delta = this.firstDayOfWeek - dow;
        boolean bl = MaterialCalendarView.showOtherMonths(this.showOtherDates) ? delta >= 0 : (removeRow = delta > 0);
        if (removeRow) {
            delta -= 7;
        }
        this.tempWorkingCalendar.add(5, delta);
        return this.tempWorkingCalendar;
    }

    public void setFirstDayOfWeek(int dayOfWeek) {
        this.firstDayOfWeek = dayOfWeek;
        Calendar calendar = this.resetAndGetWorkingCalendar();
        calendar.set(7, dayOfWeek);
        for (WeekDayView weekDayView : this.weekDayViews) {
            weekDayView.setDayOfWeek(calendar);
            calendar.add(5, 1);
        }
        calendar = this.resetAndGetWorkingCalendar();
        for (DayView dayView : this.monthDayViews) {
            CalendarDay day = CalendarDay.from(calendar);
            dayView.setDay(day);
            calendar.add(5, 1);
        }
        this.updateUi();
    }

    public void setWeekDayFormatter(WeekDayFormatter formatter) {
        for (WeekDayView dayView : this.weekDayViews) {
            dayView.setWeekDayFormatter(formatter);
        }
    }

    public void setDayFormatter(DayFormatter formatter) {
        for (DayView dayView : this.monthDayViews) {
            dayView.setDayFormatter(formatter);
        }
    }

    public void setMinimumDate(CalendarDay minDate) {
        this.minDate = minDate;
        this.updateUi();
    }

    public void setMaximumDate(CalendarDay maxDate) {
        this.maxDate = maxDate;
        this.updateUi();
    }

    public void setSelectedDates(Collection<CalendarDay> dates) {
        for (DayView dayView : this.monthDayViews) {
            CalendarDay day = dayView.getDate();
            dayView.setChecked(dates != null && dates.contains(day));
        }
        this.postInvalidate();
    }

    private void updateUi() {
        int ourMonth = this.month.getMonth();
        for (DayView dayView : this.monthDayViews) {
            CalendarDay day = dayView.getDate();
            dayView.setupSelection(this.showOtherDates, day.isInRange(this.minDate, this.maxDate), day.getMonth() == ourMonth);
        }
        this.postInvalidate();
    }

    private void invalidateDecorators() {
        DayViewFacade facadeAccumulator = new DayViewFacade();
        for (DayView dayView : this.monthDayViews) {
            facadeAccumulator.reset();
            for (DecoratorResult result : this.decoratorResults) {
                if (!result.decorator.shouldDecorate(dayView.getDate())) continue;
                result.result.applyTo(facadeAccumulator);
            }
            dayView.applyFacade(facadeAccumulator);
        }
    }

    public void onClick(View v) {
        if (v instanceof DayView) {
            DayView dayView = (DayView)v;
            this.mcv.onDateClicked(dayView.getDate(), !dayView.isChecked());
        }
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int specWidthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int specWidthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int specHeightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int specHeightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (specHeightMode == 0 || specWidthMode == 0) {
            throw new IllegalStateException("MonthView should never be left to decide it's size");
        }
        int measureTileSize = specWidthSize / 7;
        this.setMeasuredDimension(specWidthSize, specHeightSize);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)measureTileSize, (int)0x40000000);
            int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)measureTileSize, (int)0x40000000);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        boolean parentLeft = false;
        boolean parentTop = false;
        int childTop = 0;
        int childLeft = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
            childLeft += width;
            if (i % 7 != 6) continue;
            childLeft = 0;
            childTop += height;
        }
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams();
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams();
    }

    public void onInitializeAccessibilityEvent(@NonNull AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)MonthView.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)MonthView.class.getName());
    }

    private static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams() {
            super(-2, -2);
        }
    }
}

