/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.CalendarUtils;
import com.prolificinteractive.materialcalendarview.DayViewDecorator;
import com.prolificinteractive.materialcalendarview.DayViewFacade;
import com.prolificinteractive.materialcalendarview.DecoratorResult;
import com.prolificinteractive.materialcalendarview.MonthView;
import com.prolificinteractive.materialcalendarview.format.DayFormatter;
import com.prolificinteractive.materialcalendarview.format.TitleFormatter;
import com.prolificinteractive.materialcalendarview.format.WeekDayFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;

class MonthPagerAdapter
extends PagerAdapter {
    private final LinkedList<MonthView> currentViews;
    private final ArrayList<CalendarDay> months;
    private MonthView.Callbacks callbacks = null;
    private TitleFormatter titleFormatter = null;
    private Integer color = null;
    private Integer dateTextAppearance = null;
    private Integer weekDayTextAppearance = null;
    private Boolean showOtherDates = null;
    private CalendarDay minDate = null;
    private CalendarDay maxDate = null;
    private CalendarDay selectedDate = null;
    private WeekDayFormatter weekDayFormatter = WeekDayFormatter.DEFAULT;
    private DayFormatter dayFormatter = DayFormatter.DEFAULT;
    private List<DayViewDecorator> decorators = new ArrayList<DayViewDecorator>();
    private List<DecoratorResult> decoratorResults = null;
    private int firstDayOfTheWeek = 1;

    MonthPagerAdapter() {
        this.currentViews = new LinkedList();
        this.months = new ArrayList();
        this.setRangeDates(null, null);
    }

    public void setDecorators(List<DayViewDecorator> decorators) {
        this.decorators = decorators;
        this.invalidateDecorators();
    }

    public void invalidateDecorators() {
        this.decoratorResults = new ArrayList<DecoratorResult>();
        for (DayViewDecorator decorator : this.decorators) {
            DayViewFacade facade = new DayViewFacade();
            decorator.decorate(facade);
            if (!facade.isDecorated()) continue;
            this.decoratorResults.add(new DecoratorResult(decorator, facade));
        }
        for (MonthView monthView : this.currentViews) {
            monthView.setDayViewDecorators(this.decoratorResults);
        }
    }

    public int getCount() {
        return this.months.size();
    }

    public CharSequence getPageTitle(int position) {
        return this.titleFormatter == null ? "" : this.titleFormatter.format(this.getItem(position));
    }

    public int getIndexForDay(CalendarDay day) {
        if (day == null) {
            return this.getCount() / 2;
        }
        if (this.minDate != null && day.isBefore(this.minDate)) {
            return 0;
        }
        if (this.maxDate != null && day.isAfter(this.maxDate)) {
            return this.getCount() - 1;
        }
        for (int i = 0; i < this.months.size(); ++i) {
            CalendarDay month = this.months.get(i);
            if (day.getYear() != month.getYear() || day.getMonth() != month.getMonth()) continue;
            return i;
        }
        return this.getCount() / 2;
    }

    public int getItemPosition(Object object) {
        if (!(object instanceof MonthView)) {
            return -2;
        }
        MonthView monthView = (MonthView)((Object)object);
        CalendarDay month = monthView.getMonth();
        if (month == null) {
            return -2;
        }
        int index = this.months.indexOf(month);
        if (index < 0) {
            return -2;
        }
        return index;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        CalendarDay month = this.months.get(position);
        MonthView monthView = new MonthView(container.getContext(), month, this.firstDayOfTheWeek);
        monthView.setAlpha(0.0f);
        monthView.setWeekDayFormatter(this.weekDayFormatter);
        monthView.setDayFormatter(this.dayFormatter);
        monthView.setCallbacks(this.callbacks);
        if (this.color != null) {
            monthView.setSelectionColor(this.color);
        }
        if (this.dateTextAppearance != null) {
            monthView.setDateTextAppearance(this.dateTextAppearance);
        }
        if (this.weekDayTextAppearance != null) {
            monthView.setWeekDayTextAppearance(this.weekDayTextAppearance);
        }
        if (this.showOtherDates != null) {
            monthView.setShowOtherDates(this.showOtherDates);
        }
        monthView.setMinimumDate(this.minDate);
        monthView.setMaximumDate(this.maxDate);
        monthView.setSelectedDate(this.selectedDate);
        container.addView((View)monthView);
        this.currentViews.add(monthView);
        monthView.setDayViewDecorators(this.decoratorResults);
        return monthView;
    }

    public void setFirstDayOfWeek(int day) {
        this.firstDayOfTheWeek = day;
        for (MonthView monthView : this.currentViews) {
            monthView.setFirstDayOfWeek(this.firstDayOfTheWeek);
        }
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        MonthView monthView = (MonthView)((Object)object);
        this.currentViews.remove((Object)monthView);
        container.removeView((View)monthView);
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public void setTitleFormatter(@NonNull TitleFormatter titleFormatter) {
        this.titleFormatter = titleFormatter;
    }

    public void setCallbacks(MonthView.Callbacks callbacks) {
        this.callbacks = callbacks;
        for (MonthView monthView : this.currentViews) {
            monthView.setCallbacks(callbacks);
        }
    }

    public void setSelectionColor(int color) {
        this.color = color;
        for (MonthView monthView : this.currentViews) {
            monthView.setSelectionColor(color);
        }
    }

    public void setDateTextAppearance(int taId) {
        if (taId == 0) {
            return;
        }
        this.dateTextAppearance = taId;
        for (MonthView monthView : this.currentViews) {
            monthView.setDateTextAppearance(taId);
        }
    }

    public void setShowOtherDates(boolean show) {
        this.showOtherDates = show;
        for (MonthView monthView : this.currentViews) {
            monthView.setShowOtherDates(show);
        }
    }

    public void setWeekDayFormatter(WeekDayFormatter formatter) {
        this.weekDayFormatter = formatter;
        for (MonthView monthView : this.currentViews) {
            monthView.setWeekDayFormatter(formatter);
        }
    }

    public void setDayFormatter(DayFormatter formatter) {
        this.dayFormatter = formatter;
        for (MonthView monthView : this.currentViews) {
            monthView.setDayFormatter(formatter);
        }
    }

    public boolean getShowOtherDates() {
        return this.showOtherDates;
    }

    public void setWeekDayTextAppearance(int taId) {
        if (taId == 0) {
            return;
        }
        this.weekDayTextAppearance = taId;
        for (MonthView monthView : this.currentViews) {
            monthView.setWeekDayTextAppearance(taId);
        }
    }

    public void setRangeDates(CalendarDay min, CalendarDay max) {
        Calendar worker;
        this.minDate = min;
        this.maxDate = max;
        for (MonthView monthView : this.currentViews) {
            monthView.setMinimumDate(min);
            monthView.setMaximumDate(max);
        }
        if (min == null) {
            worker = CalendarUtils.getInstance();
            worker.add(1, -200);
            min = CalendarDay.from(worker);
        }
        if (max == null) {
            worker = CalendarUtils.getInstance();
            worker.add(1, 200);
            max = CalendarDay.from(worker);
        }
        this.months.clear();
        worker = CalendarUtils.getInstance();
        min.copyToMonthOnly(worker);
        CalendarDay workingMonth = CalendarDay.from(worker);
        while (!max.isBefore(workingMonth)) {
            this.months.add(CalendarDay.from(worker));
            worker.add(2, 1);
            worker.set(5, 1);
            workingMonth = CalendarDay.from(worker);
        }
        CalendarDay prevDate = this.selectedDate;
        this.notifyDataSetChanged();
        this.setSelectedDate(prevDate);
        if (prevDate != null && !prevDate.equals(this.selectedDate)) {
            this.callbacks.onDateChanged(this.selectedDate);
        }
    }

    public void setSelectedDate(@Nullable CalendarDay date) {
        CalendarDay prevDate = this.selectedDate;
        this.selectedDate = this.getValidSelectedDate(date);
        for (MonthView monthView : this.currentViews) {
            monthView.setSelectedDate(this.selectedDate);
        }
        if (date == null && prevDate != null) {
            this.callbacks.onDateChanged(null);
        }
    }

    private CalendarDay getValidSelectedDate(CalendarDay date) {
        if (date == null) {
            return null;
        }
        if (this.minDate != null && this.minDate.isAfter(date)) {
            return this.minDate;
        }
        if (this.maxDate != null && this.maxDate.isBefore(date)) {
            return this.maxDate;
        }
        return date;
    }

    public CalendarDay getItem(int position) {
        return this.months.get(position);
    }

    public CalendarDay getSelectedDate() {
        return this.selectedDate;
    }

    protected int getDateTextAppearance() {
        return this.dateTextAppearance == null ? 0 : this.dateTextAppearance;
    }

    protected int getWeekDayTextAppearance() {
        return this.weekDayTextAppearance == null ? 0 : this.weekDayTextAppearance;
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfTheWeek;
    }
}

