/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.SpannableString;
import android.text.Spanned;
import android.widget.CheckedTextView;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.DayViewFacade;
import com.prolificinteractive.materialcalendarview.format.DayFormatter;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
class DayView
extends CheckedTextView {
    private CalendarDay date;
    private int selectionColor = -7829368;
    private final int fadeTime;
    private Drawable customBackground = null;
    private Drawable selectionDrawable;
    private DayFormatter formatter = DayFormatter.DEFAULT;
    private boolean isInRange = true;
    private boolean showOtherDates = false;
    private boolean isDecoratedDisabled = false;
    private final Rect tempRect = new Rect();

    public DayView(Context context, CalendarDay day) {
        super(context);
        this.fadeTime = this.getResources().getInteger(0x10E0000);
        this.setSelectionColor(this.selectionColor);
        this.setGravity(17);
        if (Build.VERSION.SDK_INT >= 17) {
            this.setTextAlignment(4);
        }
        this.setDay(day);
    }

    public void setDay(CalendarDay date) {
        this.date = date;
        this.setText(this.getLabel());
    }

    public void setDayFormatter(DayFormatter formatter) {
        this.formatter = formatter == null ? DayFormatter.DEFAULT : formatter;
        CharSequence currentLabel = this.getText();
        Object[] spans = null;
        if (currentLabel instanceof Spanned) {
            spans = ((Spanned)currentLabel).getSpans(0, currentLabel.length(), Object.class);
        }
        SpannableString newLabel = new SpannableString((CharSequence)this.getLabel());
        if (spans != null) {
            for (Object span : spans) {
                newLabel.setSpan(span, 0, newLabel.length(), 33);
            }
        }
        this.setText((CharSequence)newLabel);
    }

    @NonNull
    public String getLabel() {
        return this.formatter.format(this.date);
    }

    public void setSelectionColor(int color) {
        this.selectionColor = color;
        this.regenerateBackground();
    }

    public void setSelectionDrawable(Drawable drawable) {
        this.selectionDrawable = drawable == null ? null : drawable.getConstantState().newDrawable(this.getResources());
        this.regenerateBackground();
    }

    public void setCustomBackground(Drawable drawable) {
        this.customBackground = drawable == null ? null : drawable.getConstantState().newDrawable(this.getResources());
        this.invalidate();
    }

    public CalendarDay getDate() {
        return this.date;
    }

    private void setEnabled() {
        super.setEnabled(this.isInRange && !this.isDecoratedDisabled);
        this.setVisibility(this.isInRange || this.showOtherDates ? 0 : 4);
    }

    protected void setupSelection(boolean showOtherDates, boolean inRange, boolean inMonth) {
        this.showOtherDates = showOtherDates;
        this.isInRange = inMonth && inRange;
        this.setEnabled();
    }

    protected void onDraw(@NonNull Canvas canvas) {
        if (this.customBackground != null) {
            canvas.getClipBounds(this.tempRect);
            this.customBackground.setBounds(this.tempRect);
            this.customBackground.setState(this.getDrawableState());
            this.customBackground.draw(canvas);
        }
        super.onDraw(canvas);
    }

    private void regenerateBackground() {
        if (this.selectionDrawable != null) {
            this.setBackgroundDrawable(this.selectionDrawable);
        } else {
            this.setBackgroundDrawable(DayView.generateBackground(this.selectionColor, this.fadeTime));
        }
    }

    private static Drawable generateBackground(int color, int fadeTime) {
        StateListDrawable drawable = new StateListDrawable();
        drawable.setExitFadeDuration(fadeTime);
        drawable.addState(new int[]{0x10100A0}, DayView.generateCircleDrawable(color));
        if (Build.VERSION.SDK_INT >= 21) {
            drawable.addState(new int[]{16842919}, DayView.generateRippleDrawable(color));
        } else {
            drawable.addState(new int[]{16842919}, DayView.generateCircleDrawable(color));
        }
        drawable.addState(new int[0], DayView.generateCircleDrawable(0));
        return drawable;
    }

    private static Drawable generateCircleDrawable(final int color) {
        ShapeDrawable drawable = new ShapeDrawable((Shape)new OvalShape());
        drawable.setShaderFactory(new ShapeDrawable.ShaderFactory(){

            public Shader resize(int width, int height) {
                return new LinearGradient(0.0f, 0.0f, 0.0f, 0.0f, color, color, Shader.TileMode.REPEAT);
            }
        });
        return drawable;
    }

    @TargetApi(value=21)
    private static Drawable generateRippleDrawable(int color) {
        ColorStateList list = ColorStateList.valueOf((int)color);
        Drawable mask = DayView.generateCircleDrawable(-1);
        return new RippleDrawable(list, null, mask);
    }

    void applyFacade(DayViewFacade facade) {
        this.isDecoratedDisabled = facade.areDaysDisabled();
        this.setEnabled();
        this.setCustomBackground(facade.getBackgroundDrawable());
        this.setSelectionDrawable(facade.getSelectionDrawable());
        List<DayViewFacade.Span> spans = facade.getSpans();
        if (!spans.isEmpty()) {
            String label = this.getLabel();
            SpannableString formattedLabel = new SpannableString((CharSequence)this.getLabel());
            for (DayViewFacade.Span span : spans) {
                formattedLabel.setSpan(span.span, 0, label.length(), 33);
            }
            this.setText((CharSequence)formattedLabel);
        } else {
            this.setText(this.getLabel());
        }
    }
}

