/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.CalendarUtils;
import com.prolificinteractive.materialcalendarview.DayView;
import com.prolificinteractive.materialcalendarview.DayViewFacade;
import com.prolificinteractive.materialcalendarview.DecoratorResult;
import com.prolificinteractive.materialcalendarview.WeekDayView;
import com.prolificinteractive.materialcalendarview.format.DayFormatter;
import com.prolificinteractive.materialcalendarview.format.WeekDayFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
class MonthView
extends LinearLayout
implements View.OnClickListener {
    protected static final int DEFAULT_DAYS_IN_WEEK = 7;
    protected static final int DEFAULT_MAX_WEEKS = 6;
    protected static final int DEFAULT_MONTH_TILE_HEIGHT = 7;
    private Callbacks callbacks;
    private final ArrayList<WeekDayView> weekDayViews = new ArrayList();
    private final ArrayList<DayView> monthDayViews = new ArrayList();
    private final CalendarDay month;
    private int firstDayOfWeek;
    private final Calendar tempWorkingCalendar = CalendarUtils.getInstance();
    private CalendarDay selection = null;
    private CalendarDay minDate = null;
    private CalendarDay maxDate = null;
    private boolean showOtherDates = false;
    private final ArrayList<DecoratorResult> decoratorResults = new ArrayList();

    public MonthView(Context context, CalendarDay month, int firstDayOfWeek) {
        super(context);
        this.month = month;
        this.firstDayOfWeek = firstDayOfWeek;
        this.setOrientation(1);
        this.setClipChildren(false);
        this.setClipToPadding(false);
        Calendar calendar = this.resetAndGetWorkingCalendar();
        LinearLayout row = MonthView.makeRow(this);
        for (int i = 0; i < 7; ++i) {
            WeekDayView weekDayView = new WeekDayView(context, CalendarUtils.getDayOfWeek(calendar));
            this.weekDayViews.add(weekDayView);
            row.addView((View)weekDayView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
            calendar.add(5, 1);
        }
        calendar = this.resetAndGetWorkingCalendar();
        for (int r = 0; r < 6; ++r) {
            row = MonthView.makeRow(this);
            for (int i = 0; i < 7; ++i) {
                CalendarDay day = CalendarDay.from(calendar);
                DayView dayView = new DayView(context, day);
                dayView.setOnClickListener(this);
                this.monthDayViews.add(dayView);
                row.addView((View)dayView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
                calendar.add(5, 1);
            }
        }
        this.setSelectedDate(CalendarDay.today());
    }

    void setDayViewDecorators(List<DecoratorResult> results) {
        this.decoratorResults.clear();
        if (results != null) {
            this.decoratorResults.addAll(results);
        }
        this.invalidateDecorators();
    }

    private static LinearLayout makeRow(LinearLayout parent) {
        LinearLayout row = new LinearLayout(parent.getContext());
        row.setOrientation(0);
        parent.addView((View)row, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        return row;
    }

    public void setWeekDayTextAppearance(int taId) {
        for (WeekDayView weekDayView : this.weekDayViews) {
            weekDayView.setTextAppearance(this.getContext(), taId);
        }
    }

    public void setDateTextAppearance(int taId) {
        for (DayView dayView : this.monthDayViews) {
            dayView.setTextAppearance(this.getContext(), taId);
        }
    }

    public void setShowOtherDates(boolean show) {
        this.showOtherDates = show;
        this.updateUi();
    }

    public boolean getShowOtherDates() {
        return this.showOtherDates;
    }

    public CalendarDay getMonth() {
        return this.month;
    }

    public void setSelectionColor(int color) {
        for (DayView dayView : this.monthDayViews) {
            dayView.setSelectionColor(color);
        }
    }

    private Calendar resetAndGetWorkingCalendar() {
        boolean removeRow;
        this.month.copyTo(this.tempWorkingCalendar);
        this.tempWorkingCalendar.setFirstDayOfWeek(this.firstDayOfWeek);
        int dow = CalendarUtils.getDayOfWeek(this.tempWorkingCalendar);
        int delta = this.firstDayOfWeek - dow;
        boolean bl = this.showOtherDates ? delta >= 0 : (removeRow = delta > 0);
        if (removeRow) {
            delta -= 7;
        }
        this.tempWorkingCalendar.add(5, delta);
        return this.tempWorkingCalendar;
    }

    public void setFirstDayOfWeek(int dayOfWeek) {
        this.firstDayOfWeek = dayOfWeek;
        Calendar calendar = this.resetAndGetWorkingCalendar();
        calendar.set(7, dayOfWeek);
        for (WeekDayView weekDayView : this.weekDayViews) {
            weekDayView.setDayOfWeek(calendar);
            calendar.add(5, 1);
        }
        calendar = this.resetAndGetWorkingCalendar();
        for (DayView dayView : this.monthDayViews) {
            CalendarDay day = CalendarDay.from(calendar);
            dayView.setDay(day);
            calendar.add(5, 1);
        }
        this.updateUi();
    }

    public void setWeekDayFormatter(WeekDayFormatter formatter) {
        for (WeekDayView dayView : this.weekDayViews) {
            dayView.setWeekDayFormatter(formatter);
        }
    }

    public void setDayFormatter(DayFormatter formatter) {
        for (DayView dayView : this.monthDayViews) {
            dayView.setDayFormatter(formatter);
        }
    }

    public void setMinimumDate(CalendarDay minDate) {
        this.minDate = minDate;
        this.updateUi();
    }

    public void setMaximumDate(CalendarDay maxDate) {
        this.maxDate = maxDate;
        this.updateUi();
    }

    public void setSelectedDate(CalendarDay cal) {
        this.selection = cal;
        this.updateUi();
    }

    private void updateUi() {
        int ourMonth = this.month.getMonth();
        for (DayView dayView : this.monthDayViews) {
            CalendarDay day = dayView.getDate();
            dayView.setupSelection(this.showOtherDates, day.isInRange(this.minDate, this.maxDate), day.getMonth() == ourMonth);
            dayView.setChecked(day.equals(this.selection));
        }
        this.postInvalidate();
    }

    private void invalidateDecorators() {
        DayViewFacade facadeAccumulator = new DayViewFacade();
        for (DayView dayView : this.monthDayViews) {
            facadeAccumulator.reset();
            for (DecoratorResult result : this.decoratorResults) {
                if (!result.decorator.shouldDecorate(dayView.getDate())) continue;
                result.result.applyTo(facadeAccumulator);
            }
            dayView.applyFacade(facadeAccumulator);
        }
    }

    public void setCallbacks(Callbacks callbacks) {
        this.callbacks = callbacks;
    }

    public void onClick(View v) {
        if (v instanceof DayView) {
            for (DayView other : this.monthDayViews) {
                other.setChecked(false);
            }
            DayView dayView = (DayView)v;
            dayView.setChecked(true);
            CalendarDay date = dayView.getDate();
            if (date.equals(this.selection)) {
                return;
            }
            this.selection = date;
            if (this.callbacks != null) {
                this.callbacks.onDateChanged(dayView.getDate());
            }
        }
    }

    public static interface Callbacks {
        public void onDateChanged(CalendarDay var1);
    }
}

