/*
 * Decompiled with CFR 0.152.
 */
package com.prolificinteractive.materialcalendarview;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.CalendarUtils;
import com.prolificinteractive.materialcalendarview.DayView;
import com.prolificinteractive.materialcalendarview.DayViewDecorator;
import com.prolificinteractive.materialcalendarview.DayViewFacade;
import com.prolificinteractive.materialcalendarview.WeekDayView;
import com.prolificinteractive.materialcalendarview.format.WeekDayFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

class MonthView
extends LinearLayout
implements View.OnClickListener {
    protected static final int DEFAULT_DAYS_IN_WEEK = 7;
    protected static final int DEFAULT_MAX_WEEKS = 6;
    protected static final int DEFAULT_MONTH_TILE_HEIGHT = 7;
    private Callbacks callbacks;
    private final ArrayList<WeekDayView> weekDayViews = new ArrayList();
    private final ArrayList<DayView> monthDayViews = new ArrayList();
    private final Calendar calendarOfRecord = CalendarUtils.getInstance();
    private final Calendar tempWorkingCalendar = CalendarUtils.getInstance();
    private int firstDayOfWeek = 1;
    private CalendarDay selection = null;
    private CalendarDay minDate = null;
    private CalendarDay maxDate = null;
    private boolean showOtherDates = false;
    private List<DayViewDecorator> dayViewDecorators;

    public MonthView(Context context) {
        super(context);
        this.setOrientation(1);
        this.setClipChildren(false);
        this.setClipToPadding(false);
        LinearLayout row = MonthView.makeRow(this);
        for (int i = 0; i < 7; ++i) {
            WeekDayView weekDayView = new WeekDayView(context);
            this.weekDayViews.add(weekDayView);
            row.addView((View)weekDayView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
        }
        for (int r = 0; r < 6; ++r) {
            row = MonthView.makeRow(this);
            for (int i = 0; i < 7; ++i) {
                DayView dayView = new DayView(context);
                dayView.setOnClickListener(this);
                this.monthDayViews.add(dayView);
                row.addView((View)dayView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
            }
        }
        this.setFirstDayOfWeek(this.firstDayOfWeek);
        this.setSelectedDate(new CalendarDay());
    }

    public void setDayViewDecorators(List<DayViewDecorator> dayViewDecorators) {
        this.dayViewDecorators = dayViewDecorators;
        this.updateUi();
    }

    private static LinearLayout makeRow(LinearLayout parent) {
        LinearLayout row = new LinearLayout(parent.getContext());
        row.setOrientation(0);
        parent.addView((View)row, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
        return row;
    }

    public void setWeekDayTextAppearance(int taId) {
        for (WeekDayView weekDayView : this.weekDayViews) {
            weekDayView.setTextAppearance(this.getContext(), taId);
        }
    }

    public void setDateTextAppearance(int taId) {
        for (DayView dayView : this.monthDayViews) {
            dayView.setTextAppearance(this.getContext(), taId);
        }
    }

    public void setShowOtherDates(boolean show) {
        this.showOtherDates = show;
        this.updateUi();
    }

    public boolean getShowOtherDates() {
        return this.showOtherDates;
    }

    public void setSelectionColor(int color) {
        for (DayView dayView : this.monthDayViews) {
            dayView.setSelectionColor(color);
        }
    }

    private Calendar resetAndGetWorkingCalendar() {
        boolean removeRow;
        CalendarUtils.copyDateTo(this.calendarOfRecord, this.tempWorkingCalendar);
        int dow = CalendarUtils.getDayOfWeek(this.tempWorkingCalendar);
        int delta = this.firstDayOfWeek - dow;
        boolean bl = this.showOtherDates ? delta >= 0 : (removeRow = delta > 0);
        if (removeRow) {
            delta -= 7;
        }
        this.tempWorkingCalendar.add(5, delta);
        return this.tempWorkingCalendar;
    }

    public void setFirstDayOfWeek(int dayOfWeek) {
        this.firstDayOfWeek = dayOfWeek;
        Calendar calendar = this.resetAndGetWorkingCalendar();
        calendar.set(7, dayOfWeek);
        for (WeekDayView dayView : this.weekDayViews) {
            dayView.setDayOfWeek(calendar);
            calendar.add(5, 1);
        }
    }

    public void setWeekDayFormatter(WeekDayFormatter formatter) {
        for (WeekDayView dayView : this.weekDayViews) {
            dayView.setWeekDayFormatter(formatter);
        }
    }

    public void setMinimumDate(CalendarDay minDate) {
        this.minDate = minDate;
        this.updateUi();
    }

    public void setMaximumDate(CalendarDay maxDate) {
        this.maxDate = maxDate;
        this.updateUi();
    }

    public void setDate(CalendarDay month) {
        month.copyTo(this.calendarOfRecord);
        CalendarUtils.setToFirstDay(this.calendarOfRecord);
        this.updateUi();
    }

    public void setSelectedDate(CalendarDay cal) {
        this.selection = cal;
        this.updateUi();
    }

    protected void updateUi() {
        int ourMonth = CalendarUtils.getMonth(this.calendarOfRecord);
        Calendar calendar = this.resetAndGetWorkingCalendar();
        for (DayView dayView : this.monthDayViews) {
            CalendarDay day = new CalendarDay(calendar);
            dayView.setDay(day);
            dayView.setupSelection(this.showOtherDates, day.isInRange(this.minDate, this.maxDate), day.getMonth() == ourMonth);
            dayView.setChecked(day.equals(this.selection));
            this.applyDecorators(dayView, day);
            calendar.add(5, 1);
        }
        this.postInvalidate();
    }

    private void applyDecorators(DayView dayView, CalendarDay day) {
        if (this.dayViewDecorators != null) {
            DayViewFacade facade = new DayViewFacade();
            for (DayViewDecorator decorator : this.dayViewDecorators) {
                if (!decorator.shouldDecorate(day)) continue;
                facade.setDayView(dayView);
                decorator.decorate(facade);
            }
        }
    }

    public void setCallbacks(Callbacks callbacks) {
        this.callbacks = callbacks;
    }

    public void onClick(View v) {
        if (v instanceof DayView) {
            for (DayView other : this.monthDayViews) {
                other.setChecked(false);
            }
            DayView dayView = (DayView)v;
            dayView.setChecked(true);
            CalendarDay date = dayView.getDate();
            if (date.equals(this.selection)) {
                return;
            }
            this.selection = date;
            if (this.callbacks != null) {
                this.callbacks.onDateChanged(dayView.getDate());
            }
        }
    }

    public static interface Callbacks {
        public void onDateChanged(CalendarDay var1);
    }
}

