/*
 * Decompiled with CFR 0.152.
 */
package com.pro100svitlo.creditCardNfcReader.utils;

import com.pro100svitlo.creditCardNfcReader.iso7816emv.EmvTags;
import com.pro100svitlo.creditCardNfcReader.model.EmvCard;
import com.pro100svitlo.creditCardNfcReader.model.Service;
import com.pro100svitlo.creditCardNfcReader.utils.TlvUtil;
import fr.devnied.bitlib.BytesUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrackUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackUtils.class);
    private static final Pattern TRACK2_PATTERN = Pattern.compile("([0-9]{1,19})D([0-9]{4})([0-9]{3})?(.*)");

    public static boolean extractTrack2Data(EmvCard pEmvCard, byte[] pData) {
        String data;
        Matcher m;
        boolean ret = false;
        byte[] track2 = TlvUtil.getValue(pData, EmvTags.TRACK_2_EQV_DATA, EmvTags.TRACK2_DATA);
        if (track2 != null && (m = TRACK2_PATTERN.matcher(data = BytesUtils.bytesToStringNoSpace((byte[])track2))).find()) {
            pEmvCard.setCardNumber(m.group(1));
            String month = m.group(2).substring(2, 4);
            String year = m.group(2).substring(0, 2);
            pEmvCard.setExpireDate(month + "/" + year);
            pEmvCard.setService(new Service(m.group(3)));
            ret = true;
        }
        return ret;
    }

    private TrackUtils() {
    }
}

