/*
 * Decompiled with CFR 0.152.
 */
package com.pro100svitlo.creditCardNfcReader.utils;

import com.pro100svitlo.creditCardNfcReader.enums.SwEnum;
import com.pro100svitlo.creditCardNfcReader.enums.TagValueTypeEnum;
import com.pro100svitlo.creditCardNfcReader.exception.TlvException;
import com.pro100svitlo.creditCardNfcReader.iso7816emv.EmvTags;
import com.pro100svitlo.creditCardNfcReader.iso7816emv.ITag;
import com.pro100svitlo.creditCardNfcReader.iso7816emv.TLV;
import com.pro100svitlo.creditCardNfcReader.iso7816emv.TagAndLength;
import fr.devnied.bitlib.BytesUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class TlvUtil {
    private static ITag searchTagById(byte[] tagIdBytes) {
        return EmvTags.getNotNull(tagIdBytes);
    }

    private static ITag searchTagById(ByteArrayInputStream stream) {
        return TlvUtil.searchTagById(TlvUtil.readTagIdBytes(stream));
    }

    public static String getFormattedTagAndLength(byte[] data, int indentLength) {
        StringBuilder buf = new StringBuilder();
        String indent = TlvUtil.getSpaces(indentLength);
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        boolean firstLine = true;
        while (stream.available() > 0) {
            if (firstLine) {
                firstLine = false;
            } else {
                buf.append("\n");
            }
            buf.append(indent);
            ITag tag = TlvUtil.searchTagById(stream);
            int length = TlvUtil.readTagLength(stream);
            buf.append(TlvUtil.prettyPrintHex(tag.getTagBytes()));
            buf.append(" ");
            buf.append(String.format("%02x", length));
            buf.append(" -- ");
            buf.append(tag.getName());
        }
        return buf.toString();
    }

    public static byte[] readTagIdBytes(ByteArrayInputStream stream) {
        ByteArrayOutputStream tagBAOS = new ByteArrayOutputStream();
        byte tagFirstOctet = (byte)stream.read();
        tagBAOS.write(tagFirstOctet);
        int MASK = 31;
        if ((tagFirstOctet & MASK) == MASK) {
            int nextOctet;
            while ((nextOctet = stream.read()) >= 0) {
                byte tlvIdNextOctet = (byte)nextOctet;
                tagBAOS.write(tlvIdNextOctet);
                if (BytesUtils.matchBitByBitIndex((int)tlvIdNextOctet, (int)7) && (!BytesUtils.matchBitByBitIndex((int)tlvIdNextOctet, (int)7) || (tlvIdNextOctet & 0x7F) != 0)) continue;
                break;
            }
        }
        return tagBAOS.toByteArray();
    }

    public static int readTagLength(ByteArrayInputStream stream) {
        int length;
        int tmpLength = stream.read();
        if (tmpLength < 0) {
            throw new TlvException("Negative length: " + tmpLength);
        }
        if (tmpLength <= 127) {
            length = tmpLength;
        } else if (tmpLength == 128) {
            length = tmpLength;
        } else {
            int numberOfLengthOctets = tmpLength & 0x7F;
            tmpLength = 0;
            for (int i = 0; i < numberOfLengthOctets; ++i) {
                int nextLengthOctet = stream.read();
                if (nextLengthOctet < 0) {
                    throw new TlvException("EOS when reading length bytes");
                }
                tmpLength <<= 8;
                tmpLength |= nextLengthOctet;
            }
            length = tmpLength;
        }
        return length;
    }

    public static TLV getNextTLV(ByteArrayInputStream stream) {
        byte[] valueBytes;
        if (stream.available() < 2) {
            throw new TlvException("Error parsing data. Available bytes < 2 . Length=" + stream.available());
        }
        stream.mark(0);
        int peekInt = stream.read();
        byte peekByte = (byte)peekInt;
        while (peekInt != -1 && (peekByte == -1 || peekByte == 0)) {
            stream.mark(0);
            peekInt = stream.read();
            peekByte = (byte)peekInt;
        }
        stream.reset();
        if (stream.available() < 2) {
            throw new TlvException("Error parsing data. Available bytes < 2 . Length=" + stream.available());
        }
        byte[] tagIdBytes = TlvUtil.readTagIdBytes(stream);
        stream.mark(0);
        int posBefore = stream.available();
        int length = TlvUtil.readTagLength(stream);
        int posAfter = stream.available();
        stream.reset();
        byte[] lengthBytes = new byte[posBefore - posAfter];
        if (lengthBytes.length < 1 || lengthBytes.length > 4) {
            throw new TlvException("Number of length bytes must be from 1 to 4. Found " + lengthBytes.length);
        }
        stream.read(lengthBytes, 0, lengthBytes.length);
        int rawLength = BytesUtils.byteArrayToInt((byte[])lengthBytes);
        ITag tag = TlvUtil.searchTagById(tagIdBytes);
        if (rawLength == 128) {
            stream.mark(0);
            int prevOctet = 1;
            int len = 0;
            while (true) {
                ++len;
                int curOctet = stream.read();
                if (curOctet < 0) {
                    throw new TlvException("Error parsing data. TLV length byte indicated indefinite length, but EOS was reached before 0x0000 was found" + stream.available());
                }
                if (prevOctet == 0 && curOctet == 0) break;
                prevOctet = curOctet;
            }
            valueBytes = new byte[len -= 2];
            stream.reset();
            stream.read(valueBytes, 0, len);
            length = len;
        } else {
            if (stream.available() < length) {
                throw new TlvException("Length byte(s) indicated " + length + " value bytes, but only " + stream.available() + " " + (stream.available() > 1 ? "are" : "is") + " available");
            }
            valueBytes = new byte[length];
            stream.read(valueBytes, 0, length);
        }
        stream.mark(0);
        peekInt = stream.read();
        peekByte = (byte)peekInt;
        while (peekInt != -1 && (peekByte == -1 || peekByte == 0)) {
            stream.mark(0);
            peekInt = stream.read();
            peekByte = (byte)peekInt;
        }
        stream.reset();
        return new TLV(tag, length, lengthBytes, valueBytes);
    }

    private static String getTagValueAsString(ITag tag, byte[] value) {
        StringBuilder buf = new StringBuilder();
        switch (tag.getTagValueType()) {
            case TEXT: {
                buf.append("=");
                buf.append(new String(value));
                break;
            }
            case NUMERIC: {
                buf.append("NUMERIC");
                break;
            }
            case BINARY: {
                buf.append("BINARY");
                break;
            }
            case MIXED: {
                buf.append("=");
                buf.append(TlvUtil.getSafePrintChars(value));
                break;
            }
            case DOL: {
                buf.append("");
                break;
            }
        }
        return buf.toString();
    }

    public static List<TagAndLength> parseTagAndLength(byte[] data) {
        ArrayList<TagAndLength> tagAndLengthList = new ArrayList<TagAndLength>();
        if (data != null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            while (stream.available() > 0) {
                if (stream.available() < 2) {
                    throw new TlvException("Data length < 2 : " + stream.available());
                }
                ITag tag = TlvUtil.searchTagById(TlvUtil.readTagIdBytes(stream));
                int tagValueLength = TlvUtil.readTagLength(stream);
                tagAndLengthList.add(new TagAndLength(tag, tagValueLength));
            }
        }
        return tagAndLengthList;
    }

    public static String prettyPrintAPDUResponse(byte[] data) {
        return TlvUtil.prettyPrintAPDUResponse(data, 0);
    }

    public static String prettyPrintAPDUResponse(byte[] data, int startPos, int length) {
        byte[] tmp = new byte[length - startPos];
        System.arraycopy(data, startPos, tmp, 0, length);
        return TlvUtil.prettyPrintAPDUResponse(tmp, 0);
    }

    public static List<TLV> getlistTLV(byte[] pData, ITag pTag, boolean pAdd) {
        ArrayList<TLV> list = new ArrayList<TLV>();
        ByteArrayInputStream stream = new ByteArrayInputStream(pData);
        while (stream.available() > 0) {
            TLV tlv = TlvUtil.getNextTLV(stream);
            if (pAdd) {
                list.add(tlv);
                continue;
            }
            if (!tlv.getTag().isConstructed()) continue;
            list.addAll(TlvUtil.getlistTLV(tlv.getValueBytes(), pTag, tlv.getTag() == pTag));
        }
        return list;
    }

    public static List<TLV> getlistTLV(byte[] pData, ITag ... pTag) {
        ArrayList<TLV> list = new ArrayList<TLV>();
        ByteArrayInputStream stream = new ByteArrayInputStream(pData);
        while (stream.available() > 0) {
            TLV tlv = TlvUtil.getNextTLV(stream);
            if (ArrayUtils.contains((Object[])pTag, (Object)tlv.getTag())) {
                list.add(tlv);
                continue;
            }
            if (!tlv.getTag().isConstructed()) continue;
            list.addAll(TlvUtil.getlistTLV(tlv.getValueBytes(), pTag));
        }
        return list;
    }

    public static byte[] getValue(byte[] pData, ITag ... pTag) {
        byte[] ret = null;
        if (pData != null) {
            ByteArrayInputStream stream = new ByteArrayInputStream(pData);
            while (stream.available() > 0) {
                TLV tlv = TlvUtil.getNextTLV(stream);
                if (ArrayUtils.contains((Object[])pTag, (Object)tlv.getTag())) {
                    return tlv.getValueBytes();
                }
                if (!tlv.getTag().isConstructed() || (ret = TlvUtil.getValue(tlv.getValueBytes(), pTag)) == null) continue;
                break;
            }
        }
        return ret;
    }

    public static String prettyPrintAPDUResponse(byte[] data, int indentLength) {
        StringBuilder buf = new StringBuilder();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        while (stream.available() > 0) {
            buf.append("\n");
            if (stream.available() == 2) {
                stream.mark(0);
                byte[] value = new byte[2];
                try {
                    stream.read(value);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                SwEnum sw = SwEnum.getSW(value);
                if (sw != null) {
                    buf.append(TlvUtil.getSpaces(0));
                    buf.append(BytesUtils.bytesToString((byte[])value)).append(" -- ");
                    buf.append(sw.getDetail());
                    continue;
                }
                stream.reset();
            }
            buf.append(TlvUtil.getSpaces(indentLength));
            TLV tlv = TlvUtil.getNextTLV(stream);
            byte[] tagBytes = tlv.getTagBytes();
            byte[] lengthBytes = tlv.getRawEncodedLengthBytes();
            byte[] valueBytes = tlv.getValueBytes();
            ITag tag = tlv.getTag();
            buf.append(TlvUtil.prettyPrintHex(tagBytes));
            buf.append(" ");
            buf.append(TlvUtil.prettyPrintHex(lengthBytes));
            buf.append(" -- ");
            buf.append(tag.getName());
            int extraIndent = (lengthBytes.length + tagBytes.length) * 3;
            if (tag.isConstructed()) {
                buf.append(TlvUtil.prettyPrintAPDUResponse(valueBytes, indentLength + extraIndent));
                continue;
            }
            buf.append("\n");
            if (tag.getTagValueType() == TagValueTypeEnum.DOL) {
                buf.append(TlvUtil.getFormattedTagAndLength(valueBytes, indentLength + extraIndent));
                continue;
            }
            buf.append(TlvUtil.getSpaces(indentLength + extraIndent));
            buf.append(TlvUtil.prettyPrintHex(BytesUtils.bytesToStringNoSpace((byte[])valueBytes), indentLength + extraIndent));
            buf.append(" (");
            buf.append(TlvUtil.getTagValueAsString(tag, valueBytes));
            buf.append(")");
        }
        return buf.toString();
    }

    public static String getSpaces(int length) {
        return StringUtils.leftPad((String)"", (int)length);
    }

    public static String prettyPrintHex(String in, int indent) {
        return TlvUtil.prettyPrintHex(in, indent, true);
    }

    public static String prettyPrintHex(byte[] data, int indent) {
        return TlvUtil.prettyPrintHex(BytesUtils.bytesToStringNoSpace((byte[])data), indent, true);
    }

    public static String prettyPrintHex(String in) {
        return TlvUtil.prettyPrintHex(in, 0, true);
    }

    public static String prettyPrintHex(byte[] data) {
        return TlvUtil.prettyPrintHex(BytesUtils.bytesToStringNoSpace((byte[])data), 0, true);
    }

    public static String prettyPrintHex(String in, int indent, boolean wrapLines) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            buf.append(c);
            int nextPos = i + 1;
            if (wrapLines && nextPos % 32 == 0 && nextPos != in.length()) {
                buf.append("\n").append(TlvUtil.getSpaces(indent));
                continue;
            }
            if (nextPos % 2 != 0 || nextPos == in.length()) continue;
            buf.append(" ");
        }
        return buf.toString();
    }

    public static String getSafePrintChars(byte[] byteArray) {
        if (byteArray == null) {
            return "";
        }
        return TlvUtil.getSafePrintChars(byteArray, 0, byteArray.length);
    }

    public static String getSafePrintChars(byte[] byteArray, int startPos, int length) {
        if (byteArray == null) {
            return "";
        }
        if (byteArray.length < startPos + length) {
            throw new IllegalArgumentException("startPos(" + startPos + ")+length(" + length + ") > byteArray.length(" + byteArray.length + ")");
        }
        StringBuilder buf = new StringBuilder();
        for (int i = startPos; i < startPos + length; ++i) {
            if (byteArray[i] >= 32 && byteArray[i] < 127) {
                buf.append((char)byteArray[i]);
                continue;
            }
            buf.append(".");
        }
        return buf.toString();
    }

    public static int getLength(List<TagAndLength> pList) {
        int ret = 0;
        if (pList != null) {
            for (TagAndLength tl : pList) {
                ret += tl.getLength();
            }
        }
        return ret;
    }

    private TlvUtil() {
    }
}

