/*
 * Decompiled with CFR 0.152.
 */
package com.pro100svitlo.creditCardNfcReader.utils;

import com.pro100svitlo.creditCardNfcReader.enums.CommandEnum;

public class CommandApdu {
    protected int mCla = 0;
    protected int mIns = 0;
    protected int mP1 = 0;
    protected int mP2 = 0;
    protected int mLc = 0;
    protected byte[] mData = new byte[0];
    protected int mLe = 0;
    protected boolean mLeUsed = false;

    public CommandApdu(CommandEnum pEnum, byte[] data, int le) {
        this.mCla = pEnum.getCla();
        this.mIns = pEnum.getIns();
        this.mP1 = pEnum.getP1();
        this.mP2 = pEnum.getP2();
        this.mLc = data == null ? 0 : data.length;
        this.mData = data;
        this.mLe = le;
        this.mLeUsed = true;
    }

    public CommandApdu(CommandEnum pEnum, int p1, int p2, int le) {
        this.mCla = pEnum.getCla();
        this.mIns = pEnum.getIns();
        this.mP1 = p1;
        this.mP2 = p2;
        this.mLe = le;
        this.mLeUsed = true;
    }

    public CommandApdu(CommandEnum pEnum, int p1, int p2) {
        this.mCla = pEnum.getCla();
        this.mIns = pEnum.getIns();
        this.mP1 = p1;
        this.mP2 = p2;
        this.mLeUsed = false;
    }

    public byte[] toBytes() {
        int length = 4;
        if (this.mData != null && this.mData.length != 0) {
            ++length;
            length += this.mData.length;
        }
        if (this.mLeUsed) {
            ++length;
        }
        byte[] apdu = new byte[length];
        int index = 0;
        apdu[index] = (byte)this.mCla;
        apdu[++index] = (byte)this.mIns;
        apdu[++index] = (byte)this.mP1;
        apdu[++index] = (byte)this.mP2;
        ++index;
        if (this.mData != null && this.mData.length != 0) {
            apdu[index] = (byte)this.mLc;
            System.arraycopy(this.mData, 0, apdu, ++index, this.mData.length);
            index += this.mData.length;
        }
        if (this.mLeUsed) {
            int n = index;
            apdu[n] = (byte)(apdu[n] + (byte)this.mLe);
        }
        return apdu;
    }
}

