/*
 * Decompiled with CFR 0.152.
 */
package com.pro100svitlo.creditCardNfcReader.parser.apdu.impl;

import com.pro100svitlo.creditCardNfcReader.model.enums.IKeyEnum;
import com.pro100svitlo.creditCardNfcReader.parser.apdu.annotation.AnnotationData;
import com.pro100svitlo.creditCardNfcReader.utils.EnumUtils;
import fr.devnied.bitlib.BitUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataFactory {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)DataFactory.class.getName());
    public static final int BCD_DATE = 1;
    public static final int HALF_BYTE_SIZE = 4;
    public static final String BCD_FORMAT = "BCD_Format";

    private static Date getDate(AnnotationData pAnnotation, BitUtils pBit) {
        Date date = null;
        date = pAnnotation.getDateStandard() == 1 ? pBit.getNextDate(pAnnotation.getSize(), pAnnotation.getFormat(), true) : pBit.getNextDate(pAnnotation.getSize(), pAnnotation.getFormat());
        return date;
    }

    private static int getInteger(AnnotationData pAnnotation, BitUtils pBit) {
        return pBit.getNextInteger(pAnnotation.getSize());
    }

    public static Object getObject(AnnotationData pAnnotation, BitUtils pBit) {
        Object obj = null;
        Class<?> clazz = pAnnotation.getField().getType();
        if (clazz.equals(Integer.class)) {
            obj = DataFactory.getInteger(pAnnotation, pBit);
        } else if (clazz.equals(Float.class)) {
            obj = DataFactory.getFloat(pAnnotation, pBit);
        } else if (clazz.equals(String.class)) {
            obj = DataFactory.getString(pAnnotation, pBit);
        } else if (clazz.equals(Date.class)) {
            obj = DataFactory.getDate(pAnnotation, pBit);
        } else if (clazz.equals(Boolean.class)) {
            obj = pBit.getNextBoolean();
        } else if (clazz.isEnum()) {
            obj = DataFactory.getEnum(pAnnotation, pBit);
        }
        return obj;
    }

    private static Float getFloat(AnnotationData pAnnotation, BitUtils pBit) {
        Float ret = null;
        ret = BCD_FORMAT.equals(pAnnotation.getFormat()) ? Float.valueOf(Float.parseFloat(pBit.getNextHexaString(pAnnotation.getSize()))) : Float.valueOf(DataFactory.getInteger(pAnnotation, pBit));
        return ret;
    }

    private static IKeyEnum getEnum(AnnotationData pAnnotation, BitUtils pBit) {
        int val = 0;
        try {
            val = Integer.parseInt(pBit.getNextHexaString(pAnnotation.getSize()), pAnnotation.isReadHexa() ? 16 : 10);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return EnumUtils.getValue(val, pAnnotation.getField().getType());
    }

    private static String getString(AnnotationData pAnnotation, BitUtils pBit) {
        String obj = null;
        obj = pAnnotation.isReadHexa() ? pBit.getNextHexaString(pAnnotation.getSize()) : pBit.getNextString(pAnnotation.getSize()).trim();
        return obj;
    }

    private DataFactory() {
    }
}

