/*
 * Decompiled with CFR 0.152.
 */
package com.pro100svitlo.creditCardNfcReader.parser.apdu.annotation;

import com.pro100svitlo.creditCardNfcReader.iso7816emv.ITag;
import com.pro100svitlo.creditCardNfcReader.model.EmvTransactionRecord;
import com.pro100svitlo.creditCardNfcReader.parser.apdu.IFile;
import com.pro100svitlo.creditCardNfcReader.parser.apdu.annotation.AnnotationData;
import com.pro100svitlo.creditCardNfcReader.parser.apdu.annotation.Data;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class AnnotationUtils {
    private static final Class<? extends IFile>[] LISTE_CLASS = new Class[]{EmvTransactionRecord.class};
    private static final AnnotationUtils INSTANCE = new AnnotationUtils();
    private final Map<String, Map<ITag, AnnotationData>> map = new HashMap<String, Map<ITag, AnnotationData>>();
    private final Map<String, Set<AnnotationData>> mapSet = new HashMap<String, Set<AnnotationData>>();

    public static AnnotationUtils getInstance() {
        return INSTANCE;
    }

    private AnnotationUtils() {
        this.extractAnnotation();
    }

    private void extractAnnotation() {
        for (Class<? extends IFile> clazz : LISTE_CLASS) {
            Field[] fields;
            HashMap<ITag, AnnotationData> maps = new HashMap<ITag, AnnotationData>();
            TreeSet<AnnotationData> set = new TreeSet<AnnotationData>();
            for (Field field : fields = clazz.getDeclaredFields()) {
                AnnotationData param = new AnnotationData();
                field.setAccessible(true);
                param.setField(field);
                Data annotation = field.getAnnotation(Data.class);
                if (annotation == null) continue;
                param.initFromAnnotation(annotation);
                maps.put(param.getTag(), param);
                try {
                    set.add((AnnotationData)param.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
            this.mapSet.put(clazz.getName(), set);
            this.map.put(clazz.getName(), maps);
        }
    }

    public Map<String, Set<AnnotationData>> getMapSet() {
        return this.mapSet;
    }

    public Map<String, Map<ITag, AnnotationData>> getMap() {
        return this.map;
    }
}

