/*
 * Decompiled with CFR 0.152.
 */
package com.pro100svitlo.creditCardNfcReader.parser;

import com.pro100svitlo.creditCardNfcReader.enums.CommandEnum;
import com.pro100svitlo.creditCardNfcReader.enums.EmvCardScheme;
import com.pro100svitlo.creditCardNfcReader.enums.SwEnum;
import com.pro100svitlo.creditCardNfcReader.exception.CommunicationException;
import com.pro100svitlo.creditCardNfcReader.iso7816emv.EmvTags;
import com.pro100svitlo.creditCardNfcReader.iso7816emv.EmvTerminal;
import com.pro100svitlo.creditCardNfcReader.iso7816emv.TLV;
import com.pro100svitlo.creditCardNfcReader.iso7816emv.TagAndLength;
import com.pro100svitlo.creditCardNfcReader.model.Afl;
import com.pro100svitlo.creditCardNfcReader.model.EmvCard;
import com.pro100svitlo.creditCardNfcReader.model.EmvTransactionRecord;
import com.pro100svitlo.creditCardNfcReader.model.enums.CurrencyEnum;
import com.pro100svitlo.creditCardNfcReader.parser.IProvider;
import com.pro100svitlo.creditCardNfcReader.utils.CommandApdu;
import com.pro100svitlo.creditCardNfcReader.utils.ResponseUtils;
import com.pro100svitlo.creditCardNfcReader.utils.TlvUtil;
import com.pro100svitlo.creditCardNfcReader.utils.TrackUtils;
import fr.devnied.bitlib.BytesUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmvParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmvParser.class);
    private static final byte[] PPSE = "2PAY.SYS.DDF01".getBytes();
    private static final byte[] PSE = "1PAY.SYS.DDF01".getBytes();
    public static final int UNKNOW = -1;
    public static final String CARD_HOLDER_NAME_SEPARATOR = "/";
    private IProvider provider;
    private boolean contactLess;
    private EmvCard card;

    public EmvParser(IProvider pProvider, boolean pContactLess) {
        this.provider = pProvider;
        this.contactLess = pContactLess;
        this.card = new EmvCard();
    }

    public EmvCard readEmvCard() throws CommunicationException {
        if (!this.readWithPSE()) {
            this.readWithAID();
        }
        return this.card;
    }

    protected byte[] selectPaymentEnvironment() throws CommunicationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Select " + (this.contactLess ? "PPSE" : "PSE") + " Application");
        }
        return this.provider.transceive(new CommandApdu(CommandEnum.SELECT, this.contactLess ? PPSE : PSE, 0).toBytes());
    }

    protected int getLeftPinTry() throws CommunicationException {
        byte[] val;
        byte[] data;
        int ret = -1;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Get Left PIN try");
        }
        if (ResponseUtils.isSucceed(data = this.provider.transceive(new CommandApdu(CommandEnum.GET_DATA, 159, 23, 0).toBytes())) && (val = TlvUtil.getValue(data, EmvTags.PIN_TRY_COUNTER)) != null) {
            ret = BytesUtils.byteArrayToInt((byte[])val);
        }
        return ret;
    }

    protected byte[] parseFCIProprietaryTemplate(byte[] pData) throws CommunicationException {
        byte[] data = TlvUtil.getValue(pData, EmvTags.SFI);
        if (data != null) {
            int sfi = BytesUtils.byteArrayToInt((byte[])data);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SFI found:" + sfi);
            }
            if (ResponseUtils.isEquals(data = this.provider.transceive(new CommandApdu(CommandEnum.READ_RECORD, sfi, sfi << 3 | 4, 0).toBytes()), SwEnum.SW_6C)) {
                data = this.provider.transceive(new CommandApdu(CommandEnum.READ_RECORD, sfi, sfi << 3 | 4, data[data.length - 1]).toBytes());
            }
            return data;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("(FCI) Issuer Discretionary Data is already present");
        }
        return pData;
    }

    protected String extractApplicationLabel(byte[] pData) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Extract Application label");
        }
        String label = null;
        byte[] labelByte = TlvUtil.getValue(pData, EmvTags.APPLICATION_LABEL);
        if (labelByte != null) {
            label = new String(labelByte);
        }
        return label;
    }

    protected boolean readWithPSE() throws CommunicationException {
        byte[] data;
        boolean ret = false;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Try to read card with Payment System Environment");
        }
        if (ResponseUtils.isSucceed(data = this.selectPaymentEnvironment())) {
            if (ResponseUtils.isSucceed(data = this.parseFCIProprietaryTemplate(data))) {
                byte[] aid;
                List<byte[]> aids = this.getAids(data);
                Iterator<byte[]> iterator = aids.iterator();
                while (iterator.hasNext() && !(ret = this.extractPublicData(aid = iterator.next(), this.extractApplicationLabel(data)))) {
                }
                if (!ret) {
                    this.card.setNfcLocked(true);
                }
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((this.contactLess ? "PPSE" : "PSE") + " not found -> Use kown AID");
        }
        return ret;
    }

    protected List<byte[]> getAids(byte[] pData) {
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        List<TLV> listTlv = TlvUtil.getlistTLV(pData, EmvTags.AID_CARD, EmvTags.KERNEL_IDENTIFIER);
        for (TLV tlv : listTlv) {
            if (tlv.getTag() == EmvTags.KERNEL_IDENTIFIER && ret.size() != 0) {
                ret.add(ArrayUtils.addAll((byte[])((byte[])ret.get(ret.size() - 1)), (byte[])tlv.getValueBytes()));
                continue;
            }
            ret.add(tlv.getValueBytes());
        }
        return ret;
    }

    protected void readWithAID() throws CommunicationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Try to read card with AID");
        }
        for (EmvCardScheme type : EmvCardScheme.values()) {
            for (byte[] aid : type.getAidByte()) {
                if (!this.extractPublicData(aid, type.getName())) continue;
                return;
            }
        }
    }

    protected byte[] selectAID(byte[] pAid) throws CommunicationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Select AID: " + BytesUtils.bytesToString((byte[])pAid));
        }
        return this.provider.transceive(new CommandApdu(CommandEnum.SELECT, pAid, 0).toBytes());
    }

    protected boolean extractPublicData(byte[] pAid, String pApplicationLabel) throws CommunicationException {
        boolean ret = false;
        byte[] data = this.selectAID(pAid);
        if (ResponseUtils.isSucceed(data) && (ret = this.parse(data, this.provider))) {
            String aid = BytesUtils.bytesToStringNoSpace((byte[])TlvUtil.getValue(data, EmvTags.DEDICATED_FILE_NAME));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Application label:" + pApplicationLabel + " with Aid:" + aid);
            }
            this.card.setAid(aid);
            this.card.setType(this.findCardScheme(aid, this.card.getCardNumber()));
            this.card.setApplicationLabel(pApplicationLabel);
            this.card.setLeftPinTry(this.getLeftPinTry());
        }
        return ret;
    }

    protected EmvCardScheme findCardScheme(String pAid, String pCardNumber) {
        EmvCardScheme type = EmvCardScheme.getCardTypeByAid(pAid);
        if (type == EmvCardScheme.CB && (type = EmvCardScheme.getCardTypeByCardNumber(pCardNumber)) != null) {
            LOGGER.debug("Real type:" + type.getName());
        }
        return type;
    }

    protected byte[] getLogEntry(byte[] pSelectResponse) {
        return TlvUtil.getValue(pSelectResponse, EmvTags.LOG_ENTRY, EmvTags.VISA_LOG_ENTRY);
    }

    protected boolean parse(byte[] pSelectResponse, IProvider pProvider) throws CommunicationException {
        boolean ret = false;
        byte[] logEntry = this.getLogEntry(pSelectResponse);
        byte[] pdol = TlvUtil.getValue(pSelectResponse, EmvTags.PDOL);
        byte[] gpo = this.getGetProcessingOptions(pdol, pProvider);
        if (!ResponseUtils.isSucceed(gpo) && !ResponseUtils.isSucceed(gpo = this.getGetProcessingOptions(null, pProvider))) {
            return false;
        }
        if (this.extractCommonsCardData(gpo)) {
            this.card.setListTransactions(this.extractLogEntry(logEntry));
            ret = true;
        }
        return ret;
    }

    protected boolean extractCommonsCardData(byte[] pGpo) throws CommunicationException {
        boolean ret = false;
        byte[] data = TlvUtil.getValue(pGpo, EmvTags.RESPONSE_MESSAGE_TEMPLATE_1);
        if (data != null) {
            data = ArrayUtils.subarray((byte[])data, (int)2, (int)data.length);
        } else {
            ret = TrackUtils.extractTrack2Data(this.card, pGpo);
            if (!ret) {
                data = TlvUtil.getValue(pGpo, EmvTags.APPLICATION_FILE_LOCATOR);
            } else {
                this.extractCardHolderName(pGpo);
            }
        }
        if (data != null) {
            List<Afl> listAfl = this.extractAfl(data);
            for (Afl afl : listAfl) {
                for (int index = afl.getFirstRecord(); index <= afl.getLastRecord(); ++index) {
                    byte[] info = this.provider.transceive(new CommandApdu(CommandEnum.READ_RECORD, index, afl.getSfi() << 3 | 4, 0).toBytes());
                    if (ResponseUtils.isEquals(info, SwEnum.SW_6C)) {
                        info = this.provider.transceive(new CommandApdu(CommandEnum.READ_RECORD, index, afl.getSfi() << 3 | 4, info[info.length - 1]).toBytes());
                    }
                    if (!ResponseUtils.isSucceed(info)) continue;
                    this.extractCardHolderName(info);
                    if (!TrackUtils.extractTrack2Data(this.card, info)) continue;
                    return true;
                }
            }
        }
        return ret;
    }

    protected List<TagAndLength> getLogFormat() throws CommunicationException {
        byte[] data;
        List<TagAndLength> ret = new ArrayList<TagAndLength>();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("GET log format");
        }
        if (ResponseUtils.isSucceed(data = this.provider.transceive(new CommandApdu(CommandEnum.GET_DATA, 159, 79, 0).toBytes()))) {
            ret = TlvUtil.parseTagAndLength(TlvUtil.getValue(data, EmvTags.LOG_FORMAT));
        }
        return ret;
    }

    protected List<EmvTransactionRecord> extractLogEntry(byte[] pLogEntry) throws CommunicationException {
        ArrayList<EmvTransactionRecord> listRecord = new ArrayList<EmvTransactionRecord>();
        if (pLogEntry != null) {
            byte[] response;
            List<TagAndLength> tals = this.getLogFormat();
            for (int rec = 1; rec <= pLogEntry[1] && ResponseUtils.isSucceed(response = this.provider.transceive(new CommandApdu(CommandEnum.READ_RECORD, rec, pLogEntry[0] << 3 | 4, 0).toBytes())); ++rec) {
                EmvTransactionRecord record = new EmvTransactionRecord();
                record.parse(response, tals);
                if (record.getAmount().floatValue() >= 1.5E9f) {
                    record.setAmount(Float.valueOf(record.getAmount().floatValue() - 1.5E9f));
                }
                if (record.getAmount() == null || record.getAmount().floatValue() == 0.0f || record == null) continue;
                if (record.getCurrency() == null) {
                    record.setCurrency(CurrencyEnum.XXX);
                }
                listRecord.add(record);
            }
        }
        return listRecord;
    }

    protected List<Afl> extractAfl(byte[] pAfl) {
        ArrayList<Afl> list = new ArrayList<Afl>();
        ByteArrayInputStream bai = new ByteArrayInputStream(pAfl);
        while (bai.available() >= 4) {
            Afl afl = new Afl();
            afl.setSfi(bai.read() >> 3);
            afl.setFirstRecord(bai.read());
            afl.setLastRecord(bai.read());
            afl.setOfflineAuthentication(bai.read() == 1);
            list.add(afl);
        }
        return list;
    }

    protected void extractCardHolderName(byte[] pData) {
        String[] name;
        byte[] cardHolderByte = TlvUtil.getValue(pData, EmvTags.CARDHOLDER_NAME);
        if (cardHolderByte != null && (name = StringUtils.split((String)new String(cardHolderByte).trim(), (String)CARD_HOLDER_NAME_SEPARATOR)) != null && name.length == 2) {
            this.card.setHolderFirstname(StringUtils.trimToNull((String)name[0]));
            this.card.setHolderLastname(StringUtils.trimToNull((String)name[1]));
        }
    }

    protected byte[] getGetProcessingOptions(byte[] pPdol, IProvider pProvider) throws CommunicationException {
        List<TagAndLength> list = TlvUtil.parseTagAndLength(pPdol);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(EmvTags.COMMAND_TEMPLATE.getTagBytes());
            out.write(TlvUtil.getLength(list));
            if (list != null) {
                for (TagAndLength tl : list) {
                    out.write(EmvTerminal.constructValue(tl));
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Construct GPO Command:" + ioe.getMessage(), (Throwable)ioe);
        }
        return pProvider.transceive(new CommandApdu(CommandEnum.GPO, out.toByteArray(), 0).toBytes());
    }

    public EmvCard getCard() {
        return this.card;
    }
}

