/*
 * Decompiled with CFR 0.152.
 */
package com.pro100svitlo.creditCardNfcReader;

import android.content.Intent;
import android.nfc.Tag;
import android.nfc.tech.IsoDep;
import android.os.AsyncTask;
import android.util.Log;
import com.pro100svitlo.creditCardNfcReader.enums.EmvCardScheme;
import com.pro100svitlo.creditCardNfcReader.model.EmvCard;
import com.pro100svitlo.creditCardNfcReader.parser.EmvParser;
import com.pro100svitlo.creditCardNfcReader.utils.Provider;
import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class CardNfcAsyncTask
extends AsyncTask<Void, Void, Object> {
    public static final String CARD_UNKNOWN = EmvCardScheme.UNKNOWN.toString();
    public static final String CARD_VISA = EmvCardScheme.VISA.toString();
    public static final String CARD_NAB_VISA = EmvCardScheme.NAB_VISA.toString();
    public static final String CARD_MASTER_CARD = EmvCardScheme.MASTER_CARD.toString();
    public static final String CARD_AMERICAN_EXPRESS = EmvCardScheme.AMERICAN_EXPRESS.toString();
    public static final String CARD_CB = EmvCardScheme.CB.toString();
    public static final String CARD_LINK = EmvCardScheme.LINK.toString();
    public static final String CARD_JCB = EmvCardScheme.JCB.toString();
    public static final String CARD_DANKORT = EmvCardScheme.DANKORT.toString();
    public static final String CARD_COGEBAN = EmvCardScheme.COGEBAN.toString();
    public static final String CARD_DISCOVER = EmvCardScheme.DISCOVER.toString();
    public static final String CARD_BANRISUL = EmvCardScheme.BANRISUL.toString();
    public static final String CARD_SPAN = EmvCardScheme.SPAN.toString();
    public static final String CARD_INTERAC = EmvCardScheme.INTERAC.toString();
    public static final String CARD_ZIP = EmvCardScheme.ZIP.toString();
    public static final String CARD_UNIONPAY = EmvCardScheme.UNIONPAY.toString();
    public static final String CARD_EAPS = EmvCardScheme.EAPS.toString();
    public static final String CARD_VERVE = EmvCardScheme.VERVE.toString();
    public static final String CARD_TENN = EmvCardScheme.TENN.toString();
    public static final String CARD_RUPAY = EmvCardScheme.RUPAY.toString();
    public static final String CARD_\u041f\u0420\u041e100 = EmvCardScheme.\u041f\u0420\u041e100.toString();
    public static final String CARD_ZKA = EmvCardScheme.ZKA.toString();
    public static final String CARD_BANKAXEPT = EmvCardScheme.BANKAXEPT.toString();
    public static final String CARD_BRADESCO = EmvCardScheme.BRADESCO.toString();
    public static final String CARD_MIDLAND = EmvCardScheme.MIDLAND.toString();
    public static final String CARD_PBS = EmvCardScheme.PBS.toString();
    public static final String CARD_ETRANZACT = EmvCardScheme.ETRANZACT.toString();
    public static final String CARD_GOOGLE = EmvCardScheme.GOOGLE.toString();
    public static final String CARD_INTER_SWITCH = EmvCardScheme.INTER_SWITCH.toString();
    private static final String NFC_A_TAG = "TAG: Tech [android.nfc.tech.IsoDep, android.nfc.tech.NfcA]";
    private static final String NFC_B_TAG = "TAG: Tech [android.nfc.tech.IsoDep, android.nfc.tech.NfcB]";
    private final String UNKNOWN_CARD_MESS = "===========================================================================\n\nHi! This library is not familiar with your credit card. \n Please, write me an email with information of your bank: \ncountry, bank name, card type, etc) and i will try to do my best, \nto add your bank as a known one into this lib. \nGreat thanks for using and reporting!!! \nHere is my email: pro100svitlo@gmail.com. \n\n===========================================================================";
    private Provider mProvider = new Provider();
    private boolean mException;
    private EmvCard mCard;
    private CardNfcInterface mInterface;
    private Tag mTag;
    private String mCardNumber;
    private String mExpireDate;
    private String mCardType;

    private CardNfcAsyncTask(Builder b) {
        this.mTag = b.mTag;
        if (this.mTag != null) {
            this.mInterface = b.mInterface;
            try {
                if (this.mTag.toString().equals(NFC_A_TAG) || this.mTag.toString().equals(NFC_B_TAG)) {
                    this.execute(new Void[0]);
                } else {
                    if (!b.mFromStart) {
                        this.mInterface.unknownEmvCard();
                    }
                    this.clearAll();
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
    }

    public String getCardNumber() {
        return this.mCardNumber;
    }

    public String getCardExpireDate() {
        return this.mExpireDate;
    }

    public String getCardType() {
        return this.mCardType;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.mInterface.startNfcReadCard();
        this.mProvider.getLog().setLength(0);
    }

    protected Object doInBackground(Void ... params) {
        Exception result = null;
        try {
            this.doInBackground();
        }
        catch (Exception e) {
            result = e;
            Log.e((String)CardNfcAsyncTask.class.getName(), (String)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected void onPostExecute(Object result) {
        if (!this.mException) {
            if (this.mCard != null) {
                if (StringUtils.isNotBlank((CharSequence)this.mCard.getCardNumber())) {
                    this.mCardNumber = this.mCard.getCardNumber();
                    this.mExpireDate = this.mCard.getExpireDate();
                    this.mCardType = this.mCard.getType().toString();
                    if (this.mCardType.equals(EmvCardScheme.UNKNOWN.toString())) {
                        Log.d((String)"creditCardNfcReader", (String)"===========================================================================\n\nHi! This library is not familiar with your credit card. \n Please, write me an email with information of your bank: \ncountry, bank name, card type, etc) and i will try to do my best, \nto add your bank as a known one into this lib. \nGreat thanks for using and reporting!!! \nHere is my email: pro100svitlo@gmail.com. \n\n===========================================================================");
                    }
                    this.mInterface.cardIsReadyToRead();
                } else if (this.mCard.isNfcLocked()) {
                    this.mInterface.cardWithLockedNfc();
                }
            } else {
                this.mInterface.unknownEmvCard();
            }
        } else {
            this.mInterface.doNotMoveCardSoFast();
        }
        this.mInterface.finishNfcReadCard();
        this.clearAll();
    }

    private void doInBackground() {
        IsoDep mIsoDep = IsoDep.get((Tag)this.mTag);
        if (mIsoDep == null) {
            this.mInterface.doNotMoveCardSoFast();
            return;
        }
        this.mException = false;
        try {
            mIsoDep.connect();
            this.mProvider.setmTagCom(mIsoDep);
            EmvParser parser = new EmvParser(this.mProvider, true);
            this.mCard = parser.readEmvCard();
        }
        catch (IOException e) {
            this.mException = true;
        }
        finally {
            IOUtils.closeQuietly((Closeable)mIsoDep);
        }
    }

    private void clearAll() {
        this.mInterface = null;
        this.mProvider = null;
        this.mCard = null;
        this.mTag = null;
        this.mCardNumber = null;
        this.mExpireDate = null;
        this.mCardType = null;
    }

    public static interface CardNfcInterface {
        public void startNfcReadCard();

        public void cardIsReadyToRead();

        public void doNotMoveCardSoFast();

        public void unknownEmvCard();

        public void cardWithLockedNfc();

        public void finishNfcReadCard();
    }

    public static class Builder {
        private Tag mTag;
        private CardNfcInterface mInterface;
        private boolean mFromStart;

        public Builder(CardNfcInterface i, Intent intent, boolean fromCreate) {
            this.mInterface = i;
            this.mTag = (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
            this.mFromStart = fromCreate;
        }

        public CardNfcAsyncTask build() {
            return new CardNfcAsyncTask(this);
        }
    }
}

