/*
 * Decompiled with CFR 0.152.
 */
package fr.devnied.bitlib;

import java.math.BigInteger;
import java.util.Locale;

public final class BytesUtils {
    private static final int MAX_BIT_INTEGER = 31;
    private static final int HEXA = 16;
    private static final String FORMAT_NOSPACE = "%02x";
    private static final String FORMAT_SPACE = "%02x ";
    private static final int DEFAULT_MASK = 255;

    public static int byteArrayToInt(byte[] byteArray) {
        if (byteArray == null) {
            throw new IllegalArgumentException("Parameter 'byteArray' cannot be null");
        }
        return BytesUtils.byteArrayToInt(byteArray, 0, byteArray.length);
    }

    public static int byteArrayToInt(byte[] byteArray, int startPos, int length) {
        if (byteArray == null) {
            throw new IllegalArgumentException("Parameter 'byteArray' cannot be null");
        }
        if (length <= 0 || length > 4) {
            throw new IllegalArgumentException("Length must be between 1 and 4. Length = " + length);
        }
        if (startPos < 0 || byteArray.length < startPos + length) {
            throw new IllegalArgumentException("Length or startPos not valid");
        }
        int value = 0;
        for (int i = 0; i < length; ++i) {
            value += (byteArray[startPos + i] & 0xFF) << 8 * (length - i - 1);
        }
        return value;
    }

    public static String bytesToString(byte[] pBytes) {
        return BytesUtils.formatByte(pBytes, FORMAT_SPACE, false);
    }

    public static String bytesToString(byte[] pBytes, boolean pTruncate) {
        return BytesUtils.formatByte(pBytes, FORMAT_SPACE, pTruncate);
    }

    public static String bytesToStringNoSpace(byte pByte) {
        return BytesUtils.formatByte(new byte[]{pByte}, FORMAT_NOSPACE, false);
    }

    public static String bytesToStringNoSpace(byte[] pBytes) {
        return BytesUtils.formatByte(pBytes, FORMAT_NOSPACE, false);
    }

    public static String bytesToStringNoSpace(byte[] pBytes, boolean pTruncate) {
        return BytesUtils.formatByte(pBytes, FORMAT_NOSPACE, pTruncate);
    }

    private static String formatByte(byte[] pByte, String pFormat, boolean pTruncate) {
        StringBuffer sb = new StringBuffer();
        if (pByte == null) {
            sb.append("");
        } else {
            boolean t = false;
            for (byte b : pByte) {
                if (b == 0 && pTruncate && !t) continue;
                t = true;
                sb.append(String.format(pFormat, b & 0xFF));
            }
        }
        return sb.toString().toUpperCase(Locale.getDefault()).trim();
    }

    public static byte[] fromString(String pData) {
        if (pData == null) {
            throw new IllegalArgumentException("Argument can't be null");
        }
        String text = pData.replace(" ", "");
        if (text.length() % 2 != 0) {
            throw new IllegalArgumentException("Hex binary needs to be even-length :" + pData);
        }
        byte[] commandByte = new byte[Math.round((float)text.length() / 2.0f)];
        int j = 0;
        for (int i = 0; i < text.length(); i += 2) {
            Integer val = Integer.parseInt(text.substring(i, i + 2), 16);
            commandByte[j++] = val.byteValue();
        }
        return commandByte;
    }

    public static boolean matchBitByBitIndex(int pVal, int pBitIndex) {
        if (pBitIndex < 0 || pBitIndex > 31) {
            throw new IllegalArgumentException("parameter 'pBitIndex' must be between 0 and 31. pBitIndex=" + pBitIndex);
        }
        return (pVal & 1 << pBitIndex) != 0;
    }

    public static byte setBit(byte pData, int pBitIndex, boolean pOn) {
        if (pBitIndex < 0 || pBitIndex > 7) {
            throw new IllegalArgumentException("parameter 'pBitIndex' must be between 0 and 7. pBitIndex=" + pBitIndex);
        }
        byte ret = pData;
        ret = pOn ? (byte)(ret | 1 << pBitIndex) : (byte)(ret & ~(1 << pBitIndex));
        return ret;
    }

    public static String toBinary(byte[] pBytes) {
        String ret = null;
        if (pBytes != null && pBytes.length > 0) {
            BigInteger val = new BigInteger(BytesUtils.bytesToStringNoSpace(pBytes), 16);
            StringBuilder build = new StringBuilder(val.toString(2));
            for (int i = build.length(); i < pBytes.length * 8; ++i) {
                build.insert(0, 0);
            }
            ret = build.toString();
        }
        return ret;
    }

    public static byte[] toByteArray(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    private BytesUtils() {
    }
}

