/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.request.reflect;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.tiles.request.reflect.CannotInstantiateObjectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassUtil {
    private ClassUtil() {
    }

    public static <T> Class<? extends T> getClass(String className, Class<T> baseClass) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassUtil.class.getClassLoader();
        }
        return Class.forName(className, true, classLoader).asSubclass(baseClass);
    }

    public static Object instantiate(String className) {
        return ClassUtil.instantiate(className, false);
    }

    public static Object instantiate(String className, boolean returnNull) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassUtil.class.getClassLoader();
        }
        try {
            Class<Object> namedClass = ClassUtil.getClass(className, Object.class);
            return namedClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            if (returnNull) {
                return null;
            }
            throw new CannotInstantiateObjectException("Unable to resolve factory class: '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new CannotInstantiateObjectException("Unable to access factory class: '" + className + "'", e);
        }
        catch (InstantiationException | InvocationTargetException e) {
            throw new CannotInstantiateObjectException("Unable to instantiate factory class: '" + className + "'. Make sure that this class has a default constructor", e);
        }
    }

    public static void collectBeanInfo(Class<?> clazz, Map<String, PropertyDescriptor> name2descriptor) {
        BeanInfo info;
        block4: {
            Logger log = LoggerFactory.getLogger(ClassUtil.class);
            info = null;
            try {
                info = Introspector.getBeanInfo(clazz);
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Cannot inspect class " + clazz, (Throwable)ex);
            }
        }
        if (info == null) {
            return;
        }
        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            pd.setValue("type", pd.getPropertyType());
            pd.setValue("resolvableAtDesignTime", Boolean.TRUE);
            name2descriptor.put(pd.getName(), pd);
        }
    }
}

