/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ScrollingView;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.NestedScrollView;
import android.support.v4.widget.ScrollerCompat;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ListView;
import android.widget.ScrollView;
import com.powyin.scroll.R;
import com.powyin.scroll.widget.EmptyController;
import com.powyin.scroll.widget.ISwipe;
import com.powyin.scroll.widget.SwipeController;
import com.powyin.scroll.widget.SwipeControllerStyleNormal;

public class SwipeNest
extends ViewGroup
implements NestedScrollingParent,
ISwipe,
ScrollingView {
    private int mTouchSlop;
    private int mActivePointerId = -1;
    private boolean mNestedScrollInProgress = false;
    private float mDragBeginY;
    private float mDragBeginDirect;
    private float mDragLastY;
    private boolean mIsTouchEventMode = false;
    private boolean mPreScroll;
    private boolean mDraggedDispatch;
    private boolean mDraggedIntercept;
    private boolean mShouldCancelMotionEvent = false;
    private int mContentScroll;
    private int overScrollTop;
    private int overScrollBottom;
    private ScrollerCompat mScroller;
    private VelocityTracker mVelocityTracker;
    private SwipeController mSwipeController;
    private EmptyController mEmptyController;
    private ValueAnimator animationReBackToRefreshing;
    private ValueAnimator animationReBackToTop;
    private NestedScrollingParentHelper mParentHelper;
    private boolean mRefreshStatusContinueRunning = false;
    private ISwipe.FreshStatus mFreshStatus = null;
    private boolean mLoadedStatusContinueRunning = false;
    private ISwipe.LoadedStatus mLoadedStatus = null;
    private SwipeController.SwipeModel mModel = SwipeController.SwipeModel.SWIPE_BOTH;
    private ISwipe.OnRefreshListener mOnRefreshListener;
    private boolean mShowEmptyView;
    private int mEmptyViewIndex = -1;
    private View mViewTop;
    private View mViewBottom;
    private View mEmptyView;
    private View mEmptyReplaceView;
    private View mTargetView;
    private View mTargetViewContain;
    private int mTargetViewContainIndex;
    private int mMaxFlingDirection;
    private int mMaxFlingScrollUp = 0;
    private int mMaxFlingScrollButton = 0;
    private View mMaxFlingScrollDesView;
    private OnScrollListener mOnScrollListener;

    public SwipeNest(Context context) {
        this(context, null);
    }

    public SwipeNest(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeNest(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwipeNest);
            int modelIndex = a.getInt(R.styleable.SwipeNest_fresh, -1);
            if (modelIndex >= 0 && modelIndex < SwipeController.SwipeModel.values().length) {
                this.mModel = SwipeController.SwipeModel.values()[modelIndex];
            }
            a.recycle();
        }
        this.mScroller = ScrollerCompat.create((Context)this.getContext(), null);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.initSwipeControl();
    }

    private void initSwipeControl() {
        this.mSwipeController = new SwipeControllerStyleNormal(this.getContext());
        this.mViewTop = this.mSwipeController.getSwipeHead();
        this.mViewBottom = this.mSwipeController.getSwipeFoot();
        this.addView(this.mViewTop, 0);
        this.addView(this.mViewBottom, this.getChildCount());
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        ScrollingView scrollingView;
        int range;
        if (!this.mLoadedStatusContinueRunning && this.mOnRefreshListener != null && target instanceof ScrollingView && (range = (scrollingView = (ScrollingView)target).computeVerticalScrollRange() - scrollingView.computeVerticalScrollOffset() - scrollingView.computeVerticalScrollExtent()) < 6 * this.getHeight()) {
            this.mLoadedStatusContinueRunning = true;
            if (this.mOnRefreshListener != null) {
                this.mOnRefreshListener.onLoading();
            }
        }
        this.mNestedScrollInProgress = true;
        if (!(target == this.mEmptyView || target == this.mEmptyReplaceView && this.mShowEmptyView)) {
            this.mTargetView = target;
            this.mTargetViewContain = child;
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (this.getChildAt(i) != this.mTargetViewContain) continue;
                this.mTargetViewContainIndex = i;
            }
        }
        this.stopAllScroll();
        return (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.mParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int delta;
        consumed[1] = delta = this.offSetScroll(dy, true);
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View target) {
        this.mParentHelper.onStopNestedScroll(target);
        this.mNestedScrollInProgress = false;
        if (!this.tryBackToRefreshing()) {
            this.tryBackToFreshFinish();
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.offSetScroll(dyUnconsumed, false);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        if (velocityY < 0.0f || this.mLoadedStatusContinueRunning || this.mOnRefreshListener == null || !(target instanceof ScrollingView)) {
            return false;
        }
        float radio = velocityY / (float)this.getHeight();
        radio = radio > 1.0f ? radio : 1.0f;
        radio = radio < 10.0f ? radio : 10.0f;
        ScrollingView scrollingView = (ScrollingView)target;
        int range = scrollingView.computeVerticalScrollRange() - scrollingView.computeVerticalScrollOffset() - scrollingView.computeVerticalScrollExtent();
        if ((float)range < radio * (float)this.getHeight()) {
            this.mLoadedStatusContinueRunning = true;
            if (this.mOnRefreshListener != null) {
                this.mOnRefreshListener.onLoading();
            }
        }
        return false;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        boolean consume;
        Integer but = this.mTargetViewContain != null ? (Integer)this.mTargetViewContain.getTag(0x40000000) : null;
        but = but == null ? Integer.MAX_VALUE : but;
        int currentScrollY = this.getScrollY();
        if (currentScrollY < 0) {
            return true;
        }
        if (but > currentScrollY || currentScrollY > this.mContentScroll) {
            this.fling((int)velocityY);
            return true;
        }
        boolean bl = consume = !(velocityY > 0.0f && this.canChildScrollUp() || velocityY < 0.0f && this.canChildScrollDown());
        if (consume) {
            this.fling((int)velocityY);
        }
        return consume;
    }

    private void fling(int velocityY) {
        int centerY;
        int centerX;
        int[] tem;
        View targetView;
        Integer integer;
        int i;
        if (this.animationReBackToRefreshing != null && this.animationReBackToRefreshing.isRunning()) {
            return;
        }
        if (this.animationReBackToTop != null && this.animationReBackToTop.isRunning()) {
            return;
        }
        int currentScrollY = this.getScrollY();
        this.mMaxFlingScrollUp = 0;
        this.mMaxFlingScrollButton = this.mContentScroll + this.overScrollBottom;
        this.mMaxFlingDirection = 0;
        if (velocityY > 0) {
            int n = i = this.mTargetViewContainIndex > 0 ? this.mTargetViewContainIndex : 0;
            while (i < this.getChildCount()) {
                integer = (Integer)this.getChildAt(i).getTag(0x40000000);
                if (integer != null && integer > currentScrollY) {
                    targetView = this.getChildAt(i);
                    tem = new int[2];
                    targetView.getLocationInWindow(tem);
                    centerX = tem[0] + targetView.getWidth() / 2;
                    centerY = tem[1] + targetView.getHeight() / 2;
                    this.mMaxFlingScrollDesView = this.findScrollView(targetView, centerX, centerY, 1);
                    if (this.mMaxFlingScrollDesView != null) {
                        this.mMaxFlingScrollButton = integer;
                        break;
                    }
                }
                ++i;
            }
            this.mMaxFlingDirection = 1;
            this.mScroller.fling(0, currentScrollY, 0, velocityY, 0, 0, -1000000, 1000000, 0, 0);
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
        if (velocityY < 0) {
            int n = i = this.mTargetViewContainIndex > 0 ? this.mTargetViewContainIndex : this.getChildCount() - 1;
            while (i >= 0) {
                integer = (Integer)this.getChildAt(i).getTag(0x40000000);
                if (integer != null && integer < currentScrollY) {
                    targetView = this.getChildAt(i);
                    tem = new int[2];
                    targetView.getLocationInWindow(tem);
                    centerX = tem[0] + targetView.getWidth() / 2;
                    centerY = tem[1] + targetView.getHeight() / 2;
                    this.mMaxFlingScrollDesView = this.findScrollView(targetView, centerX, centerY, -1);
                    if (this.mMaxFlingScrollDesView != null) {
                        this.mMaxFlingScrollUp = integer;
                        break;
                    }
                }
                --i;
            }
            this.mMaxFlingScrollUp = this.mMaxFlingScrollUp > 0 ? this.mMaxFlingScrollUp : 0;
            this.mMaxFlingDirection = -1;
            this.mScroller.fling(0, currentScrollY, 0, velocityY, 0, 0, -1000000, 1000000, 0, 0);
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    private View findScrollView(View view, int centerX, int centerY, int direction) {
        if (view.getVisibility() == 4 || view.getVisibility() == 8) {
            return null;
        }
        int[] tem = new int[2];
        view.getLocationInWindow(tem);
        if (tem[0] < centerX && centerX < tem[0] + view.getWidth() && tem[1] < centerY && centerY < tem[1] + view.getHeight()) {
            if (view.canScrollVertically(direction)) {
                return view;
            }
            if (view instanceof ViewGroup) {
                ViewGroup group = (ViewGroup)view;
                for (int i = 0; i < group.getChildCount(); ++i) {
                    View child = this.findScrollView(group.getChildAt(i), centerX, centerY, direction);
                    if (child == null) continue;
                    return child;
                }
            }
            return null;
        }
        return null;
    }

    public int computeHorizontalScrollRange() {
        return this.getWidth();
    }

    public int computeHorizontalScrollOffset() {
        return 0;
    }

    public int computeHorizontalScrollExtent() {
        return this.getWidth();
    }

    public int computeVerticalScrollRange() {
        return this.mContentScroll + this.getHeight();
    }

    public int computeVerticalScrollOffset() {
        return this.getScrollY();
    }

    public int computeVerticalScrollExtent() {
        return this.getHeight();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthTarget = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightTarget = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childWidMeasure = View.MeasureSpec.makeMeasureSpec((int)widthTarget, (int)0x40000000);
        int spHei = View.MeasureSpec.makeMeasureSpec((int)heightTarget, (int)Integer.MIN_VALUE);
        int mTotalLength = 0;
        int normalIndex = 0;
        int childCount = this.getChildCount();
        boolean hasMeasureEmptyView = false;
        this.mEmptyReplaceView = null;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child == this.mViewTop || child == this.mViewBottom || child == this.mEmptyView) continue;
            if (child.getVisibility() != 8) {
                ViewGroup.LayoutParams lp = child.getLayoutParams();
                switch (lp.height) {
                    case -2: {
                        child.measure(childWidMeasure, View.MeasureSpec.makeMeasureSpec((int)heightTarget, (int)Integer.MIN_VALUE));
                        break;
                    }
                    case -1: {
                        child.measure(childWidMeasure, View.MeasureSpec.makeMeasureSpec((int)heightTarget, (int)0x40000000));
                        break;
                    }
                    default: {
                        child.measure(childWidMeasure, View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000));
                    }
                }
                int childMeasureHei = child.getMeasuredHeight();
                childMeasureHei = childMeasureHei > 0 ? childMeasureHei : 0;
                mTotalLength += childMeasureHei;
                if (this.mEmptyViewIndex == normalIndex) {
                    this.mEmptyReplaceView = child;
                    if (this.mEmptyView != null) {
                        int preLen;
                        hasMeasureEmptyView = true;
                        if (normalIndex == childCount - 4 && heightTarget - (preLen = mTotalLength - childMeasureHei) > 0) {
                            childMeasureHei = heightTarget - preLen;
                        }
                        this.mEmptyView.measure(View.MeasureSpec.makeMeasureSpec((int)widthTarget, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)childMeasureHei, (int)0x40000000));
                    }
                }
            }
            ++normalIndex;
        }
        if (this.mViewTop != null) {
            this.mViewTop.measure(childWidMeasure, spHei);
        }
        if (this.mViewBottom != null) {
            this.mViewBottom.measure(childWidMeasure, spHei);
        }
        if (!hasMeasureEmptyView && this.mEmptyView != null) {
            this.mEmptyView.measure(childWidMeasure, spHei);
        }
        int endHei = Math.max(mTotalLength, this.getSuggestedMinimumHeight());
        int endWid = Math.max(widthTarget, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(SwipeNest.resolveSizeAndState((int)endWid, (int)widthMeasureSpec, (int)0), SwipeNest.resolveSizeAndState((int)endHei, (int)heightMeasureSpec, (int)0));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int oldContentScroll = this.mContentScroll;
        int currentHei = 0;
        boolean hasEmptyViewLayout = false;
        for (int i = 0; i < this.getChildCount(); ++i) {
            int itemHei;
            View child = this.getChildAt(i);
            if (child == this.mViewTop || child == this.mViewBottom || child == this.mEmptyView || child.getVisibility() == 8) continue;
            if (child == this.mEmptyReplaceView) {
                if (this.mShowEmptyView) {
                    if (this.mEmptyView != null) {
                        hasEmptyViewLayout = true;
                        int itemEmptyHei = this.mEmptyView.getMeasuredHeight();
                        if (itemEmptyHei > b - t) {
                            itemEmptyHei = b - t;
                        }
                        this.mEmptyView.layout(0, currentHei, r - l, currentHei + itemEmptyHei);
                        int itemHei2 = child.getMeasuredHeight();
                        child.layout(r - l, currentHei += itemEmptyHei, 2 * (r - l), currentHei + itemHei2);
                        child.setTag(0x40000000, null);
                        continue;
                    }
                    itemHei = child.getMeasuredHeight();
                    child.layout(r - l, currentHei += itemHei, 2 * (r - l), currentHei + itemHei);
                    child.setTag(0x40000000, null);
                    continue;
                }
                if (this.mEmptyView != null) {
                    hasEmptyViewLayout = true;
                    this.mEmptyView.layout(r - l, currentHei, 2 * (r - l), currentHei + this.mEmptyView.getMeasuredHeight());
                }
                if ((itemHei = child.getMeasuredHeight()) > b - t) {
                    itemHei = b - t;
                }
                child.layout(0, currentHei, r - l, currentHei + itemHei);
                child.setTag(0x40000000, (Object)((currentHei += itemHei) - (b - t)));
                continue;
            }
            itemHei = child.getMeasuredHeight();
            if (itemHei > b - t) {
                itemHei = b - t;
            }
            child.layout(0, currentHei, r - l, currentHei + itemHei);
            child.setTag(0x40000000, (Object)((currentHei += itemHei) - (b - t)));
        }
        boolean canOverScrollBottom = currentHei >= b - t;
        this.mContentScroll = canOverScrollBottom ? currentHei - (b - t) : 0;
        this.overScrollTop = this.mViewTop.getMeasuredHeight();
        this.overScrollBottom = this.mViewBottom.getMeasuredHeight();
        this.mViewTop.layout(0, -this.overScrollTop, r - l, 0);
        this.mViewTop.setTag(0x40000000, (Object)0);
        this.mViewBottom.layout(0, b - t + this.mContentScroll, r - l, b - t + this.mContentScroll + this.overScrollBottom);
        this.mViewTop.setTag(0x40000000, (Object)(this.mContentScroll + this.overScrollBottom));
        if (!hasEmptyViewLayout && this.mEmptyView != null) {
            this.mEmptyView.layout(r - l, 0, 2 * (r - l), this.mEmptyView.getMeasuredHeight());
        }
        if (this.mModel == SwipeController.SwipeModel.SWIPE_NONE || this.mModel == SwipeController.SwipeModel.SWIPE_ONLY_LOADINN) {
            this.overScrollTop = 0;
        }
        if (!canOverScrollBottom || this.mModel == SwipeController.SwipeModel.SWIPE_NONE || this.mModel == SwipeController.SwipeModel.SWIPE_ONLY_REFRESH) {
            this.overScrollBottom = 0;
        }
        if (oldContentScroll > this.mContentScroll && this.getScrollY() > 0) {
            int currentScrollY = this.getScrollY();
            currentScrollY = (currentScrollY -= oldContentScroll - this.mContentScroll) > 0 ? currentScrollY : 0;
            this.scrollTo(0, currentScrollY);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.mDraggedIntercept = false;
            this.mPreScroll = false;
            this.mDraggedDispatch = false;
            this.mActivePointerId = ev.getPointerId(0);
            this.mDragBeginY = (int)ev.getY();
            this.mDragBeginDirect = 0.0f;
            this.mIsTouchEventMode = true;
            this.mDragLastY = this.mDragBeginY;
            this.mShouldCancelMotionEvent = false;
            this.mTargetView = null;
            this.mTargetViewContain = null;
            this.mTargetViewContainIndex = -1;
            int x = (int)ev.getX();
            int y = (int)ev.getY();
            for (int i = 0; i < this.getChildCount(); ++i) {
                boolean isSelect;
                int scrollY = this.getScrollY();
                View child = this.getChildAt(i);
                if (child == this.mViewTop || child == this.mViewBottom || child == this.mEmptyView) continue;
                boolean bl = isSelect = y >= child.getTop() - scrollY && y < child.getBottom() - scrollY && x >= child.getLeft() && x < child.getRight();
                if (!isSelect) continue;
                if (child == this.mEmptyReplaceView) break;
                this.mTargetView = child;
                this.mTargetViewContain = child;
                this.mTargetViewContainIndex = i;
                break;
            }
        }
        if (ev.getAction() == 1 || ev.getAction() == 3) {
            this.mIsTouchEventMode = false;
        }
        if (this.mNestedScrollInProgress) {
            return super.dispatchTouchEvent(ev);
        }
        if (ev.getAction() == 0 && (this.getScrollY() < 0 || this.getScrollY() > this.mContentScroll)) {
            this.mPreScroll = true;
        }
        if (this.mPreScroll) {
            int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
            switch (action) {
                case 0: {
                    this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                    this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                    break;
                }
                case 5: {
                    int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                    this.mActivePointerId = ev.getPointerId(pointerIndex);
                    this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                    break;
                }
                case 2: {
                    float y = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                    float yDiff = this.mDragBeginY - y;
                    if (!this.mDraggedDispatch && Math.abs(yDiff) > (float)(this.mTouchSlop / 2)) {
                        this.mDraggedDispatch = true;
                        this.mDragLastY = y;
                    }
                    if (!this.mDraggedDispatch) break;
                    this.offSetScroll((int)(this.mDragLastY - y), true);
                    if (this.getScrollY() == 0) {
                        this.mPreScroll = false;
                    }
                    this.mDragLastY = y;
                    return true;
                }
                case 6: {
                    this.onSecondaryPointerUp(ev);
                }
            }
        }
        if ((ev.getAction() == 1 || ev.getAction() == 3) && (this.tryBackToRefreshing() || this.tryBackToFreshFinish() || this.mDraggedDispatch || this.mDraggedIntercept || this.mShouldCancelMotionEvent)) {
            ev.setAction(3);
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mNestedScrollInProgress || !this.isEnabled() || this.canChildScrollDown() && this.canChildScrollUp()) {
            return false;
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 0: {
                this.mActivePointerId = ev.getPointerId(0);
                this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                if (!this.mScroller.computeScrollOffset() || this.mScroller.isFinished()) break;
                this.mScroller.abortAnimation();
                this.mShouldCancelMotionEvent = true;
                break;
            }
            case 5: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = ev.getPointerId(pointerIndex);
                this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                break;
            }
            case 2: {
                float y = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                float yDiff = this.mDragBeginY - y;
                if (!(Math.abs(yDiff) > (float)this.mTouchSlop) || this.mDraggedIntercept || !(yDiff > 0.0f && !this.canChildScrollUp()) && (!(yDiff < 0.0f) || this.canChildScrollDown())) break;
                this.mDraggedIntercept = true;
                this.mDragLastY = y;
                this.mDragBeginDirect = -yDiff;
                if (this.mVelocityTracker == null) {
                    this.mVelocityTracker = VelocityTracker.obtain();
                } else {
                    this.mVelocityTracker.clear();
                }
                this.mVelocityTracker.addMovement(ev);
                ViewParent parent = this.getParent();
                if (parent == null) break;
                parent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return this.mDraggedIntercept;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int pointerIndex;
        switch (MotionEventCompat.getActionMasked((MotionEvent)ev)) {
            case 0: {
                this.mActivePointerId = ev.getPointerId(0);
                this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                if (this.mScroller.computeScrollOffset() && !this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                    this.mShouldCancelMotionEvent = true;
                }
                this.mDragLastY = (int)ev.getY();
                break;
            }
            case 5: {
                pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = ev.getPointerId(pointerIndex);
                this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                break;
            }
            case 2: {
                float y = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                int deltaY = (int)this.mDragBeginY - (int)y;
                if (!this.mDraggedIntercept && Math.abs(deltaY) > this.mTouchSlop) {
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.mDraggedIntercept = true;
                    this.mDragBeginDirect = -deltaY;
                    if (this.mVelocityTracker == null) {
                        this.mVelocityTracker = VelocityTracker.obtain();
                    } else {
                        this.mVelocityTracker.clear();
                    }
                    this.mVelocityTracker.addMovement(ev);
                }
                if (!this.mDraggedIntercept) break;
                this.offSetScroll((int)(this.mDragLastY - y), false);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                if (this.mDraggedIntercept && this.mVelocityTracker != null) {
                    this.mVelocityTracker.computeCurrentVelocity(1000, 6000.0f);
                    this.mVelocityTracker.getYVelocity();
                    int initialVelocity = (int)this.mVelocityTracker.getYVelocity();
                    this.fling(-initialVelocity);
                }
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                return true;
            }
        }
        pointerIndex = ev.findPointerIndex(this.mActivePointerId);
        if (pointerIndex >= 0) {
            this.mDragLastY = ev.getY(pointerIndex);
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(ev);
        }
        return true;
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept && this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
    }

    public void computeScroll() {
        int scrollY = this.getScrollY();
        if (this.mScroller.computeScrollOffset() && !this.mScroller.isFinished()) {
            int y = this.mScroller.getCurrY();
            if (y > this.mMaxFlingScrollButton || y < this.mMaxFlingScrollUp) {
                y = y > this.mMaxFlingScrollButton ? this.mMaxFlingScrollButton : y;
                y = y < this.mMaxFlingScrollUp ? this.mMaxFlingScrollUp : y;
                int remainVelocity = (int)((float)this.mMaxFlingDirection * this.mScroller.getCurrVelocity());
                if (this.mMaxFlingScrollDesView != null) {
                    if (this.mMaxFlingScrollDesView instanceof RecyclerView) {
                        RecyclerView recyclerView = (RecyclerView)this.mMaxFlingScrollDesView;
                        recyclerView.fling(0, remainVelocity);
                    } else if (this.mMaxFlingScrollDesView instanceof ListView) {
                        if (Build.VERSION.SDK_INT >= 21) {
                            ListView listView = (ListView)this.mMaxFlingScrollDesView;
                            listView.fling(remainVelocity);
                        }
                    } else if (this.mMaxFlingScrollDesView instanceof ScrollView) {
                        ScrollView scrollView = (ScrollView)this.mMaxFlingScrollDesView;
                        scrollView.fling(remainVelocity);
                    } else if (this.mMaxFlingScrollDesView instanceof NestedScrollView) {
                        NestedScrollView nestedScrollView = (NestedScrollView)this.mMaxFlingScrollDesView;
                        nestedScrollView.fling(remainVelocity);
                    }
                }
                this.mScroller.abortAnimation();
            }
            if (scrollY != y) {
                this.scrollTo(0, y);
                scrollY = y;
            }
        }
        if (scrollY > this.mContentScroll && !this.mLoadedStatusContinueRunning && this.mOnRefreshListener != null) {
            this.mLoadedStatusContinueRunning = true;
            this.mOnRefreshListener.onLoading();
        }
        if (scrollY > this.mContentScroll) {
            if (this.mLoadedStatus == ISwipe.LoadedStatus.NO_MORE) {
                this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_NO_MORE, scrollY - this.mContentScroll, this.mViewBottom.getHeight());
            } else if (this.mLoadedStatus == ISwipe.LoadedStatus.ERROR) {
                this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_ERROR, scrollY - this.mContentScroll, this.mViewBottom.getHeight());
            } else if (this.mLoadedStatus == null) {
                this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_LOADING, scrollY - this.mContentScroll, this.mViewBottom.getHeight());
            }
        }
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mDragLastY = (int)ev.getY(newPointerIndex);
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private boolean canChildScrollDown() {
        return this.mTargetView != null && ViewCompat.canScrollVertically((View)this.mTargetView, (int)-1);
    }

    private boolean canChildScrollUp() {
        return this.mTargetView != null && ViewCompat.canScrollVertically((View)this.mTargetView, (int)1);
    }

    private int offSetScroll(int deltaOriginY, boolean pre) {
        int middleHei;
        boolean progress;
        int currentScrollY = this.getScrollY();
        boolean bl = progress = !pre;
        if (pre) {
            if (currentScrollY < 0) {
                progress = true;
            } else if (currentScrollY > this.mContentScroll) {
                progress = true;
            } else {
                Integer scroll = this.mTargetViewContain != null ? (Integer)this.mTargetViewContain.getTag(0x40000000) : null;
                if (currentScrollY < (scroll = Integer.valueOf(scroll == null ? Integer.MAX_VALUE : scroll))) {
                    progress = true;
                }
                if (currentScrollY == scroll) {
                    progress = false;
                }
                if (currentScrollY > scroll) {
                    boolean bl2 = progress = !(deltaOriginY > 0 && this.canChildScrollUp() || deltaOriginY < 0 && this.canChildScrollDown());
                }
            }
        }
        if (!progress) {
            return 0;
        }
        int deltaY = deltaOriginY;
        if (deltaOriginY == 0) {
            return 0;
        }
        int n = middleHei = -this.overScrollTop != 0 ? -this.overScrollTop + this.mSwipeController.getOverScrollHei() : 0;
        if (deltaOriginY < 0 && currentScrollY < middleHei) {
            deltaY = (int)((double)deltaY * Math.pow((float)(this.mSwipeController.getOverScrollHei() - (middleHei - currentScrollY)) * 1.0f / (float)this.mSwipeController.getOverScrollHei(), 2.0));
        }
        int willTo = currentScrollY + deltaY;
        willTo = Math.min(willTo, this.overScrollBottom + this.mContentScroll);
        willTo = Math.max(willTo, -this.overScrollTop);
        Integer maxScroll = this.mTargetViewContain != null ? (Integer)this.mTargetViewContain.getTag(0x40000000) : null;
        if (currentScrollY > (maxScroll = Integer.valueOf(maxScroll == null ? Integer.MAX_VALUE : maxScroll)) && willTo < maxScroll || currentScrollY < maxScroll && willTo > maxScroll) {
            willTo = maxScroll;
        }
        if (this.mDragBeginDirect > 0.0f && willTo > this.mContentScroll) {
            willTo = this.mContentScroll;
        }
        if (this.mDragBeginDirect < 0.0f && willTo < 0) {
            willTo = 0;
        }
        if (this.mContentScroll == 0 && currentScrollY == 0 && deltaOriginY > 0 && !this.canChildScrollUp()) {
            willTo = 0;
        }
        if (willTo > this.mContentScroll) {
            for (int i = this.mTargetViewContainIndex; i < this.getChildCount() && i >= 0; ++i) {
                View child = this.getChildAt(i);
                if (child == this.mViewTop || child == this.mViewBottom || child.getVisibility() == 8 || child.getVisibility() == 4) continue;
                boolean find = child.canScrollVertically(-deltaOriginY);
                System.out.println("-------------------------------------XXXXXX------------------------" + find + "   " + child);
                find = child.canScrollVertically(deltaOriginY);
                System.out.println("-------------------------------------yyyyyy------------------------" + find + "   " + child);
                System.out.println("-------------------------------------------------------------" + deltaOriginY);
                if (!find) continue;
                System.out.println("------------------------------xxxxxxxxx-------------------------------" + deltaOriginY);
                child.scrollBy(0, deltaOriginY);
            }
        }
        if (willTo == currentScrollY) {
            return deltaOriginY;
        }
        this.scrollTo(0, willTo);
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(willTo, this.mContentScroll);
        }
        if (!(0 <= willTo || willTo <= middleHei || this.mFreshStatus != ISwipe.FreshStatus.ERROR && this.mFreshStatus != ISwipe.FreshStatus.ERROR_NET && this.mFreshStatus != ISwipe.FreshStatus.SUCCESS || this.mRefreshStatusContinueRunning)) {
            this.mFreshStatus = null;
        }
        if (0 > willTo) {
            int swipeViewVisibilityHei = 0 - willTo;
            if (this.mFreshStatus == null) {
                if (this.mRefreshStatusContinueRunning) {
                    this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_LOADING, swipeViewVisibilityHei, this.mViewTop.getHeight());
                } else if (willTo < middleHei) {
                    this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_OVER, swipeViewVisibilityHei, this.mViewTop.getHeight());
                } else {
                    this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_TOAST, swipeViewVisibilityHei, this.mViewTop.getHeight());
                }
            } else {
                switch (this.mFreshStatus) {
                    case SUCCESS: {
                        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_OK, swipeViewVisibilityHei, this.mViewTop.getHeight());
                        break;
                    }
                    case ERROR: {
                        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR, swipeViewVisibilityHei, this.mViewTop.getHeight());
                        break;
                    }
                    case ERROR_NET: {
                        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR_NET, swipeViewVisibilityHei, this.mViewTop.getHeight());
                    }
                }
            }
        }
        return deltaOriginY;
    }

    private boolean tryBackToRefreshing() {
        boolean isOverProgress;
        if (this.mIsTouchEventMode || this.mFreshStatus == ISwipe.FreshStatus.SUCCESS || this.mFreshStatus == ISwipe.FreshStatus.ERROR || this.mFreshStatus == ISwipe.FreshStatus.ERROR_NET) {
            return false;
        }
        int scrollY = this.getScrollY();
        int middleHei = this.overScrollTop != 0 ? -this.overScrollTop + this.mSwipeController.getOverScrollHei() : 0;
        boolean bl = isOverProgress = scrollY < middleHei;
        if (isOverProgress) {
            this.stopAllScroll();
            this.animationReBackToRefreshing = ValueAnimator.ofInt((int[])new int[]{scrollY, middleHei});
            this.animationReBackToRefreshing.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    if (value > SwipeNest.this.getScrollY()) {
                        SwipeNest.this.scrollTo(0, value);
                    }
                }
            });
            this.animationReBackToRefreshing.addListener(new Animator.AnimatorListener(){
                boolean isCancel = false;

                public void onAnimationEnd(Animator animation) {
                    if (!this.isCancel) {
                        if (SwipeNest.this.mFreshStatus == null) {
                            SwipeNest.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_LOADING, SwipeNest.this.mViewTop.getHeight(), SwipeNest.this.mViewTop.getHeight());
                        }
                        if (!SwipeNest.this.mRefreshStatusContinueRunning) {
                            SwipeNest.this.mRefreshStatusContinueRunning = true;
                            if (SwipeNest.this.mEmptyController != null) {
                                SwipeNest.this.mEmptyController.onSwipeStatue(null);
                            }
                            if (SwipeNest.this.mOnRefreshListener != null) {
                                SwipeNest.this.mOnRefreshListener.onRefresh();
                            }
                        }
                    }
                    this.isCancel = true;
                }

                public void onAnimationCancel(Animator animation) {
                    this.isCancel = true;
                }

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.animationReBackToRefreshing.setDuration((long)Math.abs(550 * (middleHei - scrollY) / this.mViewTop.getHeight()));
            this.animationReBackToRefreshing.start();
        }
        return isOverProgress;
    }

    private boolean tryBackToFreshFinish() {
        int middleHei;
        if (this.mIsTouchEventMode) {
            return false;
        }
        int scrollY = this.getScrollY();
        int n = middleHei = this.overScrollTop != 0 ? -this.overScrollTop + this.mSwipeController.getOverScrollHei() : 0;
        if (this.mFreshStatus == null && this.mRefreshStatusContinueRunning && scrollY == middleHei) {
            return false;
        }
        if (scrollY < 0) {
            this.stopAllScroll();
            this.animationReBackToTop = ValueAnimator.ofInt((int[])new int[]{scrollY, 0});
            this.animationReBackToTop.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    SwipeNest.this.scrollTo(0, value);
                }
            });
            this.animationReBackToTop.addListener(new Animator.AnimatorListener(){
                boolean isCancel;

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (!this.isCancel) {
                        SwipeNest.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_TOAST, 0, SwipeNest.this.mViewTop.getHeight());
                    }
                    this.isCancel = true;
                }

                public void onAnimationCancel(Animator animation) {
                    this.isCancel = true;
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            if (scrollY == middleHei) {
                this.animationReBackToTop.setDuration((long)Math.abs(550 * (0 - scrollY) / this.mViewTop.getHeight()));
                this.animationReBackToTop.setStartDelay(650L);
            } else {
                this.animationReBackToTop.setDuration(320L);
            }
            this.animationReBackToTop.start();
            return true;
        }
        return false;
    }

    private void stopAllScroll() {
        if (this.animationReBackToRefreshing != null) {
            this.animationReBackToRefreshing.cancel();
        }
        if (this.animationReBackToTop != null) {
            this.animationReBackToTop.cancel();
        }
        this.mScroller.abortAnimation();
    }

    @Override
    public void setOnRefreshListener(ISwipe.OnRefreshListener onRefreshListener) {
        this.mOnRefreshListener = onRefreshListener;
    }

    @Override
    public void refresh() {
        this.mFreshStatus = null;
        if (this.mEmptyController != null) {
            this.mEmptyController.onSwipeStatue(this.mFreshStatus);
        }
        this.mRefreshStatusContinueRunning = true;
        this.mLoadedStatus = null;
        this.mLoadedStatusContinueRunning = false;
        if (this.mOnRefreshListener != null) {
            this.mOnRefreshListener.onRefresh();
        }
        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_LOADING, -this.getScrollY(), this.mViewTop.getHeight());
        this.tryBackToRefreshing();
    }

    @Override
    public void setFreshResult(ISwipe.FreshStatus statue) {
        switch (statue) {
            case SUCCESS: {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SwipeNest.this.mFreshStatus = ISwipe.FreshStatus.SUCCESS;
                        if (SwipeNest.this.mEmptyController != null) {
                            SwipeNest.this.mEmptyController.onSwipeStatue(SwipeNest.this.mFreshStatus);
                        }
                        SwipeNest.this.mRefreshStatusContinueRunning = false;
                        SwipeNest.this.mLoadedStatus = null;
                        SwipeNest.this.mLoadedStatusContinueRunning = false;
                        SwipeNest.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_OK, -SwipeNest.this.getScrollY(), SwipeNest.this.mViewTop.getHeight());
                        SwipeNest.this.tryBackToFreshFinish();
                    }
                }, 1000L);
                break;
            }
            case ERROR_NET: {
                if (this.mEmptyController != null) {
                    this.mEmptyController.onSwipeStatue(this.mFreshStatus);
                }
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SwipeNest.this.mFreshStatus = ISwipe.FreshStatus.ERROR_NET;
                        if (SwipeNest.this.mEmptyController != null) {
                            SwipeNest.this.mEmptyController.onSwipeStatue(SwipeNest.this.mFreshStatus);
                        }
                        SwipeNest.this.mRefreshStatusContinueRunning = false;
                        SwipeNest.this.mLoadedStatus = null;
                        SwipeNest.this.mLoadedStatusContinueRunning = false;
                        SwipeNest.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR_NET, -SwipeNest.this.getScrollY(), SwipeNest.this.mViewTop.getHeight());
                        SwipeNest.this.tryBackToFreshFinish();
                    }
                }, 1000L);
                break;
            }
            case ERROR: {
                if (this.mEmptyController != null) {
                    this.mEmptyController.onSwipeStatue(this.mFreshStatus);
                }
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SwipeNest.this.mFreshStatus = ISwipe.FreshStatus.ERROR;
                        if (SwipeNest.this.mEmptyController != null) {
                            SwipeNest.this.mEmptyController.onSwipeStatue(SwipeNest.this.mFreshStatus);
                        }
                        SwipeNest.this.mRefreshStatusContinueRunning = false;
                        SwipeNest.this.mLoadedStatus = null;
                        SwipeNest.this.mLoadedStatusContinueRunning = false;
                        SwipeNest.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR, -SwipeNest.this.getScrollY(), SwipeNest.this.mViewTop.getHeight());
                        SwipeNest.this.tryBackToFreshFinish();
                    }
                }, 1000L);
            }
        }
    }

    @Override
    public void completeLoadMore() {
        int currentScrollY = this.getScrollY() - this.mContentScroll;
        if (currentScrollY > 0) {
            if (this.mTargetView instanceof RecyclerView || this.mTargetView instanceof ListView || this.mTargetView instanceof ScrollView || this.mTargetView instanceof NestedScrollView) {
                this.mTargetView.scrollBy(0, currentScrollY);
            }
            this.stopAllScroll();
            this.scrollTo(0, this.mContentScroll);
        }
        this.mLoadedStatusContinueRunning = false;
        this.mLoadedStatus = null;
        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_LOADING, this.getHeight() - this.mViewBottom.getTop(), this.mViewBottom.getHeight());
    }

    @Override
    public void setLoadMoreResult(ISwipe.LoadedStatus status) {
        switch (status) {
            case ERROR: {
                this.mLoadedStatusContinueRunning = true;
                this.mLoadedStatus = ISwipe.LoadedStatus.ERROR;
                this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_ERROR, this.getHeight() - this.mViewBottom.getTop(), this.mViewBottom.getHeight());
                break;
            }
            case NO_MORE: {
                this.mLoadedStatusContinueRunning = true;
                this.mLoadedStatus = ISwipe.LoadedStatus.NO_MORE;
                this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_NO_MORE, this.getHeight() - this.mViewBottom.getTop(), this.mViewBottom.getHeight());
            }
        }
    }

    @Override
    public void setSwipeModel(SwipeController.SwipeModel model) {
        if (this.mModel != model && model != null) {
            this.mModel = model;
            this.requestLayout();
        }
    }

    @Override
    public void setSwipeController(SwipeController control) {
        if (control != null && this.mSwipeController != control) {
            this.removeView(this.mViewTop);
            this.removeView(this.mViewBottom);
            this.mSwipeController = control;
            this.mViewTop = this.mSwipeController.getSwipeHead();
            this.mViewBottom = this.mSwipeController.getSwipeFoot();
            this.addView(this.mViewTop);
            this.addView(this.mViewBottom);
            this.requestLayout();
        }
    }

    @Override
    public void setEmptyController(EmptyController controller) {
        if (controller != null && this.mEmptyController != controller) {
            this.mEmptyController = controller;
            if (this.mEmptyView != null) {
                this.removeView(this.mEmptyView);
            }
            this.mEmptyView = controller.getView();
            this.mEmptyViewIndex = controller.attachToViewIndex();
            this.addView(this.mEmptyView);
            this.requestLayout();
        }
    }

    @Override
    public void enableEmptyView(boolean show) {
        if (this.mShowEmptyView != show) {
            this.mShowEmptyView = show;
            this.requestLayout();
            if (this.mEmptyReplaceView == this.mTargetViewContain && this.mShowEmptyView) {
                this.mTargetView = null;
                this.mTargetViewContain = null;
            }
        }
    }

    public void setOnScrollListener(OnScrollListener listener) {
        this.mOnScrollListener = listener;
    }

    public static interface OnScrollListener {
        public void onScroll(int var1, int var2);
    }
}

