/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.util.AttributeSet;
import android.view.View;
import com.powyin.scroll.R;

class CircleViewBac
extends View {
    BitmapDrawable bitmapDrawablePre;
    Paint arcPaint;
    RectF arcRectF;
    int wei;
    int hei;
    float progress;

    public CircleViewBac(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleViewBac(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.bitmapDrawablePre = (BitmapDrawable)context.getResources().getDrawable(R.drawable.powyin_scroll_progress_pre);
    }

    public void setProgress(float progress) {
        if (this.progress != progress) {
            this.progress = progress;
            this.invalidate();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.wei = w;
        this.hei = h;
        this.bitmapDrawablePre.setBounds(0, 0, this.wei, this.hei);
        this.arcRectF = new RectF(0.0f, 0.0f, (float)w, (float)h);
        this.arcPaint = new Paint();
        this.arcPaint.setStrokeWidth(2.0f);
        this.arcPaint.setStyle(Paint.Style.STROKE);
        this.arcPaint.setColor(-65536);
        this.arcPaint.setAntiAlias(true);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawImage(canvas);
    }

    private void drawCircle(Canvas canvas) {
        int sweepAngle = this.progress >= 0.0f && this.progress <= 1.0f ? (int)(360.0f * this.progress) : 360;
        canvas.drawArc(this.arcRectF, 90.0f, (float)sweepAngle, false, this.arcPaint);
    }

    private void drawImage(Canvas canvas) {
        int sweepAngle = this.progress <= 0.0f ? 0 : (this.progress >= 1.0f ? 180 : Math.min(180, (int)(180.0f * this.progress - 0.61f)));
        this.bitmapDrawablePre.setBounds(0, 0, this.wei, this.hei);
        canvas.save();
        canvas.rotate((float)sweepAngle, (float)(this.wei / 2), (float)(this.hei / 2));
        this.bitmapDrawablePre.draw(canvas);
        canvas.restore();
    }
}

